/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui.util;

import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import semorg.gui.ClientWindow;
import semorg.gui.CompanyInternalPresentationWindow;
import semorg.gui.CompanyWindow;
import semorg.gui.MainWindow;
import semorg.gui.PublicPresentationWindow;
import semorg.gui.SeminarTypeWindow;
import semorg.gui.list.ClientListWindow;
import semorg.gui.list.CompanyInternalPresentationListWindow;
import semorg.gui.list.CompanyListWindow;
import semorg.gui.list.PublicPresentationListWindow;
import semorg.gui.list.SeminarTypeListWindow;
import semorg.gui.util.Messages;
import semorg.sql.tables.AbstractTable;
import semorg.sql.tables.Client;
import semorg.sql.tables.Company;
import semorg.sql.tables.CompanyInternalPresentation;
import semorg.sql.tables.PublicPresentation;
import semorg.sql.tables.SeminarType;
import semorg.sql.util.DBConstraint;
import semorg.sql.util.DistinctVector;
import semorg.sql.util.Utility;

public class ForeignKeyConstraintSelector
extends Composite {
    public static final int FK_COMPANY = 1;
    public static final int FK_CLIENT = 2;
    public static final int FK_SEMINARTYPE = 3;
    public static final int FK_COMPANYINTERNALPRESENTATION = 4;
    public static final int FK_PUBLICPRESENTATION = 5;
    private final Text selectedValueText;
    private final ToolBar toolBar;
    private final ToolItem showListItem;
    private final ToolItem disconnectItem;
    private final ToolItem newItem;
    private final ToolItem deleteItem;
    private final int type;
    private int selectedId = 0;
    private boolean controlEnabled;

    public ForeignKeyConstraintSelector(Composite parent, int type) {
        super(parent, 0);
        this.type = type;
        this.controlEnabled = true;
        RowLayout mainLayout = new RowLayout();
        mainLayout.marginLeft = 0;
        mainLayout.marginRight = 0;
        mainLayout.marginTop = 0;
        mainLayout.marginBottom = 0;
        this.setLayout((Layout)mainLayout);
        this.selectedValueText = new Text((Composite)this, 2052);
        this.selectedValueText.setBackground(this.getDisplay().getSystemColor(15));
        this.selectedValueText.setEditable(false);
        RowData valueTextrowData = new RowData();
        valueTextrowData.width = 130;
        this.selectedValueText.setLayoutData((Object)valueTextrowData);
        this.toolBar = new ToolBar((Composite)this, 0x800000);
        this.newItem = new ToolItem(this.toolBar, 8);
        this.newItem.setImage(Utility.getImage("new.png"));
        this.newItem.setToolTipText(Messages.getString("GUIText.AddNewItemButtonToolTip"));
        this.newItem.setEnabled(true);
        this.newItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (ForeignKeyConstraintSelector.this.type) {
                    case 1: {
                        new CompanyWindow(ForeignKeyConstraintSelector.this.getShell(), null, ForeignKeyConstraintSelector.this);
                        break;
                    }
                    case 2: {
                        new ClientWindow(ForeignKeyConstraintSelector.this.getShell(), null, ForeignKeyConstraintSelector.this);
                        break;
                    }
                    case 3: {
                        new SeminarTypeWindow(ForeignKeyConstraintSelector.this.getShell(), null, ForeignKeyConstraintSelector.this);
                        break;
                    }
                    case 4: {
                        new CompanyInternalPresentationWindow(ForeignKeyConstraintSelector.this.getShell(), null, ForeignKeyConstraintSelector.this);
                        break;
                    }
                    case 5: {
                        new PublicPresentationWindow(ForeignKeyConstraintSelector.this.getShell(), null, ForeignKeyConstraintSelector.this);
                    }
                }
            }
        });
        this.showListItem = new ToolItem(this.toolBar, 8);
        this.showListItem.setImage(Utility.getImage("choose.png"));
        this.showListItem.setToolTipText(Messages.getString("GUIText.ChooseItemButtonToolTip"));
        this.showListItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (ForeignKeyConstraintSelector.this.type) {
                    case 1: {
                        new CompanyListWindow(ForeignKeyConstraintSelector.this);
                        break;
                    }
                    case 2: {
                        new ClientListWindow(ForeignKeyConstraintSelector.this);
                        break;
                    }
                    case 3: {
                        new SeminarTypeListWindow(ForeignKeyConstraintSelector.this);
                        break;
                    }
                    case 4: {
                        new CompanyInternalPresentationListWindow(ForeignKeyConstraintSelector.this);
                        break;
                    }
                    case 5: {
                        new PublicPresentationListWindow(ForeignKeyConstraintSelector.this);
                    }
                }
            }
        });
        this.disconnectItem = new ToolItem(this.toolBar, 8);
        this.disconnectItem.setImage(Utility.getImage("disconnect.png"));
        this.disconnectItem.setToolTipText(Messages.getString("GUIText.DisconnectItemButtonToolTip"));
        this.disconnectItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ForeignKeyConstraintSelector.this.setSelectedId(0);
            }
        });
        this.deleteItem = new ToolItem(this.toolBar, 8);
        this.deleteItem.setImage(Utility.getImage("delete.png"));
        this.deleteItem.setToolTipText(Messages.getString("GUIText.DeleteItemButtonToolTip"));
        this.deleteItem.setEnabled(false);
        this.deleteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ForeignKeyConstraintSelector.this.onDelete();
            }
        });
        this.setSelectedId(0);
    }

    private void updateText() {
        if (this.selectedId == 0) {
            this.selectedValueText.setText("");
        } else {
            Vector<DBConstraint> keyConstraint = new Vector<DBConstraint>();
            try {
                switch (this.type) {
                    case 1: {
                        keyConstraint.add(new DBConstraint(Company.getColumns().get(0).getInternalColumnName(), 0, new Integer(this.selectedId), 0));
                        DistinctVector<Company> companies = Company.getVectorFromDB(keyConstraint, null);
                        Company company = (Company)companies.iterator().next();
                        this.selectedValueText.setText(company.getShortName());
                        break;
                    }
                    case 2: {
                        keyConstraint.add(new DBConstraint(Client.getColumns().get(0).getInternalColumnName(), 0, new Integer(this.selectedId), 0));
                        DistinctVector<Client> clients = Client.getVectorFromDB(keyConstraint, null);
                        Client client = (Client)clients.iterator().next();
                        this.selectedValueText.setText(String.valueOf(client.getName()) + ", " + client.getFirstname());
                        break;
                    }
                    case 3: {
                        keyConstraint.add(new DBConstraint(SeminarType.getColumns().get(0).getInternalColumnName(), 0, new Integer(this.selectedId), 0));
                        DistinctVector<SeminarType> seminarTypes = SeminarType.getVectorFromDB(keyConstraint, null);
                        SeminarType seminarType = (SeminarType)seminarTypes.iterator().next();
                        this.selectedValueText.setText(seminarType.getShortTitle());
                        break;
                    }
                    case 4: {
                        keyConstraint.add(new DBConstraint(CompanyInternalPresentation.getColumns().get(0).getInternalColumnName(), 0, new Integer(this.selectedId), 0));
                        DistinctVector<CompanyInternalPresentation> companyInternalPresentations = CompanyInternalPresentation.getVectorFromDB(keyConstraint, null);
                        CompanyInternalPresentation companyInternalPresentation = (CompanyInternalPresentation)companyInternalPresentations.iterator().next();
                        this.selectedValueText.setText(companyInternalPresentation.getShortDescription());
                        break;
                    }
                    case 5: {
                        keyConstraint.add(new DBConstraint(PublicPresentation.getColumns().get(0).getInternalColumnName(), 0, new Integer(this.selectedId), 0));
                        DistinctVector<PublicPresentation> publicPresentations = PublicPresentation.getVectorFromDB(keyConstraint, null);
                        PublicPresentation publicPresentation = (PublicPresentation)publicPresentations.iterator().next();
                        this.selectedValueText.setText(publicPresentation.getShortDescription());
                    }
                }
            }
            catch (Exception e) {
                this.selectedId = 0;
                this.selectedValueText.setText("");
            }
        }
    }

    public void setSelectedId(int selectedId) {
        this.selectedId = selectedId;
        this.disconnectItem.setEnabled(this.controlEnabled && selectedId != 0);
        this.deleteItem.setEnabled(this.controlEnabled && selectedId != 0);
        this.updateText();
    }

    public void addModifyListener(ModifyListener listener) {
        this.selectedValueText.addModifyListener(listener);
    }

    public void setEnabled(boolean enabled) {
        this.controlEnabled = enabled;
        this.disconnectItem.setEnabled(this.controlEnabled && this.selectedId != 0);
        this.deleteItem.setEnabled(this.controlEnabled && this.selectedId != 0);
        this.showListItem.setEnabled(this.controlEnabled);
    }

    public void setData(String key, String value) {
        super.setData(key, (Object)value);
        if (key.equals("ATOSJ_COMPONENT_NAME_KEY")) {
            this.showListItem.setData(key, (Object)(String.valueOf(value) + "_opener"));
            this.disconnectItem.setData(key, (Object)(String.valueOf(value) + "_disconnector"));
            this.deleteItem.setData(key, (Object)(String.valueOf(value) + "_delete"));
            this.newItem.setData(key, (Object)(String.valueOf(value) + "_new"));
        }
    }

    private boolean isLockedId(int id) {
        switch (this.type) {
            case 1: {
                return Company.lockedIds.contains(new Integer(id));
            }
            case 2: {
                return Client.lockedIds.contains(new Integer(id));
            }
            case 3: {
                return SeminarType.lockedIds.contains(new Integer(id));
            }
            case 4: {
                return CompanyInternalPresentation.lockedIds.contains(new Integer(id));
            }
            case 5: {
                return PublicPresentation.lockedIds.contains(new Integer(id));
            }
        }
        return true;
    }

    private void onDelete() {
        if (this.selectedId != 0) {
            String question = this.determineDeleteMessage();
            MessageDialog dlg = new MessageDialog(MainWindow.getInstance().getShell(), Messages.getString("GUIText.DeleteItemMessageDialogTitle"), null, question, 3, new String[]{Messages.getString("GUIText.DeleteItemMessageDialogYesButtonText"), Messages.getString("GUIText.DeleteItemMessageDialogNoButtonText")}, 0);
            if (dlg.open() != 0) {
                return;
            }
            if (this.isLockedId(this.selectedId)) {
                MessageDialog.openInformation((Shell)MainWindow.getInstance().getShell(), (String)Messages.getString("GUIText.DeleteErrorDialogTitle"), (String)Messages.getString("GUIText.DeleteErrorDialogSingularText"));
                return;
            }
            try {
                if (this.deleteFromDB()) {
                    this.setSelectedId(0);
                    this.updateText();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private String determineDeleteMessage() {
        String question = "";
        switch (this.type) {
            case 1: {
                question = Messages.getString("GUIText.DeleteCompanyItemMessageDialogText");
                break;
            }
            case 2: {
                question = Messages.getString("GUIText.DeleteClientItemMessageDialogText");
                break;
            }
            case 3: {
                question = Messages.getString("GUIText.DeleteSeminarTypeItemMessageDialogText");
                break;
            }
            case 4: {
                question = Messages.getString("GUIText.DeleteCompanyInternalPresentationItemMessageDialogText");
                break;
            }
            case 5: {
                question = Messages.getString("GUIText.DeletePublicPresentationItemMessageDialogText");
            }
        }
        return question;
    }

    private boolean deleteFromDB() throws SQLException {
        DistinctVector<AbstractTable> idToDelete = new DistinctVector<AbstractTable>();
        switch (this.type) {
            case 1: {
                idToDelete.add(Company.getCompany(this.selectedId));
                Company.removeFromDB(idToDelete);
                return true;
            }
            case 2: {
                idToDelete.add(Client.getClient(this.selectedId));
                Client.removeFromDB(idToDelete);
                return true;
            }
            case 3: {
                idToDelete.add(SeminarType.getSeminarTypeFromDB(this.selectedId));
                SeminarType.removeFromDB(idToDelete);
                return true;
            }
            case 4: {
                idToDelete.add(CompanyInternalPresentation.getCompanyInternalPresentation(this.selectedId));
                CompanyInternalPresentation.removeFromDB(idToDelete);
                return true;
            }
            case 5: {
                idToDelete.add(PublicPresentation.getPresentation(this.selectedId));
                PublicPresentation.removeFromDB(idToDelete);
                return true;
            }
        }
        return false;
    }

    public int getSelectedId() {
        return this.selectedId;
    }
}

