/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import semorg.gui.util.Messages;
import semorg.sql.util.DBColumn;
import semorg.sql.util.DBConstraint;
import semorg.sql.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensibleSearchControl
extends Composite {
    private static final String[] conjunctions = new String[]{Messages.getString("GUIText.ExtensibleSearchControlAndText"), Messages.getString("GUIText.ExtensibleSearchControlOrText")};
    private static final String[] stringComparators = new String[]{"=", "<", ">", "!=", "~"};
    private static final String[] intComparators = new String[]{"=", "<", ">", "!="};
    private static final String[] floatComparators = new String[]{"=", "<", ">", "!="};
    private static final String[] dateComparators = new String[]{"=", "<", ">", "!="};
    private static final String[] timestampComparators = dateComparators;
    private static final String[] timeComparators = dateComparators;
    private static final String[] booleanComparators = new String[]{"="};
    private Vector<DBColumn> columns = null;
    private int filterExtensionCounter;
    private final Composite[] filterExtensions;
    private final ToolItem[] extenders;
    private final Combo[] conjunctionCombos;
    private final Combo[] columnCombos;
    private final Combo[] comparatorCombos;
    private final Text[] filterTexts;
    private Composite window = new Composite((Composite)this, 0);

    public ExtensibleSearchControl(Composite parent, int numberExtensions) {
        super(parent, 0);
        this.window.setLayout((Layout)new FormLayout());
        this.window.setLayoutData((Object)Utility.getFormData(0, 0, 0, (this.filterExtensionCounter + 1) * 26 - 1, 0, 1, 100, -1));
        this.filterExtensionCounter = 0;
        this.filterExtensions = new Composite[numberExtensions];
        this.extenders = new ToolItem[numberExtensions];
        this.conjunctionCombos = new Combo[numberExtensions];
        this.columnCombos = new Combo[numberExtensions + 1];
        this.comparatorCombos = new Combo[numberExtensions + 1];
        this.filterTexts = new Text[numberExtensions + 1];
        this.setLayout((Layout)new FormLayout());
        Label searchLabel = new Label(this.window, 8);
        searchLabel.setLayoutData((Object)Utility.getFormData(0, 6, null, 0, 0, 2, null, 0));
        searchLabel.setText(Messages.getString("GUIText.ExtensibleSearchControlText"));
        this.columnCombos[0] = new Combo(this.window, 12);
        this.columnCombos[0].setLayoutData((Object)Utility.getFormData(0, 3, null, 0, searchLabel, 20, searchLabel, 179));
        this.comparatorCombos[0] = new Combo(this.window, 12);
        this.comparatorCombos[0].setLayoutData((Object)Utility.getFormData(0, 3, null, 0, this.columnCombos[0], 3, this.columnCombos[0], 167));
        this.filterTexts[0] = new Text(this.window, 2052);
        this.filterTexts[0].setLayoutData((Object)Utility.getFormData(0, 3, 0, 24, this.comparatorCombos[0], 3, this.comparatorCombos[0], 167));
        ToolBar toolBar = new ToolBar(this.window, 0x800000);
        toolBar.setLayoutData((Object)Utility.getFormData(0, 3, null, 0, this.filterTexts[0], 1, null, 0));
        this.extenders[0] = new ToolItem(toolBar, 8);
        this.extenders[0].setImage(Utility.getImage("down.png"));
        this.extenders[0].addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (ExtensibleSearchControl.this.filterExtensionCounter == 0) {
                    ExtensibleSearchControl.this.extenders[0].setImage(Utility.getImage("up.png"));
                    ExtensibleSearchControl.this.extenders[1].setImage(Utility.getImage("down.png"));
                    ExtensibleSearchControl extensibleSearchControl = ExtensibleSearchControl.this;
                    extensibleSearchControl.filterExtensionCounter = extensibleSearchControl.filterExtensionCounter + 1;
                } else {
                    ExtensibleSearchControl.this.extenders[0].setImage(Utility.getImage("down.png"));
                    ExtensibleSearchControl.this.filterExtensionCounter = 0;
                }
                ExtensibleSearchControl.this.window.setLayoutData((Object)Utility.getFormData(0, 0, 0, (ExtensibleSearchControl.this.filterExtensionCounter + 1) * 26 - 1, 0, 1, 100, -1));
                ExtensibleSearchControl.this.pack();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        int i = 0;
        while (i < numberExtensions) {
            this.filterExtensions[i] = this.createFilterExtension(i);
            ++i;
        }
        this.pack();
    }

    private Composite createFilterExtension(final int number) {
        Composite filterExtension = new Composite(this.window, 0);
        filterExtension.setLayout((Layout)new FormLayout());
        this.conjunctionCombos[number] = new Combo(filterExtension, 12);
        this.conjunctionCombos[number].setLayoutData((Object)Utility.getFormData(0, (number + 1) * 26 + 3, null, 0, 0, 2, 0, 46));
        this.columnCombos[number + 1] = new Combo(filterExtension, 12);
        this.columnCombos[number + 1].setLayoutData((Object)Utility.getFormData(0, (number + 1) * 26 + 3, null, 0, this.conjunctionCombos[number], 7, this.conjunctionCombos[number], 179));
        this.comparatorCombos[number + 1] = new Combo(filterExtension, 12);
        this.comparatorCombos[number + 1].setLayoutData((Object)Utility.getFormData(0, (number + 1) * 26 + 3, null, 0, this.columnCombos[number + 1], 3, this.columnCombos[number + 1], 167));
        this.filterTexts[number + 1] = new Text(filterExtension, 2052);
        this.filterTexts[number + 1].setLayoutData((Object)Utility.getFormData(0, (number + 1) * 26 + 3, 0, (number + 1) * 26 + 24, this.comparatorCombos[number + 1], 3, this.comparatorCombos[number + 1], 167));
        ToolBar viewToolBar = new ToolBar(filterExtension, 0x800000);
        viewToolBar.setLayoutData((Object)Utility.getFormData(0, (number + 1) * 26 + 3, null, 0, this.filterTexts[number + 1], 1, null, 0));
        if (number < this.filterExtensions.length - 1) {
            this.extenders[number + 1] = new ToolItem(viewToolBar, 8);
            this.extenders[number + 1].setImage(Utility.getImage("down.png"));
            this.extenders[number + 1].addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    if (ExtensibleSearchControl.this.filterExtensionCounter <= number + 1) {
                        ExtensibleSearchControl.this.extenders[number + 1].setImage(Utility.getImage("up.png"));
                        if (number != ExtensibleSearchControl.this.extenders.length - 2) {
                            ExtensibleSearchControl.this.extenders[number + 2].setImage(Utility.getImage("down.png"));
                        }
                        ExtensibleSearchControl extensibleSearchControl = ExtensibleSearchControl.this;
                        extensibleSearchControl.filterExtensionCounter = extensibleSearchControl.filterExtensionCounter + 1;
                    } else {
                        ExtensibleSearchControl.this.extenders[number + 1].setImage(Utility.getImage("down.png"));
                        ExtensibleSearchControl.this.filterExtensionCounter = number + 1;
                    }
                    ExtensibleSearchControl.this.window.setLayoutData((Object)Utility.getFormData(0, 0, 0, (ExtensibleSearchControl.this.filterExtensionCounter + 1) * 26 - 1, 0, 1, 100, -1));
                    ExtensibleSearchControl.this.pack();
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }
            });
        }
        return filterExtension;
    }

    public void addExtensionListener(SelectionListener arg0) {
        int i = 0;
        while (i < this.filterExtensions.length) {
            this.extenders[i].addSelectionListener(arg0);
            ++i;
        }
    }

    public void addModifyListener(ModifyListener arg0) {
        int i = 0;
        while (i < this.filterTexts.length) {
            this.filterTexts[i].addModifyListener(arg0);
            ++i;
        }
    }

    public Vector<DBConstraint> getConstraints() throws Exception {
        Vector<DBConstraint> constraints = new Vector<DBConstraint>();
        int i = 0;
        while (i < this.filterExtensionCounter + 1) {
            DBColumn belongingColumn = this.getDBColumn(this.columnCombos[i].getText());
            String colName = belongingColumn.getInternalColumnName();
            int rel = DBConstraint.getRelation(this.comparatorCombos[i].getText());
            int conj = i == this.filterExtensionCounter ? 0 : DBConstraint.getConjunction(this.conjunctionCombos[i].getText());
            Class valClass = belongingColumn.getColumnType();
            String valueString = this.filterTexts[i].getText();
            Object value = valClass == Integer.class ? new Integer(Integer.parseInt(valueString)) : (valClass == Timestamp.class ? new Timestamp(Utility.dateOnlyFormatter.parse(valueString).getTime()) : (valClass == Time.class ? new Time(Utility.timeOnlyFormatter.parse(valueString).getTime()) : (valClass == Date.class ? Utility.dateOnlyFormatter.parse(valueString) : (valClass == Float.class ? Utility.parseFloat(valueString) : (valClass == Boolean.class ? (valueString.equalsIgnoreCase(Messages.getString("ProviderText.PresentationTableProviderIsCanceledText")) ? new Boolean(true) : new Boolean(valueString)) : valueString)))));
            constraints.add(new DBConstraint(colName, rel, value, conj));
            ++i;
        }
        return constraints;
    }

    public void setColumns(Vector<DBColumn> columns) {
        this.columns = columns;
        String[] columnStrings = new String[columns.size()];
        int i = 0;
        while (i < columnStrings.length) {
            columnStrings[i] = columns.get(i).getPublicColumnName();
            ++i;
        }
        i = 0;
        while (i < this.columnCombos.length) {
            final int currentIndex = i;
            if (i < this.conjunctionCombos.length) {
                this.conjunctionCombos[i].setItems(conjunctions);
                this.conjunctionCombos[i].setText(conjunctions[0]);
            }
            this.columnCombos[i].setItems(columnStrings);
            this.columnCombos[i].setText(this.columnCombos[i].getItem(0));
            this.columnCombos[i].addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    ExtensibleSearchControl.this.comparatorCombos[currentIndex].setItems(ExtensibleSearchControl.this.getComparatorString(ExtensibleSearchControl.this.columnCombos[currentIndex].getText()));
                    ExtensibleSearchControl.this.comparatorCombos[currentIndex].setText(ExtensibleSearchControl.this.comparatorCombos[currentIndex].getItem(0));
                }
            });
            this.comparatorCombos[i].setItems(this.getComparatorString(this.columnCombos[i].getText()));
            this.comparatorCombos[i].setText(this.comparatorCombos[i].getItem(0));
            ++i;
        }
    }

    private String[] getComparatorString(String publicColumnName) {
        DBColumn selectedColumn = this.getDBColumn(publicColumnName);
        if (selectedColumn.getColumnType() == Integer.class) {
            return intComparators;
        }
        if (selectedColumn.getColumnType() == String.class) {
            return stringComparators;
        }
        if (selectedColumn.getColumnType() == Time.class) {
            return timeComparators;
        }
        if (selectedColumn.getColumnType() == Timestamp.class) {
            return timestampComparators;
        }
        if (selectedColumn.getColumnType() == Date.class) {
            return dateComparators;
        }
        if (selectedColumn.getColumnType() == Float.class) {
            return floatComparators;
        }
        if (selectedColumn.getColumnType() == Boolean.class) {
            return booleanComparators;
        }
        return null;
    }

    private DBColumn getDBColumn(String publicColumnName) {
        DBColumn selectedColumn;
        Iterator<DBColumn> it = this.columns.iterator();
        while (!(selectedColumn = it.next()).getPublicColumnName().equals(publicColumnName)) {
        }
        return selectedColumn;
    }

    public void setData(String key, String value) {
        super.setData(key, (Object)value);
        if (key.equals("ATOSJ_COMPONENT_NAME_KEY")) {
            this.columnCombos[0].setData(key, (Object)(String.valueOf(value) + "_ColumnCombo"));
            this.comparatorCombos[0].setData(key, (Object)(String.valueOf(value) + "_ComparatorCombo"));
            this.filterTexts[0].setData(key, (Object)(String.valueOf(value) + "_FilterText"));
            int i = 0;
            while (i < this.extenders.length) {
                this.conjunctionCombos[i].setData(key, (Object)(String.valueOf(value) + "_ConjunctionCombo" + (i + 1)));
                this.columnCombos[i + 1].setData(key, (Object)(String.valueOf(value) + "_ColumnCombo" + (i + 1)));
                this.comparatorCombos[i + 1].setData(key, (Object)(String.valueOf(value) + "_ComparatorCombo" + (i + 1)));
                this.filterTexts[i + 1].setData(key, (Object)(String.valueOf(value) + "_FilterText" + (i + 1)));
                this.extenders[i].setData(key, (Object)(String.valueOf(value) + "_Extender" + (i + 1)));
                ++i;
            }
        }
    }
}

