/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui.util;

import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import semorg.gui.provider.DelayedPaymentItemTableProvider;
import semorg.gui.util.DBTableChangedListener;
import semorg.gui.util.DelayedPaymentItem;
import semorg.gui.util.Messages;
import semorg.sql.tables.AbstractTable;
import semorg.sql.tables.ClientBooking;
import semorg.sql.util.DBColumn;
import semorg.sql.util.DistinctVector;
import semorg.sql.util.Utility;

public class DelayedPaymentViewerControl
extends Composite {
    private TableViewer mainTableViewer;
    private int referencedFK;
    private Vector<DBColumn> columns;
    private DistinctVector<DBTableChangedListener> updateListeners;

    public DelayedPaymentViewerControl(Composite parent, Shell parentShell) {
        super(parent, 0);
        FormLayout mainLayout = new FormLayout();
        this.setLayout((Layout)mainLayout);
        this.mainTableViewer = new TableViewer((Composite)this, 67586);
        this.mainTableViewer.getTable().setLayoutData((Object)Utility.getFormData(parent, 2, 100, 0, 0, 0, 100, 0));
        this.mainTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mainTableViewer.setLabelProvider((IBaseLabelProvider)new DelayedPaymentItemTableProvider());
        Vector<DBColumn> tmp = ClientBooking.getColumns();
        this.columns = new Vector();
        this.columns.add(tmp.get(6));
        this.columns.add(tmp.get(3));
        this.columns.add(new DBColumn("charge", Messages.getString("GUIText.DelayedPaymentViewerControlChargeColumnText"), Float.class));
        Table mainTable = this.mainTableViewer.getTable();
        TableColumn[] tc = new TableColumn[this.columns.size()];
        mainTable.setHeaderVisible(true);
        int i = 0;
        while (i < tc.length) {
            tc[i] = new TableColumn(mainTable, 16384);
            tc[i].setWidth(110);
            tc[i].setText(this.columns.get(i).getPublicColumnName());
            ++i;
        }
        this.updateListeners = new DistinctVector();
        this.addUpdateListener(4);
        this.addUpdateListener(15);
        parentShell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                int i = 0;
                while (i < DelayedPaymentViewerControl.this.updateListeners.size()) {
                    AbstractTable.removeDBTableChangedListener((DBTableChangedListener)DelayedPaymentViewerControl.this.updateListeners.elementAt(i));
                    ++i;
                }
            }
        });
    }

    public void setInput(int referencedFK) throws SQLException {
        this.referencedFK = referencedFK;
        DistinctVector<DelayedPaymentItem> input = new DistinctVector<DelayedPaymentItem>();
        ClientBooking tmpClientBooking = null;
        if (this.referencedFK == 0) {
            this.mainTableViewer.setInput(new DistinctVector());
        } else {
            try {
                DistinctVector<ClientBooking> bookings = ClientBooking.getBookingsOfClient(this.referencedFK);
                int i = 0;
                while (i < bookings.size()) {
                    tmpClientBooking = (ClientBooking)bookings.elementAt(i);
                    if (tmpClientBooking.getDebitorId() == this.referencedFK) {
                        input.add(new DelayedPaymentItem(tmpClientBooking.getPresentationId(), tmpClientBooking.getBilled()));
                    }
                    ++i;
                }
                this.mainTableViewer.setInput(input);
            }
            catch (SQLException e) {
                this.mainTableViewer.setInput(null);
                throw e;
            }
        }
    }

    private void addUpdateListener(int type) {
        this.updateListeners.add(new DBTableChangedListener(type){

            public void dBTableChanged() {
                DelayedPaymentViewerControl.this.update();
            }
        });
        AbstractTable.addDBTableChangedListener((DBTableChangedListener)this.updateListeners.lastElement());
    }

    public void update() {
        try {
            this.setInput(this.referencedFK);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

