/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui.util;

import java.util.Vector;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TableColumn;
import semorg.gui.util.Messages;
import semorg.gui.util.TableColumnProperty;

public class ConfigureListWidget
extends Composite {
    private TableColumnProperty[] columnProperties;
    private ListViewer selectedColumnsViewer;
    private ListViewer deselectedColumnsViewer;
    private TableColumnPropertyContentProvider selectedColumnsCP = new TableColumnPropertyContentProvider();
    private TableColumnPropertyContentProvider deselectedColumnsCP = new TableColumnPropertyContentProvider();
    private List selectedColumns;
    private List deselectedColumns;

    public ConfigureListWidget(Composite parent, TableColumn[] currentColumns, int[] columnOrder) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(4, false));
        Label deselectedColumnsLabel = new Label((Composite)this, 0);
        deselectedColumnsLabel.setText(Messages.getString("GUIText.ConfigureListWidgetAvailableColumnsText"));
        GridData colLabelGD = new GridData();
        colLabelGD.horizontalSpan = 2;
        colLabelGD.horizontalAlignment = 4;
        deselectedColumnsLabel.setLayoutData((Object)colLabelGD);
        Label selectedColumnsLabel = new Label((Composite)this, 0);
        selectedColumnsLabel.setText(Messages.getString("GUIText.ConfigureListWidgetSelectedColumnsText"));
        selectedColumnsLabel.setLayoutData((Object)colLabelGD);
        this.columnProperties = new TableColumnProperty[currentColumns.length];
        int i = 0;
        while (i < currentColumns.length) {
            this.columnProperties[i] = new TableColumnProperty(i, columnOrder[i], currentColumns[i].getText(), currentColumns[i].getAlignment(), currentColumns[i].getWidth(), currentColumns[i].getResizable());
            ++i;
        }
        this.deselectedColumnsViewer = new ListViewer((Composite)this, 2564);
        this.deselectedColumnsViewer.setLabelProvider((IBaseLabelProvider)new TableColumnPropertyLabelProvider());
        this.deselectedColumnsViewer.setContentProvider((IContentProvider)this.deselectedColumnsCP);
        this.deselectedColumns = this.deselectedColumnsViewer.getList();
        Composite moveButtonsArea = new Composite((Composite)this, 0);
        this.selectedColumnsViewer = new ListViewer((Composite)this, 2564);
        this.selectedColumnsViewer.setLabelProvider((IBaseLabelProvider)new TableColumnPropertyLabelProvider());
        this.selectedColumnsViewer.setContentProvider((IContentProvider)this.selectedColumnsCP);
        this.selectedColumns = this.selectedColumnsViewer.getList();
        Composite detailsArea = new Composite((Composite)this, 0);
        final Button selectButton = new Button(moveButtonsArea, 8);
        final Button deselectButton = new Button(moveButtonsArea, 8);
        Button selectAllButton = new Button(moveButtonsArea, 8);
        Button deselectAllButton = new Button(moveButtonsArea, 8);
        Composite widthComp = new Composite(detailsArea, 0);
        Label widthLabel = new Label(widthComp, 0);
        widthLabel.setText(Messages.getString("GUIText.ConfigureListWidgetWidthText"));
        RowLayout widthCompLayout = new RowLayout(512);
        widthCompLayout.marginHeight = 0;
        widthCompLayout.marginLeft = 0;
        widthCompLayout.marginRight = 0;
        widthCompLayout.marginWidth = 0;
        widthCompLayout.spacing = 0;
        widthCompLayout.fill = true;
        widthComp.setLayout((Layout)widthCompLayout);
        final Spinner widthSpinner = new Spinner(widthComp, 2048);
        Composite orientationComp = new Composite(detailsArea, 0);
        Label orientationLabel = new Label(orientationComp, 0);
        orientationLabel.setText(Messages.getString("GUIText.ConfigureListWidgetOrientationText"));
        orientationComp.setLayout((Layout)widthCompLayout);
        final Combo orientationCombo = new Combo(orientationComp, 2056);
        final Button higherButton = new Button(detailsArea, 8);
        final Button lowerButton = new Button(detailsArea, 8);
        this.deselectedColumnsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                boolean isSthSelected = !evt.getSelection().isEmpty();
                selectButton.setEnabled(isSthSelected);
            }
        });
        this.deselectedColumnsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent evt) {
                ConfigureListWidget.this.onSelect();
            }
        });
        this.selectedColumnsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                boolean isSthSelected = !evt.getSelection().isEmpty();
                deselectButton.setEnabled(isSthSelected);
                higherButton.setEnabled(isSthSelected && ConfigureListWidget.this.selectedColumnsViewer.getList().getSelectionIndex() != 0);
                lowerButton.setEnabled(isSthSelected && ConfigureListWidget.this.selectedColumnsViewer.getList().getSelectionIndex() != ConfigureListWidget.this.selectedColumnsViewer.getList().getItemCount() - 1);
                widthSpinner.setEnabled(isSthSelected);
                orientationCombo.setEnabled(isSthSelected);
                if (isSthSelected) {
                    TableColumnProperty column = (TableColumnProperty)((StructuredSelection)ConfigureListWidget.this.selectedColumnsViewer.getSelection()).getFirstElement();
                    widthSpinner.setSelection(column.getWidth());
                    switch (column.getAlignment()) {
                        case 16384: {
                            orientationCombo.select(0);
                            break;
                        }
                        case 131072: {
                            orientationCombo.select(1);
                            break;
                        }
                        case 0x1000000: {
                            orientationCombo.select(2);
                            break;
                        }
                        default: {
                            orientationCombo.setText("");
                            break;
                        }
                    }
                } else {
                    widthSpinner.setSelection(0);
                }
                orientationCombo.setText("");
            }
        });
        this.selectedColumnsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent evt) {
                ConfigureListWidget.this.onDeselect();
            }
        });
        RowLayout moveAreaLayout = new RowLayout(512);
        moveAreaLayout.spacing = 10;
        moveButtonsArea.setLayout((Layout)moveAreaLayout);
        RowData buttonRowData = new RowData();
        buttonRowData.width = 50;
        selectButton.setText(">");
        selectButton.setEnabled(false);
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ConfigureListWidget.this.onSelect();
            }
        });
        selectButton.setLayoutData((Object)buttonRowData);
        deselectButton.setText("<");
        deselectButton.setEnabled(false);
        deselectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ConfigureListWidget.this.onDeselect();
            }
        });
        deselectButton.setLayoutData((Object)buttonRowData);
        selectAllButton.setText(">>");
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                Vector<TableColumnProperty> elements = (Vector<TableColumnProperty>)ConfigureListWidget.this.deselectedColumnsViewer.getInput();
                int i = 0;
                while (i < elements.size()) {
                    ((TableColumnProperty)elements.get(i)).setResizable(true);
                    ((TableColumnProperty)elements.get(i)).setWidth(100);
                    ++i;
                }
                elements = new Vector<TableColumnProperty>(elements);
                ConfigureListWidget.this.deselectedColumnsCP.removeAllColumns(elements);
                ConfigureListWidget.this.selectedColumnsCP.addAllColumns(elements);
            }
        });
        selectAllButton.setLayoutData((Object)buttonRowData);
        deselectAllButton.setText("<<");
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                Vector<TableColumnProperty> elements = (Vector<TableColumnProperty>)ConfigureListWidget.this.selectedColumnsViewer.getInput();
                int i = 0;
                while (i < elements.size()) {
                    ((TableColumnProperty)elements.get(i)).setResizable(false);
                    ((TableColumnProperty)elements.get(i)).setWidth(0);
                    ++i;
                }
                elements = new Vector<TableColumnProperty>(elements);
                ConfigureListWidget.this.selectedColumnsCP.removeAllColumns(elements);
                ConfigureListWidget.this.deselectedColumnsCP.addAllColumns(elements);
            }
        });
        deselectAllButton.setLayoutData((Object)buttonRowData);
        RowLayout detailsAreaLayout = new RowLayout(512);
        detailsAreaLayout.spacing = 8;
        detailsAreaLayout.fill = true;
        detailsArea.setLayout((Layout)detailsAreaLayout);
        RowData detailsRowData = new RowData();
        detailsRowData.width = 80;
        RowData innerDetailsRowData = new RowData();
        innerDetailsRowData.width = 50;
        widthComp.setLayoutData((Object)detailsRowData);
        widthSpinner.setLayoutData((Object)innerDetailsRowData);
        widthSpinner.setEnabled(false);
        widthSpinner.setMinimum(0);
        widthSpinner.setMaximum(500);
        widthSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TableColumnProperty selectedColumn = (TableColumnProperty)((StructuredSelection)ConfigureListWidget.this.selectedColumnsViewer.getSelection()).getFirstElement();
                selectedColumn.setWidth(widthSpinner.getSelection());
            }
        });
        orientationComp.setLayoutData((Object)detailsRowData);
        orientationCombo.setLayoutData((Object)innerDetailsRowData);
        orientationCombo.setEnabled(false);
        orientationCombo.add(Messages.getString("GUIText.ConfigureListWidgetOrientationLeftText"));
        orientationCombo.add(Messages.getString("GUIText.ConfigureListWidgetOrientationRightText"));
        orientationCombo.add(Messages.getString("GUIText.ConfigureListWidgetOrientationCenterText"));
        orientationCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TableColumnProperty selectedColumn = (TableColumnProperty)((StructuredSelection)ConfigureListWidget.this.selectedColumnsViewer.getSelection()).getFirstElement();
                switch (orientationCombo.getSelectionIndex()) {
                    case 0: {
                        selectedColumn.setAlignment(16384);
                        break;
                    }
                    case 1: {
                        selectedColumn.setAlignment(131072);
                        break;
                    }
                    case 2: {
                        selectedColumn.setAlignment(0x1000000);
                    }
                }
            }
        });
        higherButton.setText(Messages.getString("GUIText.ConfigureListWidgetHigherButtonText"));
        higherButton.setEnabled(false);
        higherButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TableColumnProperty selectedColumn = (TableColumnProperty)((StructuredSelection)ConfigureListWidget.this.selectedColumnsViewer.getSelection()).getFirstElement();
                ConfigureListWidget.this.selectedColumnsCP.moveUp(selectedColumn);
                higherButton.setEnabled(ConfigureListWidget.this.selectedColumnsViewer.getList().getSelectionIndex() != 0);
                lowerButton.setEnabled(ConfigureListWidget.this.selectedColumnsViewer.getList().getSelectionIndex() != ConfigureListWidget.this.selectedColumnsViewer.getList().getItemCount() - 1);
            }
        });
        higherButton.setLayoutData((Object)detailsRowData);
        lowerButton.setText(Messages.getString("GUIText.ConfigureListWidgetLowerButtonText"));
        lowerButton.setEnabled(false);
        lowerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TableColumnProperty selectedColumn = (TableColumnProperty)((StructuredSelection)ConfigureListWidget.this.selectedColumnsViewer.getSelection()).getFirstElement();
                ConfigureListWidget.this.selectedColumnsCP.moveDown(selectedColumn);
                higherButton.setEnabled(ConfigureListWidget.this.selectedColumnsViewer.getList().getSelectionIndex() != 0);
                lowerButton.setEnabled(ConfigureListWidget.this.selectedColumnsViewer.getList().getSelectionIndex() != ConfigureListWidget.this.selectedColumnsViewer.getList().getItemCount() - 1);
            }
        });
        lowerButton.setLayoutData((Object)detailsRowData);
        GridData listGD = new GridData();
        listGD.widthHint = 150;
        listGD.heightHint = 150;
        this.deselectedColumns.setLayoutData((Object)listGD);
        this.selectedColumns.setLayoutData((Object)listGD);
        this.setListViewerInputs(this.columnProperties, columnOrder);
    }

    private void setListViewerInputs(TableColumnProperty[] columns, int[] columnOrder) {
        Vector<TableColumnProperty> selectedColumnsVector = new Vector<TableColumnProperty>();
        Vector<TableColumnProperty> deselectedColumnsVector = new Vector<TableColumnProperty>();
        int i = 0;
        while (i < columns.length) {
            TableColumnProperty currentColumn = columns[columnOrder[i]];
            if (!currentColumn.getResizable() && currentColumn.getWidth() == 0) {
                deselectedColumnsVector.add(currentColumn);
            } else {
                selectedColumnsVector.add(currentColumn);
            }
            ++i;
        }
        this.selectedColumnsViewer.setInput(selectedColumnsVector);
        this.deselectedColumnsViewer.setInput(deselectedColumnsVector);
    }

    public void updateColumnNumbers() {
        int columnsDone = 0;
        int i = 0;
        while (i < this.selectedColumnsCP.input.size()) {
            ((TableColumnProperty)this.selectedColumnsCP.input.get(i)).setColumnNumber(columnsDone);
            ++columnsDone;
            ++i;
        }
        i = 0;
        while (i < this.deselectedColumnsCP.input.size()) {
            ((TableColumnProperty)this.deselectedColumnsCP.input.get(i)).setColumnNumber(columnsDone);
            ++columnsDone;
            ++i;
        }
    }

    public TableColumnProperty[] getColumns() {
        this.updateColumnNumbers();
        return this.columnProperties;
    }

    private void onSelect() {
        TableColumnProperty selectedColumn = (TableColumnProperty)((StructuredSelection)this.deselectedColumnsViewer.getSelection()).getFirstElement();
        selectedColumn.setResizable(true);
        selectedColumn.setWidth(100);
        this.deselectedColumnsCP.removeColumn(selectedColumn);
        this.selectedColumnsCP.addColumn(selectedColumn);
    }

    private void onDeselect() {
        TableColumnProperty selectedColumn = (TableColumnProperty)((StructuredSelection)this.selectedColumnsViewer.getSelection()).getFirstElement();
        selectedColumn.setResizable(false);
        selectedColumn.setWidth(0);
        this.selectedColumnsCP.removeColumn(selectedColumn);
        this.deselectedColumnsCP.addColumn(selectedColumn);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TableColumnPropertyContentProvider
    implements IStructuredContentProvider {
        private ListViewer listViewer;
        private Vector<TableColumnProperty> input;

        TableColumnPropertyContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null) {
                this.listViewer = (ListViewer)viewer;
                this.input = (Vector)newInput;
            }
        }

        public Object[] getElements(Object arg0) {
            return this.input.toArray();
        }

        public void dispose() {
        }

        public void addColumn(TableColumnProperty column) {
            this.input.add(column);
            this.listViewer.add((Object)column);
        }

        public void removeColumn(TableColumnProperty column) {
            this.input.remove(column);
            this.listViewer.remove((Object)column);
        }

        public void removeAllColumns(Vector<TableColumnProperty> columns) {
            this.input.removeAll(columns);
            this.listViewer.refresh();
        }

        public void addAllColumns(Vector<TableColumnProperty> columns) {
            this.input.addAll(columns);
            this.listViewer.refresh();
        }

        public Vector<TableColumnProperty> getInput() {
            return this.input;
        }

        public void moveUp(TableColumnProperty selectedColumn) {
            int index = this.input.indexOf(selectedColumn);
            this.input.remove(index);
            this.input.add(index - 1, selectedColumn);
            this.listViewer.refresh();
        }

        public void moveDown(TableColumnProperty selectedColumn) {
            int index = this.input.indexOf(selectedColumn);
            this.input.remove(index);
            this.input.add(index + 1, selectedColumn);
            this.listViewer.refresh();
        }
    }

    class TableColumnPropertyLabelProvider
    extends LabelProvider {
        TableColumnPropertyLabelProvider() {
        }

        public String getText(Object element) {
            return ((TableColumnProperty)element).getText();
        }
    }
}

