/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui.util;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import semorg.sql.util.Utility;

public class CalendarControl
extends Composite {
    private final Composite parent;
    private final Text t;
    private final Button openPopupButton;
    private final Button checker;
    private Date date;
    private int titleBarHeight;
    private Text backgroundHack;
    private boolean activated;
    private List<SWTCalendarListener> dateChangeListeners = new ArrayList<SWTCalendarListener>();
    private List<SWTCalendarPopupListener> popupListeners = new ArrayList<SWTCalendarPopupListener>();
    private SWTCalendarPopup popup;

    public CalendarControl(Composite par, int tbh) {
        super(par, 0);
        this.setLayout((Layout)new FormLayout());
        this.parent = par;
        this.checker = new Button((Composite)this, 32);
        this.checker.setLayoutData((Object)Utility.getFormData(0, 4, 0, 16, 0, 6, 0, 18));
        this.checker.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                boolean selected = CalendarControl.this.checker.getSelection();
                CalendarControl.this.setActivated(selected);
                if (selected) {
                    try {
                        CalendarControl.this.date = Utility.dateOnlyFormatter.parse(CalendarControl.this.t.getText());
                        CalendarControl.this.date = Utility.dateOnlyFormatter.parse(CalendarControl.this.t.getText());
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                CalendarControl.this.fireSWTCalendarDateChanged();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.date = new Date();
        this.t = new Text((Composite)this, 8);
        this.t.setBackground(par.getDisplay().getSystemColor(1));
        this.t.setLayoutData((Object)Utility.getFormData(0, 4, 0, 17, 0, 21, 0, 81));
        this.t.setText(Utility.dateOnlyFormatter.format(this.date));
        this.openPopupButton = new Button((Composite)this, 1028);
        this.openPopupButton.setLayoutData((Object)Utility.getFormData(0, 2, 0, 18, 0, 81, 0, 97));
        this.backgroundHack = new Text((Composite)this, 2056);
        this.backgroundHack.setEnabled(false);
        this.backgroundHack.setBackground(par.getDisplay().getSystemColor(1));
        this.backgroundHack.setLayoutData((Object)Utility.getFormData(0, 0, 0, 20, 0, 0, 0, 99));
        this.titleBarHeight = tbh;
        this.openPopupButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CalendarControl.this.onOpen();
            }
        });
        this.setActivated(false);
    }

    private void onOpen() {
        if (!this.activated) {
            this.setActivated(true);
        }
        this.fireSWTCalendarPopupOpened();
        try {
            this.popup = new SWTCalendarPopup();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void fireSWTCalendarPopupClosed() {
        for (SWTCalendarPopupListener listener : this.popupListeners) {
            Event event = new Event();
            event.widget = this;
            event.display = this.getDisplay();
            event.time = (int)System.currentTimeMillis();
            listener.popupClosed(new SWTCalendarEvent(event));
        }
    }

    private void fireSWTCalendarPopupOpened() {
        for (SWTCalendarPopupListener listener : this.popupListeners) {
            Event event = new Event();
            event.widget = this;
            event.display = this.getDisplay();
            event.time = (int)System.currentTimeMillis();
            listener.popupOpened(new SWTCalendarEvent(event));
        }
    }

    public void setActivated(boolean activ) {
        this.activated = activ;
        this.checker.setSelection(this.activated);
        if (this.activated) {
            this.t.setForeground(this.getDisplay().getSystemColor(2));
        } else {
            this.t.setForeground(this.getDisplay().getSystemColor(16));
        }
    }

    public Date getDate() {
        if (this.activated) {
            return this.date;
        }
        return null;
    }

    public void setFont(Font font) {
        this.t.setFont(font);
    }

    public void setDate(Date d) {
        if (this.activated) {
            this.getShell().forceActive();
        }
        this.date = d;
        this.setActivated(d != null);
        if (d != null) {
            this.t.setText(Utility.dateOnlyFormatter.format(this.date));
        } else {
            this.t.setText(Utility.dateOnlyFormatter.format(new Date()));
        }
    }

    public void addSWTCalendarPopuplistener(SWTCalendarPopupListener listener) {
        this.popupListeners.add(listener);
    }

    public void removeSWTCalendarPopuplistener(SWTCalendarPopupListener listener) {
        this.popupListeners.remove(listener);
    }

    public void addSWTCalendarlistener(SWTCalendarListener listener) {
        this.dateChangeListeners.add(listener);
    }

    public void removeSWTCalendarlistener(SWTCalendarListener listener) {
        this.dateChangeListeners.remove(listener);
    }

    private void fireSWTCalendarDateChanged() {
        for (SWTCalendarListener listener : this.dateChangeListeners) {
            Event event = new Event();
            event.widget = this;
            event.display = this.getDisplay();
            event.time = (int)System.currentTimeMillis();
            event.data = this.getDate();
            listener.dateChanged(new SWTCalendarEvent(event));
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.openPopupButton.setEnabled(enabled);
        this.t.setEnabled(enabled);
        this.checker.setEnabled(enabled);
    }

    public Button getOpenPopupButton() {
        return this.openPopupButton;
    }

    public boolean isPopupOpen() {
        return this.popup != null && this.popup.isOpen();
    }

    public void closePopup() {
        if (this.popup != null) {
            this.popup.close();
        }
    }

    public void setToolTipText(String toolTipText) {
        this.t.setToolTipText(toolTipText);
        this.openPopupButton.setToolTipText(toolTipText);
        this.checker.setToolTipText(toolTipText);
    }

    private class SWTCalendar
    extends Composite {
        public static final int RED_SUNDAY = 0x1000000;
        public static final int RED_WEEKEND = 0x11000000;
        private boolean settingDate;
        private Spinner yearChooser;
        private SWTMonthChooser monthChooser;
        private SWTDayChooser dayChooser;
        private boolean settingYearMonth;

        public SWTCalendar(Composite parent, int style) {
            super(parent, style & 0xEE7FFFFF);
            Calendar calendar = Calendar.getInstance();
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.horizontalSpacing = 2;
            gridLayout.verticalSpacing = 2;
            this.setLayout((Layout)gridLayout);
            Composite header = new Composite((Composite)this, 0);
            GridData gridData = new GridData(768);
            header.setLayoutData((Object)gridData);
            GridLayout gridLayout2 = new GridLayout();
            gridLayout2.numColumns = 3;
            gridLayout2.marginWidth = 0;
            gridLayout2.marginHeight = 0;
            header.setLayout((Layout)gridLayout2);
            Button prevMonthButton = new Button(header, 0x1004004 | style & 0x800000);
            prevMonthButton.setLayoutData((Object)new GridData(16));
            prevMonthButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SWTCalendar.this.previousMonth();
                }
            });
            Composite composite = new Composite(header, 0);
            composite.setLayoutData((Object)new GridData(576));
            GridLayout gridLayout3 = new GridLayout();
            gridLayout3.numColumns = 2;
            gridLayout3.marginWidth = 0;
            gridLayout3.marginHeight = 0;
            composite.setLayout((Layout)gridLayout3);
            header.setTabList(new Control[]{composite});
            this.monthChooser = new SWTMonthChooser(composite);
            this.monthChooser.setLayoutData(new GridData(1040));
            this.monthChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!SWTCalendar.this.settingYearMonth) {
                        SWTCalendar.this.dayChooser.setMonth(SWTCalendar.this.monthChooser.getMonth());
                    }
                }
            });
            this.yearChooser = new Spinner(composite, 2048);
            this.yearChooser.setLayoutData((Object)new GridData(16));
            this.yearChooser.setMinimum(1);
            this.yearChooser.setMaximum(9999);
            this.yearChooser.setSelection(calendar.get(1));
            this.yearChooser.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!SWTCalendar.this.settingYearMonth) {
                        SWTCalendar.this.dayChooser.setYear(SWTCalendar.this.yearChooser.getSelection());
                    }
                }
            });
            Button nextMonthButton = new Button(header, 0x1020004 | style & 0x800000);
            nextMonthButton.setLayoutData((Object)new GridData(16));
            nextMonthButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SWTCalendar.this.nextMonth();
                }
            });
            this.dayChooser = new SWTDayChooser(this, 0x800 | style & 0x11000000);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.dayChooser.setLayoutData(gridData);
            this.dayChooser.addSWTCalendarListener(new SWTCalendarListener(){

                public void dateChanged(SWTCalendarEvent event) {
                    SWTCalendar.this.refreshYearMonth(event.getCalendar());
                }
            });
            this.setTabList(new Control[]{header, this.dayChooser});
            this.setFont(parent.getFont());
        }

        public SWTCalendar(Composite parent) {
            this(parent, 0x800000);
        }

        public void setCalendar(Calendar cal) {
            this.settingDate = true;
            try {
                this.refreshYearMonth(cal);
                this.dayChooser.setCalendar(cal);
            }
            finally {
                this.settingDate = false;
            }
        }

        private void refreshYearMonth(Calendar cal) {
            this.settingYearMonth = true;
            this.yearChooser.setSelection(cal.get(1));
            this.monthChooser.setMonth(cal.get(2));
            this.settingYearMonth = false;
        }

        public void nextMonth() {
            Calendar cal = this.dayChooser.getCalendar();
            cal.add(2, 1);
            this.refreshYearMonth(cal);
            this.dayChooser.setCalendar(cal);
        }

        public void previousMonth() {
            Calendar cal = this.dayChooser.getCalendar();
            cal.add(2, -1);
            this.refreshYearMonth(cal);
            this.dayChooser.setCalendar(cal);
        }

        public Calendar getCalendar() {
            return this.dayChooser.getCalendar();
        }

        public void addSWTCalendarListener(SWTCalendarListener listener) {
            this.dayChooser.addSWTCalendarListener(listener);
        }

        public void removeSWTCalendarListener(SWTCalendarListener listener) {
            this.dayChooser.removeSWTCalendarListener(listener);
        }

        public void setLocale(Locale locale) {
            this.monthChooser.setLocale(locale);
            this.dayChooser.setLocale(locale);
            this.yearChooser.setSelection(this.getCalendar().get(1));
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.monthChooser.setFont(font);
            this.yearChooser.setFont(font);
            this.dayChooser.setFont(font);
        }

        public boolean isSettingDate() {
            return this.settingDate;
        }

        public void addMouseListener(MouseListener listener) {
            this.dayChooser.addRealMouseListener(listener);
        }

        public void removeMouseListener(MouseListener listener) {
            this.dayChooser.removeRealMouseListener(listener);
        }
    }

    public class SWTCalendarEvent
    extends TypedEvent {
        private static final long serialVersionUID = -5120399610511453497L;

        public SWTCalendarEvent(Event event) {
            super(event);
        }

        public Calendar getCalendar() {
            return (Calendar)this.data;
        }
    }

    public static interface SWTCalendarListener
    extends SWTEventListener {
        public void dateChanged(SWTCalendarEvent var1);
    }

    private class SWTCalendarPopup {
        final Shell popupShell;
        private SWTCalendar swtcal;

        SWTCalendarPopup() {
            this.popupShell = new Shell(CalendarControl.this.parent.getShell(), 2056);
            this.popupShell.setBackground(this.popupShell.getDisplay().getSystemColor(10));
            this.popupShell.addShellListener(new ShellListener(){

                public void shellActivated(ShellEvent arg0) {
                }

                public void shellClosed(ShellEvent arg0) {
                }

                public void shellDeactivated(ShellEvent arg0) {
                    SWTCalendarPopup.this.popupShell.close();
                    CalendarControl.this.fireSWTCalendarPopupClosed();
                }

                public void shellDeiconified(ShellEvent arg0) {
                }

                public void shellIconified(ShellEvent arg0) {
                }
            });
            Composite comp = CalendarControl.this.backgroundHack.getParent();
            int x = 2;
            int y = CalendarControl.this.titleBarHeight + ((CalendarControl)CalendarControl.this).backgroundHack.getSize().y;
            while (!(comp instanceof Shell)) {
                x += comp.getLocation().x;
                y += comp.getLocation().y;
                comp = comp.getParent();
            }
            x += comp.getLocation().x;
            y += comp.getLocation().y;
            this.popupShell.setLayout((Layout)new RowLayout());
            this.swtcal = new SWTCalendar((Composite)this.popupShell, 0x1000000);
            this.swtcal.addSWTCalendarListener(new SWTCalendarListener(){

                public void dateChanged(SWTCalendarEvent calendarEvent) {
                    Calendar calendar = calendarEvent.getCalendar();
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    CalendarControl.this.date = calendar.getTime();
                    CalendarControl.this.t.setText(Utility.dateOnlyFormatter.format(CalendarControl.this.date));
                }
            });
            this.swtcal.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent arg0) {
                }

                public void mouseDown(MouseEvent arg0) {
                    SWTCalendarPopup.this.popupShell.close();
                    CalendarControl.this.fireSWTCalendarDateChanged();
                }

                public void mouseUp(MouseEvent arg0) {
                }
            });
            if (CalendarControl.this.t.getText() != null && CalendarControl.this.t.getText().length() > 0) {
                try {
                    Date d = Utility.dateOnlyFormatter.parse(CalendarControl.this.t.getText());
                    this.setDate(d);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            this.popupShell.pack();
            this.popupShell.setLocation(new Point(x, y));
            this.popupShell.open();
        }

        public void setDate(Date date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            this.swtcal.setCalendar(calendar);
        }

        public void close() {
            if (this.isOpen()) {
                this.popupShell.close();
            }
        }

        public boolean isOpen() {
            return this.popupShell != null && !this.popupShell.isDisposed();
        }
    }

    public static interface SWTCalendarPopupListener
    extends SWTEventListener {
        public void popupOpened(SWTCalendarEvent var1);

        public void popupClosed(SWTCalendarEvent var1);
    }

    public class SWTDayChooser
    extends Composite
    implements MouseListener,
    FocusListener,
    TraverseListener,
    KeyListener {
        public static final int RED_SUNDAY = 0x1000000;
        public static final int RED_SATURDAY = 0x10000000;
        public static final int RED_WEEKEND = 0x11000000;
        private Label[] dayTitles;
        private DayControl[] days;
        private int dayOffset;
        private Color activeSelectionBackground;
        private Color inactiveSelectionBackground;
        private Color activeSelectionForeground;
        private Color inactiveSelectionForeground;
        private Color otherMonthColor;
        private Calendar calendar;
        private Calendar today;
        private Locale locale;
        private List<SWTCalendarListener> listeners;
        private int style;

        public SWTDayChooser(Composite parent, int style) {
            super(parent, style & 0xEEFFFFFF);
            this.style = style;
            this.listeners = new ArrayList<SWTCalendarListener>(3);
            this.setBackground(this.getDisplay().getSystemColor(1));
            this.otherMonthColor = new Color((Device)this.getDisplay(), 128, 128, 128);
            this.activeSelectionBackground = this.getDisplay().getSystemColor(26);
            this.inactiveSelectionBackground = this.getDisplay().getSystemColor(15);
            this.activeSelectionForeground = this.getDisplay().getSystemColor(27);
            this.inactiveSelectionForeground = this.getForeground();
            this.locale = Locale.getDefault();
            GridLayout gridLayout = new GridLayout();
            gridLayout.makeColumnsEqualWidth = true;
            gridLayout.numColumns = 7;
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
            this.setLayout((Layout)gridLayout);
            this.dayTitles = new Label[7];
            int i = 0;
            while (i < this.dayTitles.length) {
                Label label;
                this.dayTitles[i] = label = new Label((Composite)this, 0x1000000);
                label.setLayoutData((Object)new GridData(256));
                label.addMouseListener((MouseListener)this);
                ++i;
            }
            Composite spacer = new Composite((Composite)this, 524288);
            spacer.setBackground(this.getBackground());
            GridData gridData = new GridData(768);
            gridData.heightHint = 2;
            gridData.horizontalSpan = 7;
            spacer.setLayoutData((Object)gridData);
            spacer.setLayout((Layout)new GridLayout());
            spacer.addMouseListener((MouseListener)this);
            Label label = new Label((Composite)this, 258);
            gridData = new GridData(768);
            gridData.horizontalSpan = 7;
            label.setLayoutData((Object)gridData);
            this.days = new DayControl[42];
            i = 0;
            while (i < this.days.length) {
                DayControl day;
                this.days[i] = day = new DayControl(this);
                day.setLayoutData(new GridData(272));
                day.addMouseListener(this);
                ++i;
            }
            this.setTabList(new Control[0]);
            this.setFont(parent.getFont());
            this.init();
            this.addMouseListener(this);
            this.addFocusListener(this);
            this.addTraverseListener(this);
            this.addKeyListener(this);
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    SWTDayChooser.this.otherMonthColor.dispose();
                }
            });
        }

        protected void init() {
            this.calendar = Calendar.getInstance(this.locale);
            this.calendar.setLenient(true);
            this.today = (Calendar)this.calendar.clone();
            int firstDayOfWeek = this.calendar.getFirstDayOfWeek();
            DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
            String[] dayNames = dateFormatSymbols.getShortWeekdays();
            int minLength = Integer.MAX_VALUE;
            int i = 0;
            while (i < dayNames.length) {
                int len = dayNames[i].length();
                if (len > 0 && len < minLength) {
                    minLength = len;
                }
                ++i;
            }
            if (minLength > 2) {
                i = 0;
                while (i < dayNames.length) {
                    if (dayNames[i].length() > 0) {
                        dayNames[i] = dayNames[i].substring(0, 1);
                    }
                    ++i;
                }
            }
            int d = firstDayOfWeek;
            int i2 = 0;
            while (i2 < this.dayTitles.length) {
                Label label = this.dayTitles[i2];
                label.setText(dayNames[d]);
                label.setBackground(this.getBackground());
                if (d == 1 && (this.style & 0x1000000) != 0 || d == 7 && (this.style & 0x10000000) != 0) {
                    label.setForeground(this.getDisplay().getSystemColor(4));
                } else {
                    label.setForeground(this.getForeground());
                }
                if (++d > this.dayTitles.length) {
                    d -= this.dayTitles.length;
                }
                ++i2;
            }
            this.drawDays();
        }

        protected void drawDays() {
            this.calendar.get(6);
            Calendar cal = (Calendar)this.calendar.clone();
            int firstDayOfWeek = cal.getFirstDayOfWeek();
            cal.set(5, 1);
            this.dayOffset = firstDayOfWeek - cal.get(7);
            if (this.dayOffset >= 0) {
                this.dayOffset -= 7;
            }
            cal.add(5, this.dayOffset);
            Color foregroundColor = this.getForeground();
            int i = 0;
            while (i < this.days.length) {
                DayControl dayControl = this.days[i++];
                dayControl.setText(Integer.toString(cal.get(5)));
                if (this.isSameDay(cal, this.today)) {
                    dayControl.setBorderColor(this.getDisplay().getSystemColor(2));
                } else {
                    dayControl.setBorderColor(this.getBackground());
                }
                if (this.isSameMonth(cal, this.calendar)) {
                    int d = cal.get(7);
                    if (d == 1 && (this.style & 0x1000000) != 0 || d == 7 && (this.style & 0x10000000) != 0) {
                        dayControl.setForeground(this.getDisplay().getSystemColor(4));
                    } else {
                        dayControl.setForeground(foregroundColor);
                    }
                } else {
                    dayControl.setForeground(this.otherMonthColor);
                }
                if (this.isSameDay(cal, this.calendar)) {
                    dayControl.setBackground(this.getSelectionBackgroundColor());
                    dayControl.setForeground(this.getSelectionForegroundColor());
                } else {
                    dayControl.setBackground(this.getBackground());
                }
                cal.add(5, 1);
            }
        }

        private boolean isSameDay(Calendar cal1, Calendar cal2) {
            return cal1.get(6) == cal2.get(6) && cal1.get(1) == cal2.get(1);
        }

        private boolean isSameMonth(Calendar cal1, Calendar cal2) {
            return cal1.get(2) == cal2.get(2) && cal1.get(1) == cal2.get(1);
        }

        public void setMonth(int month) {
            this.calendar.set(2, month);
            this.drawDays();
            this.dateChanged();
        }

        public void setYear(int year) {
            this.calendar.set(1, year);
            this.drawDays();
            this.dateChanged();
        }

        public void setCalendar(Calendar cal) {
            this.calendar = (Calendar)cal.clone();
            this.calendar.setLenient(true);
            this.drawDays();
            this.dateChanged();
        }

        public void mouseDown(MouseEvent event) {
            if (event.button == 1) {
                this.setFocus();
                if (event.widget instanceof DayControl) {
                    int index = this.findDay(event.widget);
                    this.selectDay(index + 1 + this.dayOffset);
                }
            }
        }

        public void mouseDoubleClick(MouseEvent event) {
        }

        public void mouseUp(MouseEvent event) {
        }

        public void focusGained(FocusEvent event) {
            DayControl selectedDay = this.getSelectedDayControl();
            selectedDay.setBackground(this.getSelectionBackgroundColor());
            selectedDay.setForeground(this.getSelectionForegroundColor());
        }

        public void focusLost(FocusEvent event) {
            DayControl selectedDay = this.getSelectedDayControl();
            selectedDay.setBackground(this.getSelectionBackgroundColor());
            selectedDay.setForeground(this.getSelectionForegroundColor());
        }

        public void keyTraversed(TraverseEvent event) {
            switch (event.detail) {
                case 32: 
                case 64: 
                case 256: 
                case 512: {
                    event.doit = false;
                    break;
                }
                case 8: 
                case 16: {
                    event.doit = true;
                }
            }
        }

        public void keyPressed(KeyEvent event) {
            switch (event.keyCode) {
                case 0x1000003: {
                    this.selectDay(this.calendar.get(5) - 1);
                    break;
                }
                case 0x1000004: {
                    this.selectDay(this.calendar.get(5) + 1);
                    break;
                }
                case 0x1000001: {
                    this.selectDay(this.calendar.get(5) - 7);
                    break;
                }
                case 0x1000002: {
                    this.selectDay(this.calendar.get(5) + 7);
                    break;
                }
                case 0x1000005: {
                    this.setMonth(this.calendar.get(2) - 1);
                    break;
                }
                case 0x1000006: {
                    this.setMonth(this.calendar.get(2) + 1);
                }
            }
        }

        public void keyReleased(KeyEvent event) {
        }

        private int findDay(Widget dayControl) {
            int i = 0;
            while (i < this.days.length) {
                if (this.days[i] == dayControl) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private void selectDay(int day) {
            this.calendar.get(6);
            if (day >= this.calendar.getActualMinimum(5) && day <= this.calendar.getActualMaximum(5)) {
                int dayOfWeek = this.calendar.get(7);
                DayControl selectedDay = this.getSelectedDayControl();
                selectedDay.setBackground(this.getBackground());
                if (dayOfWeek == 1) {
                    selectedDay.setForeground(this.getDisplay().getSystemColor(4));
                } else {
                    selectedDay.setForeground(this.getForeground());
                }
                this.calendar.set(5, day);
                selectedDay = this.getSelectedDayControl();
                selectedDay.setBackground(this.getSelectionBackgroundColor());
                selectedDay.setForeground(this.getSelectionForegroundColor());
            } else {
                this.calendar.set(5, day);
                this.drawDays();
            }
            this.dateChanged();
        }

        private DayControl getSelectedDayControl() {
            return this.days[this.calendar.get(5) - 1 - this.dayOffset];
        }

        private Color getSelectionBackgroundColor() {
            return this.isFocusControl() ? this.activeSelectionBackground : this.inactiveSelectionBackground;
        }

        private Color getSelectionForegroundColor() {
            return this.isFocusControl() ? this.activeSelectionForeground : this.inactiveSelectionForeground;
        }

        public boolean isFocusControl() {
            Control control = this.getDisplay().getFocusControl();
            while (control != null) {
                if (control == this) {
                    return true;
                }
                control = control.getParent();
            }
            return false;
        }

        public void addSWTCalendarListener(SWTCalendarListener listener) {
            this.listeners.add(listener);
        }

        public void removeSWTCalendarListener(SWTCalendarListener listener) {
            this.listeners.remove(listener);
        }

        private void dateChanged() {
            if (!this.listeners.isEmpty()) {
                SWTCalendarListener[] listenersArray = new SWTCalendarListener[this.listeners.size()];
                this.listeners.toArray(listenersArray);
                int i = 0;
                while (i < listenersArray.length) {
                    Event event = new Event();
                    event.widget = this;
                    event.display = this.getDisplay();
                    event.time = (int)System.currentTimeMillis();
                    event.data = this.calendar.clone();
                    listenersArray[i].dateChanged(new SWTCalendarEvent(event));
                    ++i;
                }
            }
        }

        public Calendar getCalendar() {
            return (Calendar)this.calendar.clone();
        }

        public void setLocale(Locale locale) {
            this.locale = locale;
            this.init();
        }

        public void setFont(Font font) {
            super.setFont(font);
            int i = 0;
            while (i < this.dayTitles.length) {
                this.dayTitles[i].setFont(font);
                ++i;
            }
            i = 0;
            while (i < this.days.length) {
                this.days[i].setFont(font);
                ++i;
            }
        }

        public void addRealMouseListener(MouseListener listener) {
            int i = 0;
            while (i < this.days.length) {
                this.days[i].addMouseListener(listener);
                ++i;
            }
        }

        public void removeRealMouseListener(MouseListener listener) {
            int i = 0;
            while (i < this.days.length) {
                this.days[i].removeMouseListener(listener);
                ++i;
            }
        }

        public class DayControl
        extends Composite
        implements Listener {
            private Composite filler;
            private Label label;

            public DayControl(Composite parent) {
                super(parent, 524288);
                GridLayout gridLayout = new GridLayout();
                gridLayout.marginWidth = 1;
                gridLayout.marginHeight = 1;
                this.setLayout((Layout)gridLayout);
                this.filler = new Composite((Composite)this, 524288);
                this.filler.setLayoutData((Object)new GridData(1808));
                gridLayout = new GridLayout();
                gridLayout.marginWidth = 2;
                gridLayout.marginHeight = 0;
                this.filler.setLayout((Layout)gridLayout);
                this.filler.addListener(3, (Listener)this);
                this.filler.addListener(4, (Listener)this);
                this.filler.addListener(8, (Listener)this);
                this.label = new DayLabel(this.filler, 655360);
                this.label.setLayoutData((Object)new GridData(576));
                this.label.addListener(3, (Listener)this);
                this.label.addListener(4, (Listener)this);
                this.label.addListener(8, (Listener)this);
                this.setBorderColor(parent.getBackground());
                this.setBackground(parent.getBackground());
                this.setFont(parent.getFont());
            }

            public void setText(String text) {
                this.label.setText(text);
            }

            public String getText() {
                return this.label.getText();
            }

            public void setFont(Font font) {
                super.setFont(font);
                this.filler.setFont(font);
                this.label.setFont(font);
            }

            public void setBackground(Color color) {
                this.filler.setBackground(color);
                this.label.setBackground(color);
            }

            public void setForeground(Color color) {
                this.label.setForeground(color);
            }

            public void setBorderColor(Color color) {
                super.setBackground(color);
            }

            public void handleEvent(Event event) {
                this.notifyListeners(event.type, event);
            }
        }

        public class DayLabel
        extends Label {
            public DayLabel(Composite parent, int style) {
                super(parent, style);
            }

            public Point computeSize(int wHint, int hHint, boolean changed) {
                if (wHint == -1) {
                    GC gc = new GC((Drawable)this);
                    wHint = gc.textExtent((String)"22").x;
                    gc.dispose();
                }
                return super.computeSize(wHint, hHint, changed);
            }

            protected void checkSubclass() {
            }
        }
    }

    private class SWTMonthChooser
    extends Composite {
        private Combo comboBox;
        private Locale locale;

        public SWTMonthChooser(Composite parent) {
            super(parent, 0);
            this.locale = Locale.getDefault();
            this.setLayout((Layout)new FillLayout());
            this.comboBox = new Combo((Composite)this, 12);
            this.initNames();
            this.setMonth(Calendar.getInstance().get(2));
            this.setFont(parent.getFont());
        }

        private void initNames() {
            DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
            String[] monthNames = dateFormatSymbols.getMonths();
            int month = this.comboBox.getSelectionIndex();
            if (this.comboBox.getItemCount() > 0) {
                this.comboBox.removeAll();
            }
            int i = 0;
            while (i < monthNames.length) {
                String name = monthNames[i];
                if (name.length() > 0) {
                    this.comboBox.add(name);
                }
                ++i;
            }
            if (month < 0) {
                month = 0;
            } else if (month >= this.comboBox.getItemCount()) {
                month = this.comboBox.getItemCount() - 1;
            }
            this.comboBox.select(month);
        }

        public void addSelectionListener(SelectionListener listener) {
            this.comboBox.addSelectionListener(listener);
        }

        public void removeSelectionListener(SelectionListener listener) {
            this.comboBox.removeSelectionListener(listener);
        }

        public void setMonth(int newMonth) {
            this.comboBox.select(newMonth);
        }

        public int getMonth() {
            return this.comboBox.getSelectionIndex();
        }

        public void setLocale(Locale locale) {
            this.locale = locale;
            this.initNames();
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.comboBox.setFont(this.getFont());
        }
    }
}

