/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui.util;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import semorg.gui.ClientBookingWindow;
import semorg.gui.ClientWindow;
import semorg.gui.CompanyBookingWindow;
import semorg.gui.CompanyInternalPresentationWindow;
import semorg.gui.LecturerWindow;
import semorg.gui.MainWindow;
import semorg.gui.PublicPresentationWindow;
import semorg.gui.SeminarTypeWindow;
import semorg.gui.list.ClientBookingListWindow;
import semorg.gui.list.ClientListWindow;
import semorg.gui.list.CompanyBookingListWindow;
import semorg.gui.list.LecturerListWindow;
import semorg.gui.list.PresentationListWindow;
import semorg.gui.list.SeminarTypeListWindow;
import semorg.gui.provider.ClientBookingTableProvider;
import semorg.gui.provider.ClientTableProvider;
import semorg.gui.provider.CompanyBookingTableProvider;
import semorg.gui.provider.LecturerTableProvider;
import semorg.gui.provider.PresentationTableProvider;
import semorg.gui.provider.SeminarTypeTableProvider;
import semorg.gui.util.ConfigureListDlg;
import semorg.gui.util.DBTableChangedListener;
import semorg.gui.util.ItemListener;
import semorg.gui.util.Messages;
import semorg.gui.util.TableColumnProperty;
import semorg.sql.tables.AbstractTable;
import semorg.sql.tables.Client;
import semorg.sql.tables.ClientBooking;
import semorg.sql.tables.CompanyBooking;
import semorg.sql.tables.CompanyInternalPresentation;
import semorg.sql.tables.Conduct;
import semorg.sql.tables.Instructor;
import semorg.sql.tables.Lecturer;
import semorg.sql.tables.Presentation;
import semorg.sql.tables.PublicPresentation;
import semorg.sql.tables.SeminarType;
import semorg.sql.tables.SimpleIDKey;
import semorg.sql.tables.Supervisor;
import semorg.sql.util.DBColumn;
import semorg.sql.util.DistinctVector;
import semorg.sql.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationTabControl
extends Composite {
    public static final int TYPE_EMPLOYEE = 1;
    public static final int TYPE_CLIENTBOOKING_CLIENT = 2;
    public static final int TYPE_COMPANYBOOKING_COMPANY = 3;
    public static final int TYPE_PRESENTATION_SUPERVISOR = 4;
    public static final int TYPE_PRESENTATION_INSTRUCTOR = 5;
    public static final int TYPE_SEMINARTYPE_CONDUCT = 6;
    public static final int TYPE_COMPANYBOOKING_PRESENTATION = 7;
    public static final int TYPE_LECTURER_INSTRUCTOR = 8;
    public static final int TYPE_LECTURER_SUPERVISOR = 9;
    public static final int TYPE_PRESENTATION_SEMTYPE = 10;
    public static final int TYPE_LECTURER_CONDUCT = 11;
    public static final int TYPE_CLIENTBOOKING_PRESENTATION = 12;
    private TableViewer mainTableViewer;
    private int style;
    private int referencedFK;
    private boolean enabled;
    private Vector<DBColumn> columns;
    private Set<ItemListener> itemListeners = new HashSet<ItemListener>();
    private DistinctVector<DBTableChangedListener> updateListeners;
    private ToolItem disconnectItem;
    private ToolItem deleteItem;
    private ToolItem configureItem;
    private ToolItem chooseItem;
    private ToolItem editItem;
    private ToolItem newItem;
    private DistinctVector<SimpleIDKey> previouslySelectedIds = new DistinctVector();
    private DistinctVector<SimpleIDKey> idsToDelete = new DistinctVector();

    public AssociationTabControl(Composite parent, int style, Shell parentShell) {
        super(parent, 0);
        this.style = style;
        FormLayout mainLayout = new FormLayout();
        this.setLayout((Layout)mainLayout);
        ToolBar buttonToolBar = new ToolBar((Composite)this, 0x800000);
        buttonToolBar.setLayoutData((Object)Utility.getFormData(0, 0, null, 0, null, 0, 100, 0));
        this.newItem = new ToolItem(buttonToolBar, 0);
        this.newItem.setImage(Utility.getImage("new.png"));
        this.newItem.setToolTipText(Messages.getString("GUIText.AddNewItemButtonToolTip"));
        this.newItem.setEnabled(true);
        this.newItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AssociationTabControl.this.openNewItemWindow();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.editItem = new ToolItem(buttonToolBar, 0);
        this.editItem.setImage(Utility.getImage("edit.png"));
        this.editItem.setToolTipText(Messages.getString("GUIText.EditItemButtonToolTip"));
        this.editItem.setEnabled(false);
        this.editItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AssociationTabControl.this.openEditItemWindow();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.chooseItem = new ToolItem(buttonToolBar, 0);
        this.chooseItem.setImage(Utility.getImage("choose.png"));
        this.chooseItem.setToolTipText(Messages.getString("GUIText.ChooseItemButtonToolTip"));
        this.chooseItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AssociationTabControl.this.openListWindow();
            }
        });
        this.disconnectItem = new ToolItem(buttonToolBar, 0);
        this.disconnectItem.setImage(Utility.getImage("disconnect.png"));
        this.disconnectItem.setToolTipText(Messages.getString("GUIText.DisconnectItemButtonToolTip"));
        this.disconnectItem.setEnabled(false);
        this.disconnectItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AssociationTabControl.this.onDisconnect();
            }
        });
        this.deleteItem = new ToolItem(buttonToolBar, 8);
        this.deleteItem.setImage(Utility.getImage("delete.png"));
        this.deleteItem.setToolTipText(Messages.getString("GUIText.DeleteItemButtonToolTip"));
        this.deleteItem.setEnabled(false);
        this.deleteItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AssociationTabControl.this.onDelete();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.configureItem = new ToolItem(buttonToolBar, 8);
        this.configureItem.setImage(Utility.getImage("configure.png"));
        this.configureItem.setToolTipText(Messages.getString("GUIText.ConfigureListItemButtonToolTip"));
        this.configureItem.setEnabled(true);
        this.configureItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ConfigureListDlg dlg = new ConfigureListDlg(Display.getCurrent().getActiveShell(), AssociationTabControl.this.mainTableViewer.getTable().getColumns(), AssociationTabControl.this.mainTableViewer.getTable().getColumnOrder());
                if (dlg.open() == 0) {
                    this.copyColumnProperties(dlg.getColumnProperties());
                }
            }

            private void copyColumnProperties(TableColumnProperty[] dlgColumnProperties) {
                TableColumn[] tableColumns = AssociationTabControl.this.mainTableViewer.getTable().getColumns();
                int[] columnOrder = new int[tableColumns.length];
                int i = 0;
                while (i < tableColumns.length) {
                    tableColumns[i].setWidth(dlgColumnProperties[i].getWidth());
                    tableColumns[i].setResizable(dlgColumnProperties[i].getResizable());
                    tableColumns[i].setAlignment(dlgColumnProperties[i].getAlignment());
                    columnOrder[dlgColumnProperties[i].getColumnNumber()] = dlgColumnProperties[i].getIndex();
                    ++i;
                }
                AssociationTabControl.this.mainTableViewer.getTable().setColumnOrder(columnOrder);
            }
        });
        this.mainTableViewer = new TableViewer((Composite)this, 67586);
        this.mainTableViewer.getTable().setLayoutData((Object)Utility.getFormData(buttonToolBar, 2, 100, 0, 0, 0, 100, 0));
        this.mainTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mainTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AssociationTabControl.this.disconnectItem.setEnabled(!AssociationTabControl.this.mainTableViewer.getSelection().isEmpty() && AssociationTabControl.this.enabled);
                AssociationTabControl.this.editItem.setEnabled(!AssociationTabControl.this.mainTableViewer.getSelection().isEmpty() && AssociationTabControl.this.enabled);
                AssociationTabControl.this.deleteItem.setEnabled(!AssociationTabControl.this.mainTableViewer.getSelection().isEmpty() && AssociationTabControl.this.enabled);
            }
        });
        this.configureClassSpecificViewerParts();
        Table mainTable = this.mainTableViewer.getTable();
        TableColumn[] tc = new TableColumn[this.columns.size()];
        mainTable.setHeaderVisible(true);
        int i = 0;
        while (i < tc.length) {
            tc[i] = new TableColumn(mainTable, 16384);
            tc[i].setWidth(100);
            tc[i].setText(this.columns.get(i).getPublicColumnName());
            ++i;
        }
        this.updateListeners = new DistinctVector();
        this.addUpdateListener();
        parentShell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                int i = 0;
                while (i < AssociationTabControl.this.updateListeners.size()) {
                    AbstractTable.removeDBTableChangedListener((DBTableChangedListener)AssociationTabControl.this.updateListeners.elementAt(i));
                    ++i;
                }
            }
        });
    }

    private boolean hasLockedId(SimpleIDKey element) {
        switch (this.style) {
            case 1: {
                return Client.lockedIds.contains(new Integer(element.getId()));
            }
            case 2: 
            case 12: {
                return ClientBooking.lockedIds.contains(new Integer(element.getId()));
            }
            case 3: 
            case 7: {
                return CompanyBooking.lockedIds.contains(new Integer(element.getId()));
            }
            case 8: 
            case 9: 
            case 11: {
                return Lecturer.lockedIds.contains(new Integer(element.getId()));
            }
            case 6: {
                return SeminarType.lockedIds.contains(new Integer(element.getId()));
            }
            case 4: 
            case 5: 
            case 10: {
                return Presentation.lockedIds.contains(new Integer(element.getId()));
            }
        }
        return true;
    }

    protected void onDelete() {
        IStructuredSelection selection = (IStructuredSelection)this.mainTableViewer.getSelection();
        DistinctVector tableContent = (DistinctVector)this.mainTableViewer.getInput();
        DistinctVector<SimpleIDKey> selectedElements = new DistinctVector<SimpleIDKey>(selection.toList());
        String question = this.determineDeleteMessage(selectedElements);
        String hint = selectedElements.size() > 1 ? Messages.getString("GUIText.DeleteErrorDialogText") : Messages.getString("GUIText.DeleteErrorDialogSingularText");
        MessageDialog dlg = new MessageDialog(MainWindow.getInstance().getShell(), Messages.getString("GUIText.DeleteItemMessageDialogTitle"), null, question, 3, new String[]{Messages.getString("GUIText.DeleteItemMessageDialogYesButtonText"), Messages.getString("GUIText.DeleteItemMessageDialogNoButtonText")}, 0);
        if (dlg.open() == 0) {
            int i = 0;
            while (i < selectedElements.size()) {
                if (this.hasLockedId((SimpleIDKey)selectedElements.elementAt(i))) {
                    MessageDialog.openInformation((Shell)MainWindow.getInstance().getShell(), (String)Messages.getString("GUIText.DeleteErrorDialogTitle"), (String)hint);
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < selectedElements.size()) {
                if (tableContent.remove(selectedElements.elementAt(i))) {
                    this.idsToDelete.add((SimpleIDKey)selectedElements.elementAt(i));
                }
                ++i;
            }
            try {
                this.deleteFromDB();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (selectedElements.size() > 0) {
                this.fireItemChanged();
                this.mainTableViewer.refresh();
            }
        }
    }

    private String determineDeleteMessage(DistinctVector<SimpleIDKey> selectedElements) {
        String question = "";
        int numberOfElements = selectedElements.size();
        switch (this.style) {
            case 1: {
                question = numberOfElements > 1 ? Messages.getString("GUIText.DeleteClientItemsMessageDialogText") : Messages.getString("GUIText.DeleteClientItemMessageDialogText");
                break;
            }
            case 2: 
            case 12: {
                question = numberOfElements > 1 ? Messages.getString("GUIText.DeleteClientBookingItemsMessageDialogText") : Messages.getString("GUIText.DeleteClientBookingItemMessageDialogText");
                break;
            }
            case 3: 
            case 7: {
                question = numberOfElements > 1 ? Messages.getString("GUIText.DeleteCompanyBookingItemsMessageDialogText") : Messages.getString("GUIText.DeleteCompanyBookingItemMessageDialogText");
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                question = numberOfElements > 1 ? Messages.getString("GUIText.DeleteLecturerItemsMessageDialogText") : Messages.getString("GUIText.DeleteLecturerItemMessageDialogText");
                break;
            }
            case 6: {
                question = numberOfElements > 1 ? Messages.getString("GUIText.DeleteSeminarTypeItemsMessageDialogText") : Messages.getString("GUIText.DeleteSeminarTypeItemMessageDialogText");
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                PublicPresentation pubPres = null;
                CompanyInternalPresentation ciPres = null;
                for (SimpleIDKey item : selectedElements) {
                    Presentation selectedItem = (Presentation)item;
                    try {
                        try {
                            pubPres = PublicPresentation.getPublicPresentation(selectedItem.getId());
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    catch (NoSuchElementException e1) {
                        try {
                            try {
                                ciPres = CompanyInternalPresentation.getCompanyInternalPresentation(selectedItem.getId());
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            // empty catch block
                        }
                    }
                }
                question = pubPres != null && ciPres != null ? Messages.getString("GUIText.DeleteMixedPresentationItemsMessageDialogText") : (pubPres != null ? (numberOfElements > 1 ? Messages.getString("GUIText.DeletePublicPresentationItemsMessageDialogText") : Messages.getString("GUIText.DeletePublicPresentationItemMessageDialogText")) : (numberOfElements > 1 ? Messages.getString("GUIText.DeleteCompanyInternalPresentationItemsMessageDialogText") : Messages.getString("GUIText.DeleteCompanyInternalPresentationItemMessageDialogText")));
            }
        }
        return question;
    }

    protected void openEditItemWindow() {
        IStructuredSelection selection = (IStructuredSelection)this.mainTableViewer.getSelection();
        switch (this.style) {
            case 1: {
                new ClientWindow(MainWindow.getInstance().getShell(), (Client)selection.getFirstElement(), this);
                break;
            }
            case 2: 
            case 12: {
                new ClientBookingWindow(MainWindow.getInstance().getShell(), (ClientBooking)selection.getFirstElement(), this);
                break;
            }
            case 3: 
            case 7: {
                new CompanyBookingWindow(MainWindow.getInstance().getShell(), (CompanyBooking)selection.getFirstElement(), this);
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                new LecturerWindow(MainWindow.getInstance().getShell(), (Lecturer)selection.getFirstElement(), this);
                break;
            }
            case 6: {
                new SeminarTypeWindow(MainWindow.getInstance().getShell(), (SeminarType)selection.getFirstElement(), this);
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                Presentation selectedItem = (Presentation)selection.getFirstElement();
                PublicPresentation pubPres = null;
                CompanyInternalPresentation ciPres = null;
                try {
                    try {
                        pubPres = PublicPresentation.getPublicPresentation(selectedItem.getId());
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    if (pubPres == null) break;
                    new PublicPresentationWindow(MainWindow.getInstance().getShell(), pubPres, this);
                    break;
                }
                catch (NoSuchElementException e1) {
                    try {
                        try {
                            ciPres = CompanyInternalPresentation.getCompanyInternalPresentation(selectedItem.getId());
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        if (ciPres == null) break;
                        new CompanyInternalPresentationWindow(MainWindow.getInstance().getShell(), ciPres, this);
                        break;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected void openNewItemWindow() {
        block0 : switch (this.style) {
            case 1: {
                new ClientWindow(MainWindow.getInstance().getShell(), null, this);
                break;
            }
            case 2: 
            case 12: {
                new ClientBookingWindow(MainWindow.getInstance().getShell(), null, this);
                break;
            }
            case 3: 
            case 7: {
                new CompanyBookingWindow(MainWindow.getInstance().getShell(), null, this);
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                new LecturerWindow(MainWindow.getInstance().getShell(), null, this);
                break;
            }
            case 6: {
                new SeminarTypeWindow(MainWindow.getInstance().getShell(), null, this);
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                MessageDialog dlg = new MessageDialog(MainWindow.getInstance().getShell(), Messages.getString("GUIText.ChoosePresentationTypeDialogWindowTitle"), null, Messages.getString("GUIText.ChoosePresentationTypeDialogQuestionText"), 3, new String[]{Messages.getString("GUIText.ChoosePresentationTypeDialogButtonPublicText"), Messages.getString("GUIText.ChoosePresentationTypeDialogButtonCompanyInternalText"), Messages.getString("GUIText.ChoosePresentationTypeDialogButtonAbortText")}, 0);
                switch (dlg.open()) {
                    case 0: {
                        new PublicPresentationWindow(MainWindow.getInstance().getShell(), null, this);
                        break block0;
                    }
                    case 1: {
                        new CompanyInternalPresentationWindow(MainWindow.getInstance().getShell(), null, this);
                    }
                }
            }
        }
    }

    protected void openListWindow() {
        switch (this.style) {
            case 1: {
                new ClientListWindow(this);
                break;
            }
            case 2: 
            case 12: {
                new ClientBookingListWindow(this);
                break;
            }
            case 3: 
            case 7: {
                new CompanyBookingListWindow(this);
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                new LecturerListWindow(this);
                break;
            }
            case 6: {
                new SeminarTypeListWindow(this);
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                new PresentationListWindow(this);
            }
        }
    }

    protected void onDisconnect() {
        DistinctVector input = (DistinctVector)this.mainTableViewer.getInput();
        Object[] selectedItems = ((IStructuredSelection)this.mainTableViewer.getSelection()).toArray();
        int i = 0;
        while (i < selectedItems.length) {
            input.remove(selectedItems[i]);
            ++i;
        }
        if (selectedItems.length > 0) {
            this.fireItemChanged();
            this.mainTableViewer.refresh();
        }
    }

    private void configureClassSpecificViewerParts() {
        switch (this.style) {
            case 1: {
                this.mainTableViewer.setLabelProvider((IBaseLabelProvider)new ClientTableProvider());
                this.columns = Client.getColumns();
                break;
            }
            case 2: 
            case 12: {
                this.mainTableViewer.setLabelProvider((IBaseLabelProvider)new ClientBookingTableProvider());
                this.columns = ClientBooking.getColumns();
                break;
            }
            case 3: 
            case 7: {
                this.mainTableViewer.setLabelProvider((IBaseLabelProvider)new CompanyBookingTableProvider());
                this.columns = CompanyBooking.getColumns();
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                this.mainTableViewer.setLabelProvider((IBaseLabelProvider)new LecturerTableProvider());
                this.columns = Lecturer.getColumns();
                break;
            }
            case 6: {
                this.mainTableViewer.setLabelProvider((IBaseLabelProvider)new SeminarTypeTableProvider());
                this.columns = SeminarType.getColumns();
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                this.mainTableViewer.setLabelProvider((IBaseLabelProvider)new PresentationTableProvider());
                this.columns = Presentation.getColumns();
            }
        }
    }

    public void setInput(int referencedFK) throws SQLException {
        this.referencedFK = referencedFK;
        this.idsToDelete.clear();
        if (referencedFK == 0) {
            this.mainTableViewer.setInput(new DistinctVector());
        } else {
            try {
                switch (this.style) {
                    case 1: {
                        this.mainTableViewer.setInput(Client.getEmployees(referencedFK));
                        break;
                    }
                    case 2: {
                        this.mainTableViewer.setInput(ClientBooking.getBookingsOfClient(referencedFK));
                        break;
                    }
                    case 12: {
                        this.mainTableViewer.setInput(ClientBooking.getBookingsForPresentation(referencedFK));
                        break;
                    }
                    case 3: {
                        this.mainTableViewer.setInput(CompanyBooking.getBookingsOfCompany(referencedFK));
                        break;
                    }
                    case 7: {
                        this.mainTableViewer.setInput(CompanyBooking.getBookingsForPresentation(referencedFK));
                        break;
                    }
                    case 4: {
                        this.mainTableViewer.setInput(Presentation.getPresSupervisedBy(referencedFK));
                        break;
                    }
                    case 5: {
                        this.mainTableViewer.setInput(Presentation.getPresInstructedBy(referencedFK));
                        break;
                    }
                    case 10: {
                        this.mainTableViewer.setInput(Presentation.getPresForSemType(referencedFK));
                        break;
                    }
                    case 6: {
                        this.mainTableViewer.setInput(SeminarType.getSemTypeConductedBy(referencedFK));
                        break;
                    }
                    case 8: {
                        this.mainTableViewer.setInput(Lecturer.getLectInstructing(referencedFK));
                        break;
                    }
                    case 9: {
                        this.mainTableViewer.setInput(Lecturer.getLectSupervising(referencedFK));
                        break;
                    }
                    case 11: {
                        this.mainTableViewer.setInput(Lecturer.getLectConducting(referencedFK));
                    }
                }
            }
            catch (SQLException e) {
                this.mainTableViewer.setInput(null);
                throw e;
            }
            if (this.mainTableViewer.getInput() == null) {
                this.previouslySelectedIds.clear();
            } else {
                DistinctVector input = (DistinctVector)this.mainTableViewer.getInput();
                this.previouslySelectedIds = (DistinctVector)input.clone();
            }
        }
        this.setEnabled(true);
    }

    public DistinctVector<SimpleIDKey> getObjects() {
        return (DistinctVector)this.mainTableViewer.getInput();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.chooseItem.setEnabled(enabled);
        this.disconnectItem.setEnabled(!this.mainTableViewer.getSelection().isEmpty() && enabled);
        this.editItem.setEnabled(!this.mainTableViewer.getSelection().isEmpty() && enabled);
        this.deleteItem.setEnabled(!this.mainTableViewer.getSelection().isEmpty() && enabled);
    }

    public void addSelectedIds(SimpleIDKey[] selectedElements, boolean checkAlreadyAssigned) {
        int i;
        DistinctVector input = (DistinctVector)this.mainTableViewer.getInput();
        boolean alreadyAssigned = false;
        if (this.style == 10) {
            i = 0;
            while (i < selectedElements.length) {
                if (input.contains(selectedElements[i])) {
                    alreadyAssigned = true;
                }
                if (checkAlreadyAssigned) {
                    input.add(selectedElements[i]);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < selectedElements.length) {
                if (input.contains(selectedElements[i])) {
                    alreadyAssigned = true;
                }
                input.add(selectedElements[i]);
                ++i;
            }
        }
        if (selectedElements.length > 0) {
            this.fireItemChanged();
            this.mainTableViewer.refresh();
            try {
                this.connectInDB();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (checkAlreadyAssigned && alreadyAssigned) {
            MessageDialog.openInformation((Shell)MainWindow.getInstance().getShell(), (String)Messages.getString("GUIText.AlreadyAssignedDialogWindowTitle"), (String)Messages.getString("GUIText.AlreadyAssignedDialogHintText"));
        }
    }

    public void commitIntoDB(int generatedId) throws SQLException {
        this.referencedFK = generatedId;
        this.deleteFromDB();
        this.idsToDelete.clear();
        this.disconnectInDB();
        this.connectInDB();
    }

    private void disconnectInDB() throws SQLException {
        try {
            Iterator it = this.previouslySelectedIds.iterator();
            DistinctVector input = (DistinctVector)this.mainTableViewer.getInput();
            switch (this.style) {
                case 1: {
                    while (it.hasNext()) {
                        Client employee = (Client)it.next();
                        if (input.contains(employee)) continue;
                        employee.setEmployerId(0);
                        employee.updateDB();
                    }
                    break;
                }
                case 2: 
                case 12: {
                    DistinctVector<ClientBooking> clientBookings = new DistinctVector<ClientBooking>();
                    while (it.hasNext()) {
                        ClientBooking booking = (ClientBooking)it.next();
                        if (input.contains(booking)) continue;
                        clientBookings.add(booking);
                    }
                    ClientBooking.removeFromDB(clientBookings);
                    break;
                }
                case 3: 
                case 7: {
                    DistinctVector<CompanyBooking> companyBookings = new DistinctVector<CompanyBooking>();
                    while (it.hasNext()) {
                        CompanyBooking booking = (CompanyBooking)it.next();
                        if (input.contains(booking)) continue;
                        companyBookings.add(booking);
                    }
                    CompanyBooking.removeFromDB(companyBookings);
                    break;
                }
                case 4: {
                    while (it.hasNext()) {
                        Presentation presentation = (Presentation)it.next();
                        if (input.contains(presentation)) continue;
                        Supervisor supervisor = new Supervisor(this.referencedFK, presentation.getId(), new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()));
                        supervisor.deleteFromDB();
                    }
                    break;
                }
                case 5: {
                    while (it.hasNext()) {
                        Presentation presentation = (Presentation)it.next();
                        if (input.contains(presentation)) continue;
                        Instructor instructor = new Instructor(this.referencedFK, presentation.getId(), new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()));
                        instructor.deleteFromDB();
                    }
                    break;
                }
                case 10: {
                    DistinctVector<Presentation> presentations = new DistinctVector<Presentation>();
                    while (it.hasNext()) {
                        Presentation presentation = (Presentation)it.next();
                        if (input.contains(presentation)) continue;
                        presentations.add(presentation);
                    }
                    Presentation.removeFromDB(presentations);
                    break;
                }
                case 6: {
                    while (it.hasNext()) {
                        SeminarType semType = (SeminarType)it.next();
                        if (input.contains(semType)) continue;
                        Conduct conduct = new Conduct(this.referencedFK, semType.getId(), new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()));
                        conduct.deleteFromDB();
                    }
                    break;
                }
                case 8: {
                    while (it.hasNext()) {
                        Lecturer lecturer = (Lecturer)it.next();
                        if (input.contains(lecturer)) continue;
                        Instructor instructor = new Instructor(lecturer.getId(), this.referencedFK, new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()));
                        instructor.deleteFromDB();
                    }
                    break;
                }
                case 9: {
                    while (it.hasNext()) {
                        Lecturer lecturer = (Lecturer)it.next();
                        if (input.contains(lecturer)) continue;
                        Supervisor supervisor = new Supervisor(lecturer.getId(), this.referencedFK, new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()));
                        supervisor.deleteFromDB();
                    }
                    break;
                }
                case 11: {
                    while (it.hasNext()) {
                        Lecturer lecturer = (Lecturer)it.next();
                        if (input.contains(lecturer)) continue;
                        Conduct conduct = new Conduct(lecturer.getId(), this.referencedFK, new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()));
                        conduct.deleteFromDB();
                    }
                    break block1;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void connectInDB() throws SQLException {
        block26: for (SimpleIDKey element : (DistinctVector)this.mainTableViewer.getInput()) {
            if (this.previouslySelectedIds.contains(element)) continue;
            switch (this.style) {
                case 1: {
                    Client employee = (Client)element;
                    employee.setEmployerId(this.referencedFK);
                    employee.updateDB();
                    break;
                }
                case 2: {
                    ClientBooking booking = (ClientBooking)element;
                    booking.setClientId(this.referencedFK);
                    booking.updateDB();
                    break;
                }
                case 12: {
                    ClientBooking booking2 = (ClientBooking)element;
                    booking2.setPresentationId(this.referencedFK);
                    booking2.updateDB();
                    break;
                }
                case 3: {
                    CompanyBooking booking3 = (CompanyBooking)element;
                    booking3.setCompanyId(this.referencedFK);
                    booking3.updateDB();
                    break;
                }
                case 7: {
                    CompanyBooking booking4 = (CompanyBooking)element;
                    booking4.setPresentationId(this.referencedFK);
                    booking4.updateDB();
                    break;
                }
                case 4: {
                    Supervisor supervisor = new Supervisor(this.referencedFK, element.getId(), new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()));
                    try {
                        supervisor.insertIntoDB();
                    }
                    catch (SQLException sQLException) {}
                    continue block26;
                }
                case 5: {
                    Instructor instructor = new Instructor(this.referencedFK, element.getId(), new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()));
                    try {
                        instructor.insertIntoDB();
                    }
                    catch (SQLException sQLException) {}
                    continue block26;
                }
                case 10: {
                    Presentation presentation = (Presentation)element;
                    presentation.setSeminarTypeId(this.referencedFK);
                    presentation.updateDB();
                    break;
                }
                case 6: {
                    Conduct conduct = new Conduct(this.referencedFK, element.getId(), new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()));
                    try {
                        conduct.insertIntoDB();
                    }
                    catch (SQLException sQLException) {}
                    continue block26;
                }
                case 8: {
                    Instructor instructor2 = new Instructor(element.getId(), this.referencedFK, new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()));
                    try {
                        instructor2.insertIntoDB();
                    }
                    catch (SQLException sQLException) {}
                    continue block26;
                }
                case 9: {
                    Supervisor supervisor2 = new Supervisor(element.getId(), this.referencedFK, new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()));
                    try {
                        supervisor2.insertIntoDB();
                    }
                    catch (SQLException sQLException) {}
                    continue block26;
                }
                case 11: {
                    Conduct conduct2 = new Conduct(element.getId(), this.referencedFK, new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()));
                    try {
                        conduct2.insertIntoDB();
                        break;
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void deleteFromDB() throws SQLException {
        if (!this.idsToDelete.isEmpty()) {
            switch (this.style) {
                case 1: {
                    Client.removeFromDB(this.idsToDelete);
                    break;
                }
                case 2: 
                case 12: {
                    ClientBooking.removeFromDB(this.idsToDelete);
                    break;
                }
                case 3: 
                case 7: {
                    CompanyBooking.removeFromDB(this.idsToDelete);
                    break;
                }
                case 8: 
                case 9: 
                case 11: {
                    Lecturer.removeFromDB(this.idsToDelete);
                    break;
                }
                case 6: {
                    SeminarType.removeFromDB(this.idsToDelete);
                    break;
                }
                case 4: 
                case 5: 
                case 10: {
                    Presentation.removeFromDB(this.idsToDelete);
                }
            }
        }
    }

    public void setData(String key, String value) {
        super.setData(key, (Object)value);
        if (key.equals("ATOSJ_COMPONENT_NAME_KEY")) {
            this.mainTableViewer.getTable().setData(key, (Object)(String.valueOf(value) + "_Table"));
            this.disconnectItem.setData(key, (Object)(String.valueOf(value) + "_DisconnectItem"));
            this.deleteItem.setData(key, (Object)(String.valueOf(value) + "_DeleteItem"));
            this.configureItem.setData(key, (Object)(String.valueOf(value) + "_ConfigureItem"));
            this.chooseItem.setData(key, (Object)(String.valueOf(value) + "_ChooseItem"));
            this.editItem.setData(key, (Object)(String.valueOf(value) + "_EditItem"));
            this.newItem.setData(key, (Object)(String.valueOf(value) + "_NewItem"));
        }
    }

    public void addItemListener(ItemListener listener) {
        this.itemListeners.add(listener);
    }

    public void removeItemListener(ItemListener listener) {
        this.itemListeners.remove(listener);
    }

    private void fireItemChanged() {
        for (ItemListener listener : this.itemListeners) {
            listener.itemChanged();
        }
    }

    private void addUpdateListener() {
        switch (this.style) {
            case 1: {
                this.updateListeners.add(new DBTableChangedListener(3){

                    public void dBTableChanged() {
                        AssociationTabControl.this.update();
                    }
                });
                break;
            }
            case 2: 
            case 12: {
                this.updateListeners.add(new DBTableChangedListener(4){

                    public void dBTableChanged() {
                        AssociationTabControl.this.update();
                    }
                });
                break;
            }
            case 3: 
            case 7: {
                this.updateListeners.add(new DBTableChangedListener(6){

                    public void dBTableChanged() {
                        AssociationTabControl.this.update();
                    }
                });
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                this.updateListeners.add(new DBTableChangedListener(11){

                    public void dBTableChanged() {
                        AssociationTabControl.this.update();
                    }
                });
                break;
            }
            case 6: {
                this.updateListeners.add(new DBTableChangedListener(15){

                    public void dBTableChanged() {
                        AssociationTabControl.this.update();
                    }
                });
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                this.updateListeners.add(new DBTableChangedListener(13){

                    public void dBTableChanged() {
                        AssociationTabControl.this.update();
                    }
                });
            }
        }
        AbstractTable.addDBTableChangedListener((DBTableChangedListener)this.updateListeners.lastElement());
    }

    public void update() {
        try {
            this.setInput(this.referencedFK);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

