/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui.provider;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import semorg.sql.tables.SeminarType;
import semorg.sql.util.Utility;

public class SeminarTypeTableProvider
implements ITableLabelProvider {
    public void dispose() {
    }

    public Image getColumnImage(Object arg0, int arg1) {
        return null;
    }

    public String getColumnText(Object input, int column) {
        SeminarType seminarType = (SeminarType)input;
        switch (column) {
            case 0: {
                return "" + seminarType.getId();
            }
            case 1: {
                return seminarType.getShortTitle();
            }
            case 2: {
                return seminarType.getTitle();
            }
            case 3: {
                return seminarType.getObjective();
            }
            case 4: {
                return seminarType.getMethodology();
            }
            case 5: {
                return seminarType.getTopic();
            }
            case 6: {
                return seminarType.getRoutine();
            }
            case 7: {
                if (seminarType.getDuration() != null) {
                    return seminarType.getDuration().toString();
                }
                return null;
            }
            case 8: {
                return seminarType.getDocuments();
            }
            case 9: {
                return seminarType.getAudience();
            }
            case 10: {
                return seminarType.getRequirements();
            }
            case 11: {
                if (seminarType.getCharge() != null) {
                    return Utility.createFloatText(seminarType.getCharge());
                }
                return null;
            }
            case 12: {
                if (seminarType.getMaxEntrants() != null) {
                    return seminarType.getMaxEntrants().toString();
                }
                return null;
            }
            case 13: {
                if (seminarType.getMinEntrants() != null) {
                    return seminarType.getMinEntrants().toString();
                }
                return null;
            }
            case 14: {
                if (seminarType.getCreationDate() != null) {
                    return Utility.dateAndTimeFormatter.format(seminarType.getCreationDate());
                }
                return null;
            }
            case 15: {
                if (seminarType.getModificationDate() != null) {
                    return Utility.dateAndTimeFormatter.format(seminarType.getModificationDate());
                }
                return null;
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener arg0) {
    }

    public boolean isLabelProperty(Object arg0, String arg1) {
        return false;
    }

    public void removeListener(ILabelProviderListener arg0) {
    }
}

