/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui.provider;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import semorg.gui.util.Messages;
import semorg.sql.tables.Presentation;
import semorg.sql.util.Utility;

public class PresentationTableProvider
implements ITableLabelProvider {
    public void dispose() {
    }

    public Image getColumnImage(Object arg0, int arg1) {
        return null;
    }

    public String getColumnText(Object input, int column) {
        Presentation presentation = (Presentation)input;
        switch (column) {
            case 0: {
                return new Integer(presentation.getId()).toString();
            }
            case 1: {
                return presentation.getSeminarTypeDescription();
            }
            case 2: {
                if (presentation.getDuration() != null) {
                    return presentation.getDuration().toString();
                }
                return null;
            }
            case 3: {
                if (presentation.getBeginningDay() != null) {
                    return Utility.dateOnlyFormatter.format(presentation.getBeginningDay());
                }
                return null;
            }
            case 4: {
                if (presentation.getEndingDay() != null) {
                    return Utility.dateOnlyFormatter.format(presentation.getEndingDay());
                }
                return null;
            }
            case 5: {
                if (presentation.getStartingTime() != null) {
                    return Utility.timeOnlyFormatter.format(presentation.getStartingTime());
                }
                return null;
            }
            case 6: {
                if (presentation.getEndingTime() != null) {
                    return Utility.timeOnlyFormatter.format(presentation.getEndingTime());
                }
                return null;
            }
            case 7: {
                if (presentation.getFirstStartingTime() != null) {
                    return Utility.timeOnlyFormatter.format(presentation.getFirstStartingTime());
                }
                return null;
            }
            case 8: {
                if (presentation.getLastEndingTime() != null) {
                    return Utility.timeOnlyFormatter.format(presentation.getLastEndingTime());
                }
                return null;
            }
            case 9: {
                return presentation.getLocation();
            }
            case 10: {
                return presentation.getStreet();
            }
            case 11: {
                return presentation.getZipCode();
            }
            case 12: {
                return presentation.getCity();
            }
            case 13: {
                return presentation.getCountry();
            }
            case 14: {
                return presentation.getAnnex();
            }
            case 15: {
                return presentation.isCancelled() ? Messages.getString("ProviderText.PresentationTableProviderIsCanceledText") : Messages.getString("ProviderText.PresentationTableProviderIsNotCanceledText");
            }
            case 16: {
                if (presentation.getCreationDate() != null) {
                    return Utility.dateAndTimeFormatter.format(presentation.getCreationDate());
                }
                return null;
            }
            case 17: {
                if (presentation.getModificationDate() == null) break;
                return Utility.dateAndTimeFormatter.format(presentation.getModificationDate());
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener arg0) {
    }

    public boolean isLabelProperty(Object arg0, String arg1) {
        return false;
    }

    public void removeListener(ILabelProviderListener arg0) {
    }
}

