/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui.provider;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import semorg.sql.tables.Lecturer;
import semorg.sql.util.Utility;

public class LecturerTableProvider
implements ITableLabelProvider {
    public void dispose() {
    }

    public Image getColumnImage(Object arg0, int arg1) {
        return null;
    }

    public String getColumnText(Object input, int column) {
        Lecturer lecturer = (Lecturer)input;
        switch (column) {
            case 0: {
                return "" + lecturer.getId();
            }
            case 1: {
                return lecturer.getSalutation();
            }
            case 2: {
                return lecturer.getTitle();
            }
            case 3: {
                return lecturer.getFirstname();
            }
            case 4: {
                return lecturer.getName();
            }
            case 5: {
                return lecturer.getStreet();
            }
            case 6: {
                return lecturer.getZipCode();
            }
            case 7: {
                return lecturer.getCity();
            }
            case 8: {
                return lecturer.getCountry();
            }
            case 9: {
                return lecturer.getAnnex();
            }
            case 10: {
                return lecturer.getPhone();
            }
            case 11: {
                return lecturer.getMobile();
            }
            case 12: {
                return lecturer.getFax();
            }
            case 13: {
                return lecturer.getEmail();
            }
            case 14: {
                if (lecturer.getBirthday() != null) {
                    return Utility.dateOnlyFormatter.format(lecturer.getBirthday());
                }
                return null;
            }
            case 15: {
                if (lecturer.getFirstContact() != null) {
                    return Utility.dateOnlyFormatter.format(lecturer.getFirstContact());
                }
                return null;
            }
            case 16: {
                return lecturer.getShortinfo();
            }
            case 17: {
                return lecturer.getNotices();
            }
            case 18: {
                return lecturer.getBio();
            }
            case 19: {
                if (lecturer.getDailyFee() != null) {
                    return Utility.createFloatText(lecturer.getDailyFee());
                }
                return null;
            }
            case 20: {
                if (lecturer.getHourlyFee() != null) {
                    return Utility.createFloatText(lecturer.getHourlyFee());
                }
                return null;
            }
            case 21: {
                if (lecturer.getCreationDate() != null) {
                    return Utility.dateAndTimeFormatter.format(lecturer.getCreationDate());
                }
                return null;
            }
            case 22: {
                if (lecturer.getModificationDate() != null) {
                    return Utility.dateAndTimeFormatter.format(lecturer.getModificationDate());
                }
                return null;
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener arg0) {
    }

    public boolean isLabelProperty(Object arg0, String arg1) {
        return false;
    }

    public void removeListener(ILabelProviderListener arg0) {
    }
}

