/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui.provider;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import semorg.gui.util.Messages;
import semorg.sql.tables.Associate;
import semorg.sql.util.Utility;

public class AssociateTableProvider
implements ITableLabelProvider {
    public void dispose() {
    }

    public Image getColumnImage(Object arg0, int arg1) {
        return null;
    }

    public String getColumnText(Object input, int column) {
        Associate associate = (Associate)input;
        switch (column) {
            case 0: {
                return "" + associate.getId();
            }
            case 1: {
                return associate.getSalutation();
            }
            case 2: {
                return associate.getTitle();
            }
            case 3: {
                return associate.getFirstname();
            }
            case 4: {
                return associate.getName();
            }
            case 5: {
                return associate.getStreet();
            }
            case 6: {
                return associate.getZipCode();
            }
            case 7: {
                return associate.getCity();
            }
            case 8: {
                return associate.getCountry();
            }
            case 9: {
                return associate.getAnnex();
            }
            case 10: {
                return associate.getPhone();
            }
            case 11: {
                return associate.getMobile();
            }
            case 12: {
                return associate.getFax();
            }
            case 13: {
                return associate.getEmail();
            }
            case 14: {
                if (associate.getBirthday() != null) {
                    return Utility.dateOnlyFormatter.format(associate.getBirthday());
                }
                return null;
            }
            case 15: {
                if (associate.getFirstContact() != null) {
                    return Utility.dateOnlyFormatter.format(associate.getFirstContact());
                }
                return null;
            }
            case 16: {
                return associate.getShortinfo();
            }
            case 17: {
                return associate.getNotices();
            }
            case 18: {
                switch (associate.getEntitlement()) {
                    case 1: {
                        return Messages.getString("ProviderText.AssociateEntitlementSeminarAdministratorText");
                    }
                    case 2: {
                        return Messages.getString("ProviderText.AssociateEntitlementCustomerAdministratorText");
                    }
                    case 3: {
                        return Messages.getString("ProviderText.AssociateEntitlementPresentatioOrganizerText");
                    }
                    case 4: {
                        return Messages.getString("ProviderText.AssociateEntitlementAdministratorText");
                    }
                }
                return null;
            }
            case 19: {
                return associate.getPassword();
            }
            case 20: {
                return associate.getOccupation();
            }
            case 21: {
                if (associate.getCreationDate() != null) {
                    return Utility.dateAndTimeFormatter.format(associate.getCreationDate());
                }
                return null;
            }
            case 22: {
                if (associate.getModificationDate() != null) {
                    return Utility.dateAndTimeFormatter.format(associate.getModificationDate());
                }
                return null;
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener arg0) {
    }

    public boolean isLabelProperty(Object arg0, String arg1) {
        return false;
    }

    public void removeListener(ILabelProviderListener arg0) {
    }
}

