/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui.list;

import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;
import semorg.gui.MainWindow;
import semorg.gui.list.ListWindow;
import semorg.gui.provider.PresentationTableProvider;
import semorg.gui.util.AssociationTabControl;
import semorg.gui.util.ForeignKeyConstraintSelector;
import semorg.gui.util.Messages;
import semorg.sql.tables.Presentation;
import semorg.sql.tables.SimpleIDKey;
import semorg.sql.util.DBConstraint;
import semorg.sql.util.DistinctVector;
import semorg.sql.util.Utility;

public class PresentationListWindow
extends ListWindow {
    public static ListWindow instance;

    private PresentationListWindow() {
        super(MainWindow.getInstance().getShell(), Presentation.getColumnsWithSemtype());
        this.mainTableViewer.setLabelProvider((IBaseLabelProvider)new PresentationTableProvider());
        this.shell.setText(Messages.getString("GUIText.PresentationListWindowTitleText"));
        this.update();
    }

    public PresentationListWindow(AssociationTabControl caller) {
        super(caller.getShell(), Presentation.getColumnsWithSemtype(), caller);
        this.mainTableViewer.setLabelProvider((IBaseLabelProvider)new PresentationTableProvider());
        this.shell.setText(Messages.getString("GUIText.PopUpPresentationListWindowTitleText"));
        this.update();
        this.shell.open();
    }

    public PresentationListWindow(ForeignKeyConstraintSelector caller) {
        super(caller.getShell(), Presentation.getColumnsWithSemtype(), caller);
        this.mainTableViewer.setLabelProvider((IBaseLabelProvider)new PresentationTableProvider());
        this.shell.setText(Messages.getString("GUIText.PopUpPresentationListWindowTitleText"));
        this.update();
        this.shell.open();
    }

    protected void createSpecializedMainTableListener() {
        this.addUpdateListener(13);
    }

    protected void createSpecializedMainTableListener(final AssociationTabControl caller) {
        this.addUpdateListener(13);
        this.mainTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                Presentation selectedItem = (Presentation)selection.getFirstElement();
                caller.addSelectedIds(new SimpleIDKey[]{selectedItem}, true);
                PresentationListWindow.this.shell.close();
            }
        });
    }

    protected void createSpecializedMainTableListener(final ForeignKeyConstraintSelector caller) {
        this.addUpdateListener(13);
        this.mainTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                Presentation selectedItem = (Presentation)selection.getFirstElement();
                caller.setSelectedId(selectedItem.getId());
                PresentationListWindow.this.shell.close();
            }
        });
    }

    protected void createSpecializedToolBarListeners() {
    }

    protected void createChooseButtonListener(final AssociationTabControl caller) {
        this.chooseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)PresentationListWindow.this.mainTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    Object[] selectedItems = selection.toArray();
                    SimpleIDKey[] selectedElements = (SimpleIDKey[])Utility.castArray(selectedItems, SimpleIDKey.class);
                    caller.addSelectedIds(selectedElements, true);
                    PresentationListWindow.this.shell.close();
                }
            }
        });
    }

    protected void createChooseButtonListener(final ForeignKeyConstraintSelector caller) {
        this.chooseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)PresentationListWindow.this.mainTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    Presentation selectedItem = (Presentation)selection.getFirstElement();
                    caller.setSelectedId(selectedItem.getId());
                    PresentationListWindow.this.shell.close();
                }
            }
        });
    }

    public static void openList() {
        PresentationListWindow.instance.shell.open();
    }

    protected Object getTableInputFromDB() {
        Vector<DBConstraint> constraints = null;
        if (this.filterItem.getSelection()) {
            try {
                constraints = this.filter.getConstraints();
            }
            catch (Exception e) {
                this.filterItem.setSelection(false);
            }
        }
        try {
            return Presentation.getPresentationVectorFromDB(constraints, this.sortString);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return new DistinctVector();
        }
    }

    public static void createWindow(Shell parent) {
        instance = new PresentationListWindow();
    }
}

