/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui.list;

import java.util.Vector;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import semorg.gui.util.AssociationTabControl;
import semorg.gui.util.ConfigureListDlg;
import semorg.gui.util.DBTableChangedListener;
import semorg.gui.util.ExtensibleSearchControl;
import semorg.gui.util.ForeignKeyConstraintSelector;
import semorg.gui.util.Messages;
import semorg.gui.util.TableColumnProperty;
import semorg.sql.tables.AbstractTable;
import semorg.sql.util.DBColumn;
import semorg.sql.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListWindow {
    protected Shell shell;
    protected Composite toolBar;
    protected ToolItem filterItem;
    protected TableViewer mainTableViewer;
    protected Table mainTable;
    protected final Vector<DBColumn> columns;
    ExtensibleSearchControl filter;
    protected String sortString = null;
    protected ToolItem newItem;
    protected ToolItem editItem;
    protected ToolItem deleteItem;
    protected Button chooseButton;
    private ToolItem configureItem;
    private DBTableChangedListener updateListener;

    public ListWindow(Shell parent, Vector<DBColumn> columns) {
        this.columns = columns;
        this.shell = new Shell(parent, 1264);
        FormLayout mainLayout = new FormLayout();
        this.shell.setLayout((Layout)mainLayout);
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
                ListWindow.this.setVisible(false);
            }
        });
        this.mainTableViewer = new TableViewer((Composite)this.shell, 67588);
        this.mainTable = this.mainTableViewer.getTable();
        this.mainTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                ListWindow.this.editItem.setEnabled(selection.size() > 0);
                ListWindow.this.deleteItem.setEnabled(selection.size() > 0);
            }
        });
        this.mainTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.createTableBasics();
        this.createSpecializedMainTableListener();
        this.createListToolbarBasics(false);
        this.createSpecializedToolBarListeners();
        this.mainTable.setLayoutData((Object)Utility.getFormData(this.toolBar, 5, 100, -1, 0, 1, 100, -1));
    }

    public ListWindow(Shell parent, Vector<DBColumn> columns, AssociationTabControl caller) {
        this.columns = columns;
        this.shell = new Shell(parent, 66800);
        FormLayout mainLayout = new FormLayout();
        this.shell.setLayout((Layout)mainLayout);
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                AbstractTable.removeDBTableChangedListener(ListWindow.this.updateListener);
            }
        });
        this.shell.setSize(600, 180);
        this.mainTableViewer = new TableViewer((Composite)this.shell, 67586);
        this.mainTable = this.mainTableViewer.getTable();
        this.mainTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.createTableBasics();
        this.createSpecializedMainTableListener(caller);
        Composite buttonArea = this.createButtonArea();
        this.createChooseButtonListener(caller);
        this.createListToolbarBasics(true);
        this.mainTable.setLayoutData((Object)Utility.getFormData(this.toolBar, 5, buttonArea, -1, 0, 1, 100, -1));
        buttonArea.setLayoutData((Object)Utility.getFormData(null, 0, 100, 0, 0, 1, 100, -1));
    }

    public ListWindow(Shell parent, Vector<DBColumn> columns, ForeignKeyConstraintSelector caller) {
        this.columns = columns;
        this.shell = new Shell(parent, 66800);
        FormLayout mainLayout = new FormLayout();
        this.shell.setLayout((Layout)mainLayout);
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                AbstractTable.removeDBTableChangedListener(ListWindow.this.updateListener);
            }
        });
        this.shell.setSize(600, 180);
        this.mainTableViewer = new TableViewer((Composite)this.shell, 67586);
        this.mainTable = this.mainTableViewer.getTable();
        this.mainTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.createTableBasics();
        this.createSpecializedMainTableListener(caller);
        Composite buttonArea = this.createButtonArea();
        this.createChooseButtonListener(caller);
        this.createListToolbarBasics(true);
        this.mainTable.setLayoutData((Object)Utility.getFormData(this.toolBar, 5, buttonArea, -1, 0, 1, 100, -1));
        buttonArea.setLayoutData((Object)Utility.getFormData(null, 0, 100, 0, 0, 1, 100, -1));
    }

    private Composite createButtonArea() {
        Composite buttonArea = new Composite((Composite)this.shell, 0);
        buttonArea.setLayout((Layout)new RowLayout());
        this.chooseButton = new Button(buttonArea, 8);
        this.chooseButton.setText(Messages.getString("GUIText.ChooseButtonText"));
        Button abortButton = new Button(buttonArea, 8);
        abortButton.setText(Messages.getString("GUIText.AbortButtonText"));
        abortButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListWindow.this.shell.close();
            }
        });
        return buttonArea;
    }

    protected void setActive() {
        this.shell.setActive();
    }

    public void setVisible(boolean vis) {
        this.shell.setVisible(vis);
    }

    public void update() {
        this.mainTableViewer.setInput(this.getTableInputFromDB());
    }

    protected void createListToolbarBasics(boolean isPopup) {
        this.toolBar = new Composite((Composite)this.shell, 0);
        this.filter = new ExtensibleSearchControl(this.toolBar, 8);
        this.toolBar.setLayout((Layout)new RowLayout());
        this.filter.setColumns(this.columns);
        this.filter.setData("ATOSJ_COMPONENT_NAME_KEY", "ListFilter");
        this.filter.addExtensionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ListWindow.this.shell.layout();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        ToolBar viewToolBar = new ToolBar(this.toolBar, 0x800000);
        this.filterItem = new ToolItem(viewToolBar, 32);
        this.filterItem.setImage(Utility.getImage("filter.png"));
        this.filterItem.setToolTipText(Messages.getString("GUIText.FilterItemButtonToolTip"));
        this.filterItem.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"FilterItem");
        this.filterItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ListWindow.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        ToolItem updateItem = new ToolItem(viewToolBar, 8);
        updateItem.setImage(Utility.getImage("update.png"));
        updateItem.setToolTipText(Messages.getString("GUIText.UpdateItemButtonToolTip"));
        updateItem.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"UpdateItem");
        updateItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ListWindow.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        viewToolBar.pack();
        if (!isPopup) {
            ToolBar dataToolBar = new ToolBar(this.toolBar, 0x800000);
            this.newItem = new ToolItem(dataToolBar, 8);
            this.newItem.setImage(Utility.getImage("new.png"));
            this.newItem.setToolTipText(Messages.getString("GUIText.AddNewItemButtonToolTip"));
            this.newItem.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"Neu");
            this.editItem = new ToolItem(dataToolBar, 8);
            this.editItem.setImage(Utility.getImage("edit.png"));
            this.editItem.setEnabled(false);
            this.editItem.setToolTipText(Messages.getString("GUIText.EditItemButtonToolTip"));
            this.editItem.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"EditItem");
            this.deleteItem = new ToolItem(dataToolBar, 8);
            this.deleteItem.setImage(Utility.getImage("delete.png"));
            this.deleteItem.setToolTipText(Messages.getString("GUIText.DeleteItemButtonToolTip"));
            this.deleteItem.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"DeleteItem");
            this.deleteItem.setEnabled(false);
            dataToolBar.pack();
        }
        ToolBar adminToolBar = new ToolBar(this.toolBar, 0x800000);
        this.configureItem = new ToolItem(adminToolBar, 8);
        this.configureItem.setImage(Utility.getImage("configure.png"));
        this.configureItem.setToolTipText(Messages.getString("GUIText.ConfigureListItemButtonToolTip"));
        this.configureItem.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"ConfigureItem");
        this.configureItem.setEnabled(true);
        this.configureItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ConfigureListDlg dlg = new ConfigureListDlg(Display.getCurrent().getActiveShell(), ListWindow.this.mainTable.getColumns(), ListWindow.this.mainTable.getColumnOrder());
                if (dlg.open() == 0) {
                    this.copyColumnProperties(dlg.getColumnProperties());
                }
            }

            private void copyColumnProperties(TableColumnProperty[] dlgColumnProperties) {
                TableColumn[] tableColumns = ListWindow.this.mainTable.getColumns();
                int[] columnOrder = new int[tableColumns.length];
                int i = 0;
                while (i < tableColumns.length) {
                    tableColumns[i].setWidth(dlgColumnProperties[i].getWidth());
                    tableColumns[i].setResizable(dlgColumnProperties[i].getResizable());
                    tableColumns[i].setAlignment(dlgColumnProperties[i].getAlignment());
                    columnOrder[dlgColumnProperties[i].getColumnNumber()] = dlgColumnProperties[i].getIndex();
                    ++i;
                }
                ListWindow.this.mainTable.setColumnOrder(columnOrder);
            }
        });
        if (!isPopup) {
            ToolItem printItem = new ToolItem(adminToolBar, 8);
            printItem.setImage(Utility.getImage("print.png"));
            printItem.setToolTipText(Messages.getString("GUIText.PrintListItemButtonToolTip"));
            printItem.setEnabled(false);
            ToolItem exportItem = new ToolItem(adminToolBar, 8);
            exportItem.setImage(Utility.getImage("export.png"));
            exportItem.setToolTipText(Messages.getString("GUIText.ExportListItemButtonToolTip"));
            exportItem.setEnabled(false);
            adminToolBar.pack();
        }
        this.toolBar.setLayoutData((Object)Utility.getFormData(0, 0, null, 0, 0, 0, 100, -1));
    }

    protected void createTableBasics() {
        this.mainTable.setHeaderVisible(true);
        this.mainTable.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"MainTable");
        TableColumn[] tableColumns = new TableColumn[this.columns.size()];
        int i = 0;
        while (i < tableColumns.length) {
            tableColumns[i] = new TableColumn(this.mainTable, 16384);
            tableColumns[i].setWidth(100);
            tableColumns[i].setText(this.columns.get(i).getPublicColumnName());
            tableColumns[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int sortingDirection;
                    TableColumn currentColumn = (TableColumn)e.widget;
                    TableColumn sortColumn = ListWindow.this.mainTable.getSortColumn();
                    if (sortColumn == currentColumn) {
                        sortingDirection = ListWindow.this.mainTable.getSortDirection() == 128 ? 1024 : 128;
                    } else {
                        sortingDirection = 128;
                        ListWindow.this.mainTable.setSortColumn(currentColumn);
                    }
                    ListWindow.this.mainTable.setSortDirection(sortingDirection);
                    int columnNumber = currentColumn.getParent().indexOf(currentColumn);
                    String internalColumnName = ListWindow.this.columns.get(columnNumber).getInternalColumnName();
                    String sortDirection = sortingDirection == 128 ? "ASC" : "DESC";
                    ListWindow.this.sortString = "ORDER BY " + internalColumnName + " " + sortDirection;
                    ListWindow.this.update();
                }
            });
            ++i;
        }
    }

    protected void addUpdateListener(int type) {
        this.updateListener = new DBTableChangedListener(type){

            public void dBTableChanged() {
                ListWindow.this.update();
            }
        };
        AbstractTable.addDBTableChangedListener(this.updateListener);
    }

    protected abstract Object getTableInputFromDB();

    protected abstract void createSpecializedToolBarListeners();

    protected abstract void createSpecializedMainTableListener();

    protected abstract void createSpecializedMainTableListener(AssociationTabControl var1);

    protected abstract void createSpecializedMainTableListener(ForeignKeyConstraintSelector var1);

    protected abstract void createChooseButtonListener(AssociationTabControl var1);

    protected abstract void createChooseButtonListener(ForeignKeyConstraintSelector var1);
}

