/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui.list;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;
import semorg.gui.CompanyWindow;
import semorg.gui.MainWindow;
import semorg.gui.list.ListWindow;
import semorg.gui.provider.CompanyTableProvider;
import semorg.gui.util.AssociationTabControl;
import semorg.gui.util.ForeignKeyConstraintSelector;
import semorg.gui.util.Messages;
import semorg.sql.tables.Company;
import semorg.sql.tables.SimpleIDKey;
import semorg.sql.util.DBConstraint;
import semorg.sql.util.DistinctVector;
import semorg.sql.util.Utility;

public class CompanyListWindow
extends ListWindow {
    public static ListWindow instance;

    public CompanyListWindow() {
        super(MainWindow.getInstance().getShell(), Company.getColumns());
        this.mainTableViewer.setLabelProvider((IBaseLabelProvider)new CompanyTableProvider());
        this.shell.setText(Messages.getString("GUIText.CompanyListWindowTitleText"));
        this.update();
    }

    public CompanyListWindow(AssociationTabControl caller) {
        super(caller.getShell(), Company.getColumns(), caller);
        this.mainTableViewer.setLabelProvider((IBaseLabelProvider)new CompanyTableProvider());
        this.shell.setText(Messages.getString("GUIText.PopUpCompanyListWindowTitleText"));
        this.update();
        this.shell.open();
    }

    public CompanyListWindow(ForeignKeyConstraintSelector caller) {
        super(caller.getShell(), Company.getColumns(), caller);
        this.mainTableViewer.setLabelProvider((IBaseLabelProvider)new CompanyTableProvider());
        this.shell.setText(Messages.getString("GUIText.PopUpCompanyListWindowTitleText"));
        this.update();
        this.shell.open();
    }

    protected void createSpecializedMainTableListener() {
        this.addUpdateListener(5);
        this.mainTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                Company selectedItem = (Company)selection.getFirstElement();
                new CompanyWindow(MainWindow.getInstance().getShell(), selectedItem, null);
            }
        });
    }

    protected void createSpecializedMainTableListener(final AssociationTabControl caller) {
        this.addUpdateListener(5);
        this.mainTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                Company selectedItem = (Company)selection.getFirstElement();
                caller.addSelectedIds(new SimpleIDKey[]{selectedItem}, true);
                CompanyListWindow.this.shell.close();
            }
        });
    }

    protected void createSpecializedMainTableListener(final ForeignKeyConstraintSelector caller) {
        this.addUpdateListener(5);
        this.mainTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                Company selectedItem = (Company)selection.getFirstElement();
                caller.setSelectedId(selectedItem.getId());
                CompanyListWindow.this.shell.close();
            }
        });
    }

    protected void createSpecializedToolBarListeners() {
        this.editItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)CompanyListWindow.this.mainTableViewer.getSelection();
                Company selectedElement = (Company)selection.getFirstElement();
                new CompanyWindow(MainWindow.getInstance().getShell(), selectedElement, null);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.deleteItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)CompanyListWindow.this.mainTableViewer.getSelection();
                DistinctVector selectedElements = new DistinctVector(selection.toList());
                String question = selectedElements.size() > 1 ? Messages.getString("GUIText.DeleteCompanyItemsMessageDialogText") : Messages.getString("GUIText.DeleteCompanyItemMessageDialogText");
                MessageDialog dlg = new MessageDialog(MainWindow.getInstance().getShell(), Messages.getString("GUIText.DeleteItemMessageDialogTitle"), null, question, 3, new String[]{Messages.getString("GUIText.DeleteItemMessageDialogYesButtonText"), Messages.getString("GUIText.DeleteItemMessageDialogNoButtonText")}, 0);
                if (dlg.open() != 0) {
                    return;
                }
                try {
                    Iterator it = selectedElements.iterator();
                    while (it.hasNext()) {
                        int id = ((Company)it.next()).getId();
                        if (!Company.lockedIds.contains(new Integer(id))) continue;
                        MessageDialog.openInformation((Shell)CompanyListWindow.this.shell, (String)Messages.getString("GUIText.DeleteErrorDialogTitle"), (String)Messages.getString("GUIText.DeleteErrorDialogText"));
                        return;
                    }
                    Company.removeFromDB(selectedElements);
                    instance.update();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.newItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                new CompanyWindow(MainWindow.getInstance().getShell(), null, null);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
    }

    protected void createChooseButtonListener(final AssociationTabControl caller) {
        this.chooseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)CompanyListWindow.this.mainTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    Object[] selectedItems = selection.toArray();
                    SimpleIDKey[] selectedElements = (SimpleIDKey[])Utility.castArray(selectedItems, SimpleIDKey.class);
                    caller.addSelectedIds(selectedElements, true);
                    CompanyListWindow.this.shell.close();
                }
            }
        });
    }

    protected void createChooseButtonListener(final ForeignKeyConstraintSelector caller) {
        this.chooseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)CompanyListWindow.this.mainTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    Company selectedItem = (Company)selection.getFirstElement();
                    caller.setSelectedId(selectedItem.getId());
                    CompanyListWindow.this.shell.close();
                }
            }
        });
    }

    public static void openList() {
        CompanyListWindow.instance.shell.open();
    }

    protected Object getTableInputFromDB() {
        Vector<DBConstraint> constraints = null;
        if (this.filterItem.getSelection()) {
            try {
                constraints = this.filter.getConstraints();
            }
            catch (Exception e) {
                this.filterItem.setSelection(false);
            }
        }
        try {
            return Company.getVectorFromDB(constraints, this.sortString);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return new DistinctVector();
        }
    }

    public static void createWindow(Shell parent) {
        instance = new CompanyListWindow();
    }
}

