/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui.list;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;
import semorg.gui.CompanyBookingWindow;
import semorg.gui.MainWindow;
import semorg.gui.list.ListWindow;
import semorg.gui.provider.CompanyBookingTableProvider;
import semorg.gui.util.AssociationTabControl;
import semorg.gui.util.ForeignKeyConstraintSelector;
import semorg.gui.util.Messages;
import semorg.sql.tables.CompanyBooking;
import semorg.sql.tables.SimpleIDKey;
import semorg.sql.util.DBConstraint;
import semorg.sql.util.DistinctVector;
import semorg.sql.util.Utility;

public class CompanyBookingListWindow
extends ListWindow {
    public static ListWindow instance;

    public CompanyBookingListWindow() {
        super(MainWindow.getInstance().getShell(), CompanyBooking.getColumns());
        this.mainTableViewer.setLabelProvider((IBaseLabelProvider)new CompanyBookingTableProvider());
        this.shell.setText(Messages.getString("GUIText.CompanyBookingListWindowTitleText"));
        this.update();
    }

    public CompanyBookingListWindow(ForeignKeyConstraintSelector caller) {
        super(caller.getShell(), CompanyBooking.getColumns(), caller);
        this.mainTableViewer.setLabelProvider((IBaseLabelProvider)new CompanyBookingTableProvider());
        this.shell.setText(Messages.getString("GUIText.PopUpCompanyBookingListWindowTitleText"));
        this.update();
        this.shell.open();
    }

    public CompanyBookingListWindow(AssociationTabControl caller) {
        super(caller.getShell(), CompanyBooking.getColumns(), caller);
        this.mainTableViewer.setLabelProvider((IBaseLabelProvider)new CompanyBookingTableProvider());
        this.shell.setText(Messages.getString("GUIText.PopUpCompanyBookingListWindowTitleText"));
        this.update();
        this.shell.open();
    }

    protected void createSpecializedMainTableListener() {
        this.addUpdateListener(6);
        this.mainTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                CompanyBooking selectedItem = (CompanyBooking)selection.getFirstElement();
                new CompanyBookingWindow(MainWindow.getInstance().getShell(), selectedItem, null);
            }
        });
    }

    protected void createSpecializedMainTableListener(final AssociationTabControl caller) {
        this.addUpdateListener(6);
        this.mainTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                CompanyBooking selectedItem = (CompanyBooking)selection.getFirstElement();
                caller.addSelectedIds(new SimpleIDKey[]{selectedItem}, true);
                CompanyBookingListWindow.this.shell.close();
            }
        });
    }

    protected void createSpecializedMainTableListener(final ForeignKeyConstraintSelector caller) {
        this.addUpdateListener(6);
        this.mainTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                CompanyBooking selectedItem = (CompanyBooking)selection.getFirstElement();
                caller.setSelectedId(selectedItem.getId());
                CompanyBookingListWindow.this.shell.close();
            }
        });
    }

    protected void createSpecializedToolBarListeners() {
        this.editItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)CompanyBookingListWindow.this.mainTableViewer.getSelection();
                CompanyBooking selectedElement = (CompanyBooking)selection.getFirstElement();
                new CompanyBookingWindow(MainWindow.getInstance().getShell(), selectedElement, null);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.deleteItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)CompanyBookingListWindow.this.mainTableViewer.getSelection();
                DistinctVector selectedElements = new DistinctVector(selection.toList());
                String question = selectedElements.size() > 1 ? Messages.getString("GUIText.DeleteCompanyBookingItemsMessageDialogText") : Messages.getString("GUIText.DeleteCompanyBookingItemMessageDialogText");
                MessageDialog dlg = new MessageDialog(MainWindow.getInstance().getShell(), Messages.getString("GUIText.DeleteItemMessageDialogTitle"), null, question, 3, new String[]{Messages.getString("GUIText.DeleteItemMessageDialogYesButtonText"), Messages.getString("GUIText.DeleteItemMessageDialogNoButtonText")}, 0);
                if (dlg.open() != 0) {
                    return;
                }
                try {
                    Iterator it = selectedElements.iterator();
                    while (it.hasNext()) {
                        int id = ((CompanyBooking)it.next()).getId();
                        if (!CompanyBooking.lockedIds.contains(new Integer(id))) continue;
                        MessageDialog.openInformation((Shell)CompanyBookingListWindow.this.shell, (String)Messages.getString("GUIText.DeleteErrorDialogTitle"), (String)Messages.getString("GUIText.DeleteErrorDialogText"));
                        return;
                    }
                    CompanyBooking.removeFromDB(selectedElements);
                    instance.update();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.newItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                new CompanyBookingWindow(MainWindow.getInstance().getShell(), null, null);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
    }

    protected void createChooseButtonListener(final AssociationTabControl caller) {
        this.chooseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)CompanyBookingListWindow.this.mainTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    Object[] selectedItems = selection.toArray();
                    SimpleIDKey[] selectedElements = (SimpleIDKey[])Utility.castArray(selectedItems, SimpleIDKey.class);
                    caller.addSelectedIds(selectedElements, true);
                    CompanyBookingListWindow.this.shell.close();
                }
            }
        });
    }

    protected void createChooseButtonListener(final ForeignKeyConstraintSelector caller) {
        this.chooseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)CompanyBookingListWindow.this.mainTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    CompanyBooking selectedItem = (CompanyBooking)selection.getFirstElement();
                    caller.setSelectedId(selectedItem.getId());
                    CompanyBookingListWindow.this.shell.close();
                }
            }
        });
    }

    public static void openList() {
        CompanyBookingListWindow.instance.shell.open();
    }

    protected Object getTableInputFromDB() {
        Vector<DBConstraint> constraints = null;
        if (this.filterItem.getSelection()) {
            try {
                constraints = this.filter.getConstraints();
            }
            catch (Exception e) {
                this.filterItem.setSelection(false);
            }
        }
        try {
            return CompanyBooking.getVectorFromDB(constraints, this.sortString);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return new DistinctVector();
        }
    }

    public static void createWindow(Shell parent) {
        instance = new CompanyBookingListWindow();
    }
}

