/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui;

import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import semorg.gui.list.SeminarTypeListWindow;
import semorg.gui.util.AssociationTabControl;
import semorg.gui.util.CalendarControl;
import semorg.gui.util.ForeignKeyConstraintSelector;
import semorg.gui.util.ItemListener;
import semorg.gui.util.Messages;
import semorg.sql.tables.SeminarType;
import semorg.sql.tables.SimpleIDKey;
import semorg.sql.util.Utility;

public class SeminarTypeWindow {
    private SeminarType input;
    private boolean settingInput = false;
    private boolean inputChanged;
    private boolean inputEditingEnabled;
    private InputChangedListener inputChangedListener = new InputChangedListener();
    private Shell shell;
    private final Label numberLabel;
    private final Text numberText;
    private final Text shortTitleText;
    private final Text titleText;
    private final Text objectiveText;
    private final Text methodologyText;
    private final Text topicText;
    private final Text routineText;
    private final Text durationText;
    private final Text documentsText;
    private final Text audienceText;
    private final Text requirementsText;
    private final Text chargeText;
    private final Text maxEntrantsText;
    private final Text minEntrantsText;
    private AssociationTabControl presentationControl;
    private AssociationTabControl lecturerControl;
    private final Button okButton;
    private final Button applyButton;
    private final Button newButton;
    private final Button abortButton;
    private final Button prevButton;
    private final Button nextButton;

    private SeminarTypeWindow(Shell parent) {
        this.shell = new Shell(parent, 64);
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                if (SeminarTypeWindow.this.inputChanged) {
                    if (SeminarTypeWindow.this.confirmClose()) {
                        if (SeminarTypeWindow.this.inputEditingEnabled && SeminarTypeWindow.this.input != null) {
                            SeminarType.lockedIds.remove(new Integer(SeminarTypeWindow.this.input.getId()));
                        }
                    } else {
                        event.doit = false;
                    }
                } else if (SeminarTypeWindow.this.input != null && SeminarTypeWindow.this.inputEditingEnabled) {
                    SeminarType.lockedIds.remove(new Integer(SeminarTypeWindow.this.input.getId()));
                }
            }
        });
        this.shell.setLayout((Layout)new GridLayout(1, false));
        this.shell.setSize(550, 730);
        this.shell.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"SeminarTypeWindow");
        GridData mgd = new GridData();
        mgd.horizontalAlignment = 4;
        mgd.verticalAlignment = 4;
        mgd.grabExcessHorizontalSpace = true;
        mgd.grabExcessVerticalSpace = true;
        Group mainForm = new Group((Composite)this.shell, 0);
        mainForm.setLayoutData((Object)mgd);
        GridLayout mgl = new GridLayout(2, false);
        mgl.marginHeight = 0;
        mainForm.setLayout((Layout)mgl);
        TabFolder tabs = new TabFolder((Composite)this.shell, 0x800000);
        tabs.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"Tabs");
        GridData tgd = new GridData();
        tgd.heightHint = 130;
        tgd.horizontalAlignment = 4;
        tgd.grabExcessHorizontalSpace = true;
        tabs.setLayoutData((Object)tgd);
        Composite leftColumn = new Composite((Composite)mainForm, 0);
        leftColumn.setLayout((Layout)new GridLayout(1, false));
        GridData lcgd = new GridData();
        lcgd.horizontalAlignment = 4;
        lcgd.grabExcessHorizontalSpace = true;
        lcgd.verticalAlignment = 1;
        leftColumn.setLayoutData((Object)lcgd);
        Composite rightColumn = new Composite((Composite)mainForm, 0);
        rightColumn.setLayout((Layout)new GridLayout(1, false));
        GridData rightColumnGridData = new GridData();
        rightColumnGridData.horizontalAlignment = 4;
        rightColumnGridData.grabExcessHorizontalSpace = true;
        rightColumnGridData.verticalAlignment = 1;
        rightColumn.setLayoutData((Object)rightColumnGridData);
        Composite idComposite = new Composite(leftColumn, 0);
        idComposite.setLayout((Layout)new GridLayout(2, false));
        this.numberLabel = new Label(idComposite, 8);
        this.numberLabel.setText(Messages.getString("GUIText.NumberText"));
        this.numberText = new Text(idComposite, 2060);
        this.numberText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"NumberText");
        Utility.setLength(this.numberText, 10);
        this.numberText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.numberText.setToolTipText(Messages.getString("GUIText.NumberToolTip"));
        Label shortTitleLabel = new Label(idComposite, 8);
        shortTitleLabel.setText(Messages.getString("GUIText.ShortTitleText"));
        this.shortTitleText = new Text(idComposite, 2052);
        this.shortTitleText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"ShortTitleText");
        this.shortTitleText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.shortTitleText.setBackground(Utility.LIGHT_YELLOW);
        this.shortTitleText.addFocusListener(Utility.checkEmptyListener);
        this.shortTitleText.setToolTipText(Messages.getString("GUIText.ShortTitleToolTip"));
        Utility.setLength(this.shortTitleText, 10);
        Label titleLabel = new Label(leftColumn, 8);
        titleLabel.setText(Messages.getString("GUIText.TitelText"));
        this.titleText = new Text(leftColumn, 2626);
        this.titleText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"TitleText");
        this.titleText.addModifyListener((ModifyListener)this.inputChangedListener);
        GridData textGridData = new GridData();
        textGridData.widthHint = 220;
        textGridData.heightHint = 60;
        this.titleText.setLayoutData((Object)textGridData);
        this.titleText.setTextLimit(50);
        this.titleText.setToolTipText(Messages.getString("GUIText.TitleToolTip"));
        Label objectiveLabel = new Label(leftColumn, 8);
        objectiveLabel.setText(Messages.getString("GUIText.ObjectiveText"));
        this.objectiveText = new Text(leftColumn, 2626);
        this.objectiveText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"ObjectiveText");
        this.objectiveText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.objectiveText.setLayoutData((Object)textGridData);
        this.objectiveText.setTextLimit(400);
        this.objectiveText.setToolTipText(Messages.getString("GUIText.ObjectiveToolTip"));
        Label methodologyLabel = new Label(leftColumn, 8);
        methodologyLabel.setText(Messages.getString("GUIText.MethodologyText"));
        this.methodologyText = new Text(leftColumn, 2626);
        this.methodologyText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"MethodologyText");
        this.methodologyText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.methodologyText.setLayoutData((Object)textGridData);
        this.methodologyText.setTextLimit(400);
        this.methodologyText.setToolTipText(Messages.getString("GUIText.MethodologyToolTip"));
        Label topicLabel = new Label(leftColumn, 8);
        topicLabel.setText(Messages.getString("GUIText.TopicText"));
        this.topicText = new Text(leftColumn, 2626);
        this.topicText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"TopicText");
        this.topicText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.topicText.setLayoutData((Object)textGridData);
        this.topicText.setTextLimit(400);
        this.topicText.setToolTipText(Messages.getString("GUIText.TopicToolTip"));
        Label routineLabel = new Label(rightColumn, 8);
        routineLabel.setText(Messages.getString("GUIText.RoutineText"));
        this.routineText = new Text(rightColumn, 2626);
        this.routineText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"RoutineText");
        this.routineText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.routineText.setLayoutData((Object)textGridData);
        this.routineText.setTextLimit(200);
        this.routineText.setToolTipText(Messages.getString("GUIText.RoutineToolTip"));
        Composite durationComp = new Composite(rightColumn, 0);
        durationComp.setLayout((Layout)new GridLayout(2, false));
        Label durationLabel = new Label(durationComp, 8);
        durationLabel.setText(Messages.getString("GUIText.DurationText"));
        this.durationText = new Text(durationComp, 2052);
        this.durationText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"DurationText");
        Utility.setLength(this.durationText, 10);
        this.durationText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.durationText.addFocusListener(Utility.checkCorrectIntListener);
        this.durationText.setToolTipText(Messages.getString("GUIText.DurationToolTip"));
        Label documentsLabel = new Label(rightColumn, 8);
        documentsLabel.setText(Messages.getString("GUIText.DocumentsText"));
        this.documentsText = new Text(rightColumn, 2626);
        this.documentsText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"DocumentsText");
        this.documentsText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.documentsText.setLayoutData((Object)textGridData);
        this.documentsText.setTextLimit(200);
        this.documentsText.setToolTipText(Messages.getString("GUIText.DocumentsToolTip"));
        Label audienceLabel = new Label(rightColumn, 8);
        audienceLabel.setText(Messages.getString("GUIText.AudienceText"));
        this.audienceText = new Text(rightColumn, 2626);
        this.audienceText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"AudienceText");
        this.audienceText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.audienceText.setLayoutData((Object)textGridData);
        this.audienceText.setTextLimit(200);
        this.audienceText.setToolTipText(Messages.getString("GUIText.AudienceToolTip"));
        Label requirementsLabel = new Label(rightColumn, 8);
        requirementsLabel.setText(Messages.getString("GUIText.RequirementsText"));
        this.requirementsText = new Text(rightColumn, 2626);
        this.requirementsText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"RequirementsText");
        this.requirementsText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.requirementsText.setLayoutData((Object)textGridData);
        this.requirementsText.setTextLimit(200);
        this.requirementsText.setToolTipText(Messages.getString("GUIText.RequirementsToolTip"));
        Composite additionalComponents = new Composite(rightColumn, 0);
        additionalComponents.setLayout((Layout)new GridLayout(2, false));
        Label chargeLabel = new Label(additionalComponents, 8);
        chargeLabel.setText(Messages.getString("GUIText.ChargeText"));
        Utility.alignRight((Control)chargeLabel);
        this.chargeText = new Text(additionalComponents, 2052);
        this.chargeText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"ChargeText");
        Utility.setLength(this.chargeText, 10);
        this.chargeText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.chargeText.addFocusListener(Utility.checkCorrectFloatListener);
        this.chargeText.setToolTipText(Messages.getString("GUIText.ChargeToolTip"));
        Label maxEntrantsLabel = new Label(additionalComponents, 8);
        maxEntrantsLabel.setText(Messages.getString("GUIText.MaxEntrantsText"));
        Utility.alignRight((Control)maxEntrantsLabel);
        this.maxEntrantsText = new Text(additionalComponents, 2052);
        this.maxEntrantsText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"MaxEntrantsText");
        Utility.setLength(this.maxEntrantsText, 10);
        this.maxEntrantsText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.maxEntrantsText.addFocusListener(Utility.checkCorrectIntListener);
        this.maxEntrantsText.setToolTipText(Messages.getString("GUIText.MaxEntrantsToolTip"));
        Label minEntrantsLabel = new Label(additionalComponents, 8);
        minEntrantsLabel.setText(Messages.getString("GUIText.MinEntrantsText"));
        Utility.alignRight((Control)minEntrantsLabel);
        this.minEntrantsText = new Text(additionalComponents, 2052);
        this.minEntrantsText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"MinEntrantsText");
        Utility.setLength(this.minEntrantsText, 10);
        this.minEntrantsText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.minEntrantsText.addFocusListener(Utility.checkCorrectIntListener);
        this.minEntrantsText.setToolTipText(Messages.getString("GUIText.MinEntrantsToolTip"));
        TabItem presentationItem = new TabItem(tabs, 0);
        presentationItem.setText(Messages.getString("GUIText.PresentationsControlText"));
        this.presentationControl = new AssociationTabControl((Composite)tabs, 10, this.shell);
        this.presentationControl.addItemListener(this.inputChangedListener);
        this.presentationControl.setData("ATOSJ_COMPONENT_NAME_KEY", "PresentationControl");
        presentationItem.setControl((Control)this.presentationControl);
        TabItem lecturerItem = new TabItem(tabs, 0);
        lecturerItem.setText(Messages.getString("GUIText.LecturersControlText"));
        this.lecturerControl = new AssociationTabControl((Composite)tabs, 11, this.shell);
        this.lecturerControl.addItemListener(this.inputChangedListener);
        this.lecturerControl.setData("ATOSJ_COMPONENT_NAME_KEY", "LecturerControl");
        lecturerItem.setControl((Control)this.lecturerControl);
        Composite buttons = new Composite((Composite)this.shell, this.shell.getStyle());
        buttons.setLayout((Layout)new GridLayout(7, false));
        this.okButton = new Button(buttons, 8);
        this.okButton.setText(Messages.getString("GUIText.OkButtonText"));
        this.okButton.setLayoutData((Object)new GridData(1040));
        this.applyButton = new Button(buttons, 8);
        this.applyButton.setText(Messages.getString("GUIText.ApplyButtonText"));
        this.applyButton.setLayoutData((Object)new GridData(1040));
        this.newButton = new Button(buttons, 8);
        this.newButton.setText(Messages.getString("GUIText.NewButtonText"));
        this.newButton.setLayoutData((Object)new GridData(1040));
        this.abortButton = new Button(buttons, 8);
        this.abortButton.setText(Messages.getString("GUIText.AbortButtonText"));
        this.abortButton.setLayoutData((Object)new GridData(1040));
        GridData arrowButtonGridData = new GridData();
        arrowButtonGridData.verticalAlignment = 4;
        arrowButtonGridData.grabExcessVerticalSpace = true;
        arrowButtonGridData.widthHint = 23;
        this.prevButton = new Button(buttons, 16388);
        this.prevButton.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"Previous");
        this.prevButton.setLayoutData((Object)arrowButtonGridData);
        this.nextButton = new Button(buttons, 131076);
        this.nextButton.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"Next");
        this.nextButton.setLayoutData((Object)arrowButtonGridData);
    }

    public SeminarTypeWindow(Shell parent, SeminarType input, AssociationTabControl caller) {
        this(parent);
        this.createButtonListener(caller);
        this.setInput(input);
        this.shell.open();
    }

    public SeminarTypeWindow(Shell parent, SeminarType input, ForeignKeyConstraintSelector caller) {
        this(parent);
        this.createButtonListener(caller);
        this.setInput(input);
        this.shell.open();
    }

    private void setInput(SeminarType seminarType) {
        this.settingInput = true;
        if (this.input != null && this.inputEditingEnabled) {
            SeminarType.lockedIds.remove(new Integer(this.input.getId()));
        }
        if (seminarType != null) {
            this.numberLabel.setEnabled(true);
            this.numberText.setEnabled(true);
            this.shortTitleText.setFocus();
            this.numberText.setText(new Integer(seminarType.getId()).toString());
            if (seminarType.getShortTitle() != null) {
                this.shortTitleText.setText(seminarType.getShortTitle());
            } else {
                this.shortTitleText.setText("");
            }
            if (seminarType.getTitle() != null) {
                this.titleText.setText(seminarType.getTitle());
            } else {
                this.titleText.setText("");
            }
            if (seminarType.getObjective() != null) {
                this.objectiveText.setText(seminarType.getObjective());
            } else {
                this.objectiveText.setText("");
            }
            if (seminarType.getMethodology() != null) {
                this.methodologyText.setText(seminarType.getMethodology());
            } else {
                this.methodologyText.setText("");
            }
            if (seminarType.getTopic() != null) {
                this.topicText.setText(seminarType.getTopic());
            } else {
                this.topicText.setText("");
            }
            if (seminarType.getRoutine() != null) {
                this.routineText.setText(seminarType.getRoutine());
            } else {
                this.routineText.setText("");
            }
            if (seminarType.getDuration() != null) {
                this.durationText.setText(seminarType.getDuration().toString());
            } else {
                this.durationText.setText("");
            }
            if (seminarType.getDocuments() != null) {
                this.documentsText.setText(seminarType.getDocuments());
            } else {
                this.documentsText.setText("");
            }
            if (seminarType.getAudience() != null) {
                this.audienceText.setText(seminarType.getAudience());
            } else {
                this.audienceText.setText("");
            }
            if (seminarType.getRequirements() != null) {
                this.requirementsText.setText(seminarType.getRequirements());
            } else {
                this.requirementsText.setText("");
            }
            if (seminarType.getCharge() != null) {
                this.chargeText.setText(Utility.createFloatText(seminarType.getCharge()));
            } else {
                this.chargeText.setText("");
            }
            if (seminarType.getMaxEntrants() != null) {
                this.maxEntrantsText.setText(seminarType.getMaxEntrants().toString());
            } else {
                this.maxEntrantsText.setText("");
            }
            if (seminarType.getMinEntrants() != null) {
                this.minEntrantsText.setText(seminarType.getMinEntrants().toString());
            } else {
                this.minEntrantsText.setText("");
            }
            try {
                this.presentationControl.setInput(seminarType.getId());
                this.lecturerControl.setInput(seminarType.getId());
            }
            catch (SQLException sQLException) {}
        } else {
            this.shortTitleText.setFocus();
            this.numberLabel.setEnabled(false);
            this.numberText.setEnabled(false);
            this.numberText.setText("");
            this.shortTitleText.setText("");
            this.titleText.setText("");
            this.objectiveText.setText("");
            this.methodologyText.setText("");
            this.topicText.setText("");
            this.routineText.setText("");
            this.durationText.setText("");
            this.documentsText.setText("");
            this.audienceText.setText("");
            this.requirementsText.setText("");
            this.chargeText.setText("");
            this.maxEntrantsText.setText("");
            this.minEntrantsText.setText("");
            try {
                this.presentationControl.setInput(0);
                this.lecturerControl.setInput(0);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (seminarType != null) {
            boolean alreadyEditing = SeminarType.lockedIds.contains(new Integer(seminarType.getId()));
            this.setInputComponentsEnabled(!alreadyEditing);
            if (!alreadyEditing) {
                SeminarType.lockedIds.add(new Integer(seminarType.getId()));
            }
        } else {
            this.setInputComponentsEnabled(true);
        }
        this.input = seminarType;
        this.inputChanged = seminarType == null;
        this.prevButton.setEnabled(this.input != null);
        this.nextButton.setEnabled(this.input != null);
        String shellText = this.input == null ? Messages.getString("GUIText.NewItemWindowTitleText") : Integer.toString(this.input.getId());
        shellText = String.valueOf(shellText) + Messages.getString("GUIText.SeminarTypeWindowTitleText");
        if (this.input == null) {
            shellText = String.valueOf(shellText) + "*";
        }
        this.shell.setText(shellText);
        this.settingInput = false;
    }

    private void setInputComponentsEnabled(boolean enabled) {
        this.numberText.setEnabled(enabled);
        this.shortTitleText.setEnabled(enabled);
        this.titleText.setEnabled(enabled);
        this.objectiveText.setEnabled(enabled);
        this.methodologyText.setEnabled(enabled);
        this.topicText.setEnabled(enabled);
        this.routineText.setEnabled(enabled);
        this.durationText.setEnabled(enabled);
        this.documentsText.setEnabled(enabled);
        this.audienceText.setEnabled(enabled);
        this.requirementsText.setEnabled(enabled);
        this.chargeText.setEnabled(enabled);
        this.maxEntrantsText.setEnabled(enabled);
        this.minEntrantsText.setEnabled(enabled);
        this.presentationControl.setEnabled(enabled);
        this.lecturerControl.setEnabled(enabled);
        this.okButton.setEnabled(enabled);
        this.applyButton.setEnabled(enabled);
        this.newButton.setEnabled(enabled);
        this.abortButton.setEnabled(enabled);
        this.prevButton.setEnabled(enabled);
        this.nextButton.setEnabled(enabled);
        this.inputEditingEnabled = enabled;
    }

    private void createButtonListener(final AssociationTabControl caller) {
        if (caller == null) {
            this.okButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (SeminarTypeWindow.this.onSave()) {
                        SeminarTypeWindow.this.shell.close();
                    }
                }
            });
            this.applyButton.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    SeminarTypeWindow.this.onSave();
                }
            });
        } else {
            this.okButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (SeminarTypeWindow.this.onSave()) {
                        caller.addSelectedIds(new SimpleIDKey[]{SeminarTypeWindow.this.input}, false);
                        SeminarTypeWindow.this.shell.close();
                    }
                }
            });
            this.applyButton.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    if (SeminarTypeWindow.this.onSave()) {
                        caller.addSelectedIds(new SimpleIDKey[]{SeminarTypeWindow.this.input}, false);
                    }
                }
            });
        }
        this.newButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (SeminarTypeWindow.this.onSave()) {
                    SeminarTypeWindow.this.setInput(null);
                }
            }
        });
        this.abortButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SeminarTypeWindow.this.shell.close();
            }
        });
        this.prevButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (SeminarTypeWindow.this.inputChanged) {
                    if (SeminarTypeWindow.this.confirmClose()) {
                        SeminarTypeWindow.this.setInput(SeminarType.getPrevious(SeminarTypeWindow.this.input.getId()));
                    }
                } else {
                    SeminarTypeWindow.this.setInput(SeminarType.getPrevious(SeminarTypeWindow.this.input.getId()));
                }
            }
        });
        this.nextButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (SeminarTypeWindow.this.inputChanged) {
                    if (SeminarTypeWindow.this.confirmClose()) {
                        SeminarTypeWindow.this.setInput(SeminarType.getNext(SeminarTypeWindow.this.input.getId()));
                    }
                } else {
                    SeminarTypeWindow.this.setInput(SeminarType.getNext(SeminarTypeWindow.this.input.getId()));
                }
            }
        });
    }

    private void createButtonListener(final ForeignKeyConstraintSelector caller) {
        if (caller == null) {
            this.okButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (SeminarTypeWindow.this.onSave()) {
                        SeminarTypeWindow.this.shell.close();
                    }
                }
            });
            this.applyButton.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    SeminarTypeWindow.this.onSave();
                }
            });
        } else {
            this.okButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (SeminarTypeWindow.this.onSave()) {
                        caller.setSelectedId(SeminarTypeWindow.this.input.getId());
                        SeminarTypeWindow.this.shell.close();
                    }
                }
            });
            this.applyButton.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    if (SeminarTypeWindow.this.onSave()) {
                        caller.setSelectedId(SeminarTypeWindow.this.input.getId());
                    }
                }
            });
        }
        this.newButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (SeminarTypeWindow.this.onSave()) {
                    SeminarTypeWindow.this.setInput(null);
                }
            }
        });
        this.abortButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SeminarTypeWindow.this.shell.close();
            }
        });
        this.prevButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (SeminarTypeWindow.this.inputChanged) {
                    if (SeminarTypeWindow.this.confirmClose()) {
                        SeminarTypeWindow.this.setInput(SeminarType.getPrevious(SeminarTypeWindow.this.input.getId()));
                    }
                } else {
                    SeminarTypeWindow.this.setInput(SeminarType.getPrevious(SeminarTypeWindow.this.input.getId()));
                }
            }
        });
        this.nextButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (SeminarTypeWindow.this.inputChanged) {
                    if (SeminarTypeWindow.this.confirmClose()) {
                        SeminarTypeWindow.this.setInput(SeminarType.getNext(SeminarTypeWindow.this.input.getId()));
                    }
                } else {
                    SeminarTypeWindow.this.setInput(SeminarType.getNext(SeminarTypeWindow.this.input.getId()));
                }
            }
        });
    }

    protected boolean checkInput() {
        boolean inputOK = true;
        String errorMessage = "";
        if (this.shortTitleText.getText().equals("")) {
            errorMessage = String.valueOf(errorMessage) + Messages.getString("GUIText.ErrorMessageDialogMandatoryFieldShortTitleText");
            inputOK = false;
        }
        if (!Utility.isCorrectInteger(this.durationText.getText())) {
            errorMessage = String.valueOf(errorMessage) + Messages.getString("GUIText.ErrorMessageDialogIncorrectNumberDuration");
            inputOK = false;
        }
        if (!Utility.isCorrectFloat(this.chargeText.getText())) {
            errorMessage = String.valueOf(errorMessage) + Messages.getString("GUIText.ErrorMessageDialogIncorrectFloatCharge");
            inputOK = false;
        }
        if (!Utility.isCorrectInteger(this.minEntrantsText.getText())) {
            errorMessage = String.valueOf(errorMessage) + Messages.getString("GUIText.ErrorMessageDialogIncorrectNumberMinEntrants");
            inputOK = false;
        }
        if (!Utility.isCorrectInteger(this.maxEntrantsText.getText())) {
            errorMessage = String.valueOf(errorMessage) + Messages.getString("GUIText.ErrorMessageDialogIncorrectNumberMaxEntrants");
            inputOK = false;
        }
        if (Utility.isCorrectInteger(this.maxEntrantsText.getText()) && Utility.isCorrectInteger(this.minEntrantsText.getText()) && Utility.parseInteger(this.maxEntrantsText.getText()) != null && Utility.parseInteger(this.minEntrantsText.getText()) != null && Utility.parseInteger(this.minEntrantsText.getText()) > Utility.parseInteger(this.maxEntrantsText.getText())) {
            errorMessage = String.valueOf(errorMessage) + Messages.getString("GUIText.ErrorMessageDialogMaxEntrantsLessThanMinEntrants");
            inputOK = false;
        }
        if (!inputOK) {
            MessageDialog.openInformation((Shell)this.shell, (String)Messages.getString("GUIText.ErrorMessageDialogMandatoryFieldWindowTitle"), (String)errorMessage);
        }
        return inputOK;
    }

    protected void commitInputToDB() {
        if (this.input == null) {
            SeminarType newInput;
            this.input = newInput = new SeminarType(0, this.shortTitleText.getText(), this.titleText.getText(), this.objectiveText.getText(), this.methodologyText.getText(), this.topicText.getText(), this.routineText.getText(), Utility.parseInteger(this.durationText.getText()), this.documentsText.getText(), this.audienceText.getText(), this.requirementsText.getText(), Utility.parseFloat(this.chargeText.getText()), Utility.parseInteger(this.maxEntrantsText.getText()), Utility.parseInteger(this.minEntrantsText.getText()), new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()));
            try {
                int id = this.input.insertIntoDB();
                this.numberText.setText(new Integer(id).toString());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            this.input.setShortTitle(this.shortTitleText.getText());
            this.input.setTitle(this.titleText.getText());
            this.input.setObjective(this.objectiveText.getText());
            this.input.setMethodology(this.methodologyText.getText());
            this.input.setTopic(this.topicText.getText());
            this.input.setRoutine(this.routineText.getText());
            this.input.setDuration(Utility.parseInteger(this.durationText.getText()));
            this.input.setDocuments(this.documentsText.getText());
            this.input.setAudience(this.audienceText.getText());
            this.input.setRequirements(this.requirementsText.getText());
            this.input.setCharge(Utility.parseFloat(this.chargeText.getText()));
            this.input.setMaxEntrants(Utility.parseInteger(this.maxEntrantsText.getText()));
            this.input.setMinEntrants(Utility.parseInteger(this.minEntrantsText.getText()));
            try {
                this.input.updateDB();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        try {
            this.presentationControl.commitIntoDB(this.input.getId());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            this.lecturerControl.commitIntoDB(this.input.getId());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        SeminarTypeListWindow.instance.update();
    }

    private boolean confirmClose() {
        MessageDialog dlg = this.input == null ? new MessageDialog(this.shell, Messages.getString("GUIText.SaveNewItemMessageDialogWindowTitle"), null, Messages.getString("GUIText.SaveNewItemMessageDialogQuestionText"), 3, new String[]{Messages.getString("GUIText.SaveNewItemMessageDialogYesButtonText"), Messages.getString("GUIText.SaveNewItemMessageDialogNoButtonText"), Messages.getString("GUIText.SaveNewItemMessageDialogAbortButtonText")}, 0) : new MessageDialog(this.shell, Messages.getString("GUIText.SaveChangesMessageDialogWindowTitle"), null, Messages.getString("GUIText.SaveChangesMessageDialogQuestionText"), 3, new String[]{Messages.getString("GUIText.SaveChangesMessageDialogYesButtonText"), Messages.getString("GUIText.SaveChangesMessageDialogNoButtonText"), Messages.getString("GUIText.SaveChangesMessageDialogAbortButtonText")}, 0);
        switch (dlg.open()) {
            case 0: {
                return this.onSave();
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return true;
    }

    private boolean onSave() {
        if (!this.inputChanged) {
            return true;
        }
        if (this.checkInput()) {
            this.commitInputToDB();
            this.setInput(this.input);
            return true;
        }
        return false;
    }

    class InputChangedListener
    implements ModifyListener,
    SelectionListener,
    CalendarControl.SWTCalendarListener,
    ItemListener {
        InputChangedListener() {
        }

        private void inputChanged() {
            if (!SeminarTypeWindow.this.settingInput && !SeminarTypeWindow.this.inputChanged) {
                SeminarTypeWindow.this.inputChanged = true;
                SeminarTypeWindow.this.shell.setText(String.valueOf(SeminarTypeWindow.this.shell.getText()) + "*");
            }
        }

        public void modifyText(ModifyEvent e) {
            this.inputChanged();
        }

        public void widgetSelected(SelectionEvent e) {
            this.inputChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.inputChanged();
        }

        public void dateChanged(CalendarControl.SWTCalendarEvent event) {
            this.inputChanged();
        }

        public void itemChanged() {
            this.inputChanged();
        }
    }
}

