/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import semorg.gui.AppStarter;
import semorg.gui.MainWindow;
import semorg.gui.util.Messages;

public class SelectLanguageWindow {
    private Shell shell;
    private Shell parent;
    private Combo selectLangCombo;
    private Button okButton;
    private Button abortButton;

    public SelectLanguageWindow(Shell parent) {
        this.parent = parent;
        this.shell = new Shell(parent, 32864);
        this.shell.setSize(200, 180);
        this.shell.setText(Messages.getString("GUIText.SelectLanguageComboTitleText"));
        this.shell.setLayout((Layout)new GridLayout(1, false));
        GridData mainFormData = new GridData();
        mainFormData.horizontalAlignment = 2;
        mainFormData.verticalAlignment = 2;
        mainFormData.grabExcessHorizontalSpace = true;
        mainFormData.grabExcessVerticalSpace = true;
        mainFormData.widthHint = 150;
        Group mainForm = new Group((Composite)this.shell, 0);
        mainForm.setLayoutData((Object)mainFormData);
        mainForm.setLayout((Layout)new GridLayout(1, false));
        mainForm.setText(Messages.getString("GUIText.SelectLanguageWindowTitleText"));
        GridData selectLangComboData = new GridData();
        selectLangComboData.horizontalAlignment = 2;
        selectLangComboData.grabExcessHorizontalSpace = true;
        selectLangComboData.grabExcessVerticalSpace = true;
        selectLangComboData.widthHint = 150;
        selectLangComboData.verticalIndent = 10;
        this.selectLangCombo = new Combo((Composite)mainForm, 64);
        this.selectLangCombo.setItems(new String[]{Messages.getString("GUIText.SelectLanguageComboItemGermanText"), Messages.getString("GUIText.SelectLanguageComboItemEnglishText")});
        this.selectLangCombo.select(this.getCurrentLanguage());
        this.selectLangCombo.setToolTipText(Messages.getString("GUIText.SelectLanguageComboToolTip"));
        this.selectLangCombo.setLayout((Layout)new GridLayout(1, false));
        this.selectLangCombo.setLayoutData((Object)selectLangComboData);
        Composite buttons = new Composite((Composite)this.shell, this.shell.getStyle());
        buttons.setLayout((Layout)new GridLayout(2, false));
        GridData buttonsData = new GridData();
        buttonsData.horizontalAlignment = 2;
        buttonsData.verticalAlignment = 3;
        buttonsData.grabExcessHorizontalSpace = true;
        buttonsData.grabExcessVerticalSpace = true;
        buttons.setLayoutData((Object)buttonsData);
        this.okButton = new Button(buttons, 8);
        this.okButton.setText(Messages.getString("GUIText.OkButtonText"));
        this.okButton.setLayoutData((Object)new GridData(2));
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String lang = SelectLanguageWindow.this.selectLangCombo.getText();
                if (lang.equals(Messages.getString("GUIText.SelectLanguageComboItemGermanText"))) {
                    MainWindow.getInstance().getConfiguration().setProperty("language", "de");
                    MainWindow.getInstance().getConfiguration().setProperty("background", "back_de.png");
                } else if (lang.equals(Messages.getString("GUIText.SelectLanguageComboItemEnglishText"))) {
                    MainWindow.getInstance().getConfiguration().setProperty("language", "en");
                    MainWindow.getInstance().getConfiguration().setProperty("background", "back_en.png");
                }
                MessageDialog dlg = new MessageDialog(MainWindow.getInstance().getShell(), Messages.getString("GUIText.LanguageChangedMessageDialogWindowTitle"), null, Messages.getString("GUIText.LanguageChangedMessageDialogHintText"), 3, new String[]{Messages.getString("GUIText.OkButtonText")}, 0);
                dlg.open();
                SelectLanguageWindow.this.shell.close();
                AppStarter.main(null);
                SelectLanguageWindow.this.parent.close();
            }
        });
        this.abortButton = new Button(buttons, 8);
        this.abortButton.setText(Messages.getString("GUIText.AbortButtonText"));
        this.abortButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectLanguageWindow.this.shell.close();
            }
        });
        this.shell.open();
    }

    private int getCurrentLanguage() {
        if (MainWindow.getInstance().getConfiguration().getProperty("language").equals("en")) {
            return 1;
        }
        if (MainWindow.getInstance().getConfiguration().getProperty("language").equals("de")) {
            return 0;
        }
        return -1;
    }
}

