/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui;

import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import semorg.gui.list.PublicPresentationListWindow;
import semorg.gui.util.AssociationTabControl;
import semorg.gui.util.CalendarControl;
import semorg.gui.util.ForeignKeyConstraintSelector;
import semorg.gui.util.ItemListener;
import semorg.gui.util.Messages;
import semorg.gui.util.TimeControl;
import semorg.sql.tables.Enumeration;
import semorg.sql.tables.PublicPresentation;
import semorg.sql.tables.SeminarType;
import semorg.sql.tables.SimpleIDKey;
import semorg.sql.util.Utility;

public class PublicPresentationWindow {
    private PublicPresentation input;
    private boolean settingInput = false;
    private boolean inputChanged;
    private boolean inputEditingEnabled;
    private InputChangedListener inputChangedListener = new InputChangedListener();
    private Shell shell;
    private int titleBarHeight;
    private final Label numberLabel;
    private final Text numberText;
    private final Text durationText;
    private final CalendarControl beginningDayCalendar;
    private final CalendarControl endingDayCalendar;
    private final TimeControl startingTimeSpinner;
    private final TimeControl endingTimeSpinner;
    private final TimeControl firstStartingTimeSpinner;
    private final TimeControl lastEndingTimeSpinner;
    private final Text locationText;
    private final Text streetText;
    private final Text zipCodeText;
    private final Text cityText;
    private final Combo countryCombo;
    private final Combo annexCombo;
    private final Button cancelChecker;
    private final ForeignKeyConstraintSelector semTypeSelector;
    private final Text coopPartnerText;
    private final Text cancelFeeText;
    private final Text currentEntrantsText;
    private final Text minSemTypeEntrantsText;
    private final Text maxSemTypeEntrantsText;
    private AssociationTabControl supervisorControl;
    private AssociationTabControl instructorControl;
    private AssociationTabControl bookingControl;
    private final Button okButton;
    private final Button applyButton;
    private final Button newButton;
    private final Button abortButton;
    private final Button prevButton;
    private final Button nextButton;
    private final Button listOfParticipantsButton;
    private final Button certificateButton;
    private final Button feeMessageButton;
    private final Button cancelationButton;

    private PublicPresentationWindow(Shell parent) {
        this.shell = new Shell(parent, 64);
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                if (PublicPresentationWindow.this.inputChanged) {
                    if (PublicPresentationWindow.this.confirmClose()) {
                        if (PublicPresentationWindow.this.inputEditingEnabled && PublicPresentationWindow.this.input != null) {
                            PublicPresentation.lockedIds.remove(new Integer(PublicPresentationWindow.this.input.getId()));
                        }
                    } else {
                        event.doit = false;
                    }
                } else if (PublicPresentationWindow.this.input != null && PublicPresentationWindow.this.inputEditingEnabled) {
                    PublicPresentation.lockedIds.remove(new Integer(PublicPresentationWindow.this.input.getId()));
                }
            }
        });
        this.shell.setLayout((Layout)new GridLayout(1, false));
        this.shell.setSize(865, 555);
        this.shell.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"PublicPresentationWindow");
        GridData mgd = new GridData();
        mgd.horizontalAlignment = 4;
        mgd.verticalAlignment = 4;
        mgd.grabExcessHorizontalSpace = true;
        mgd.grabExcessVerticalSpace = true;
        Group mainForm = new Group((Composite)this.shell, 0);
        mainForm.setLayoutData((Object)mgd);
        mainForm.setLayout((Layout)new GridLayout(2, false));
        TabFolder tabs = new TabFolder((Composite)this.shell, 0x800000);
        tabs.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"Tabs");
        GridData tgd = new GridData();
        tgd.heightHint = 130;
        tgd.horizontalAlignment = 4;
        tgd.grabExcessHorizontalSpace = true;
        tabs.setLayoutData((Object)tgd);
        Composite leftColumn = new Composite((Composite)mainForm, 0);
        leftColumn.setLayout((Layout)new GridLayout(1, false));
        GridData lcgd = new GridData();
        lcgd.horizontalAlignment = 4;
        lcgd.grabExcessHorizontalSpace = true;
        lcgd.verticalAlignment = 1;
        leftColumn.setLayoutData((Object)lcgd);
        Composite rightColumn = new Composite((Composite)mainForm, 0);
        rightColumn.setLayout((Layout)new GridLayout(1, false));
        GridData rightColumnGridData = new GridData();
        rightColumnGridData.horizontalAlignment = 4;
        rightColumnGridData.grabExcessHorizontalSpace = true;
        rightColumnGridData.verticalAlignment = 1;
        rightColumn.setLayoutData((Object)rightColumnGridData);
        Composite timesComposite = new Composite(leftColumn, 0);
        timesComposite.setLayout((Layout)new GridLayout(4, false));
        this.numberLabel = new Label(timesComposite, 8);
        this.numberLabel.setText(Messages.getString("GUIText.PresentationNumberText"));
        this.numberText = new Text(timesComposite, 2060);
        this.numberText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"NumberText");
        Utility.setLength(this.numberText, 10);
        this.numberText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.numberText.setToolTipText(Messages.getString("GUIText.NumberToolTip"));
        Label durationLabel = new Label(timesComposite, 8);
        durationLabel.setText(Messages.getString("GUIText.DurationText"));
        this.durationText = new Text(timesComposite, 2052);
        this.durationText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"DurationText");
        Utility.setLength(this.durationText, 8);
        this.durationText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.durationText.addFocusListener(Utility.checkCorrectIntListener);
        this.durationText.setToolTipText(Messages.getString("GUIText.DurationToolTip"));
        Label beginningDayLabel = new Label(timesComposite, 8);
        beginningDayLabel.setText(Messages.getString("GUIText.BeginningDayText"));
        this.beginningDayCalendar = new CalendarControl(timesComposite, this.titleBarHeight);
        this.beginningDayCalendar.setData("ATOSJ_COMPONENT_NAME_KEY", "BeginningDayCalendar");
        this.beginningDayCalendar.addSWTCalendarlistener(this.inputChangedListener);
        this.beginningDayCalendar.setToolTipText(Messages.getString("GUIText.BeginningDayToolTip"));
        Label endingDayLabel = new Label(timesComposite, 8);
        endingDayLabel.setText(Messages.getString("GUIText.EndingDayText"));
        this.endingDayCalendar = new CalendarControl(timesComposite, this.titleBarHeight);
        this.endingDayCalendar.setData("ATOSJ_COMPONENT_NAME_KEY", "EndingDayCalendar");
        this.endingDayCalendar.addSWTCalendarlistener(this.inputChangedListener);
        this.endingDayCalendar.setToolTipText(Messages.getString("GUIText.EndingDayToolTip"));
        Label startingTimeLabel = new Label(timesComposite, 8);
        startingTimeLabel.setText(Messages.getString("GUIText.StartingTimeText"));
        this.startingTimeSpinner = new TimeControl(timesComposite);
        this.startingTimeSpinner.setData("ATOSJ_COMPONENT_NAME_KEY", "StartingTimeSpinner");
        this.startingTimeSpinner.addTimeChangeListener(this.inputChangedListener);
        this.startingTimeSpinner.setToolTipText(Messages.getString("GUIText.StartingTimeToolTip"));
        Label endingTimeLabel = new Label(timesComposite, 8);
        endingTimeLabel.setText(Messages.getString("GUIText.EndingTimeText"));
        this.endingTimeSpinner = new TimeControl(timesComposite);
        this.endingTimeSpinner.setData("ATOSJ_COMPONENT_NAME_KEY", "EndingTimeSpinner");
        this.endingTimeSpinner.addTimeChangeListener(this.inputChangedListener);
        this.endingTimeSpinner.setToolTipText(Messages.getString("GUIText.EndingTimeToolTip"));
        Label firstStartingTimeLabel = new Label(timesComposite, 8);
        firstStartingTimeLabel.setText(Messages.getString("GUIText.FirstDayStartingTimeText"));
        this.firstStartingTimeSpinner = new TimeControl(timesComposite);
        this.firstStartingTimeSpinner.setData("ATOSJ_COMPONENT_NAME_KEY", "FirstStartingTimeSpinner");
        this.firstStartingTimeSpinner.addTimeChangeListener(this.inputChangedListener);
        this.firstStartingTimeSpinner.setToolTipText(Messages.getString("GUIText.FirstDayStartingTimeToolTip"));
        Label lastEndingTimeLabel = new Label(timesComposite, 8);
        lastEndingTimeLabel.setText(Messages.getString("GUIText.LastDayEndingTimeText"));
        this.lastEndingTimeSpinner = new TimeControl(timesComposite);
        this.lastEndingTimeSpinner.setData("ATOSJ_COMPONENT_NAME_KEY", "LastEndingTimeSpinner");
        this.lastEndingTimeSpinner.addTimeChangeListener(this.inputChangedListener);
        this.lastEndingTimeSpinner.setToolTipText(Messages.getString("GUIText.LastDayEndingTimeToolTip"));
        Label locationLabel = new Label(timesComposite, 8);
        locationLabel.setText(Messages.getString("GUIText.LocationText"));
        this.locationText = new Text(timesComposite, 2052);
        this.locationText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"LocationText");
        this.locationText.addModifyListener((ModifyListener)this.inputChangedListener);
        GridData locGrid = new GridData();
        locGrid.horizontalSpan = 3;
        this.locationText.setLayoutData((Object)locGrid);
        Utility.setLength(this.locationText, 50);
        this.locationText.setToolTipText(Messages.getString("GUIText.LocationToolTip"));
        Group addressField = new Group(leftColumn, 0);
        addressField.setText(Messages.getString("GUIText.PresentationAddressFieldText"));
        addressField.setLayout((Layout)new GridLayout(2, false));
        GridData addressFieldGridData = new GridData();
        addressFieldGridData.horizontalAlignment = 4;
        addressFieldGridData.grabExcessHorizontalSpace = true;
        addressField.setLayoutData((Object)addressFieldGridData);
        Label streetLabel = new Label((Composite)addressField, 8);
        streetLabel.setText(Messages.getString("GUIText.StreetText"));
        Utility.alignRight((Control)streetLabel);
        this.streetText = new Text((Composite)addressField, 2052);
        this.streetText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"StreetText");
        Utility.setLength(this.streetText, 50);
        this.streetText.setToolTipText(Messages.getString("GUIText.StreetToolTip"));
        this.streetText.addModifyListener((ModifyListener)this.inputChangedListener);
        Label cityLabel = new Label((Composite)addressField, 8);
        cityLabel.setText(Messages.getString("GUIText.CityZipCodeText"));
        Utility.alignRight((Control)cityLabel);
        Composite cityRowCompletion = new Composite((Composite)addressField, 0);
        GridLayout rcgl = new GridLayout(3, false);
        rcgl.marginWidth = 0;
        rcgl.marginHeight = 0;
        cityRowCompletion.setLayout((Layout)rcgl);
        this.zipCodeText = new Text(cityRowCompletion, 2052);
        this.zipCodeText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"ZipCodeText");
        Utility.setLength(this.zipCodeText, 5);
        this.zipCodeText.setToolTipText(Messages.getString("GUIText.ZipCodeToolTip"));
        this.zipCodeText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.cityText = new Text(cityRowCompletion, 2052);
        this.cityText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"CityText");
        Utility.setLength(this.cityText, 30);
        this.cityText.setToolTipText(Messages.getString("GUIText.CityToolTip"));
        this.cityText.addModifyListener((ModifyListener)this.inputChangedListener);
        Label countryLabel = new Label((Composite)addressField, 8);
        countryLabel.setText(Messages.getString("GUIText.CountryText"));
        Utility.alignRight((Control)countryLabel);
        Composite countryRowCompletion = new Composite((Composite)addressField, 0);
        countryRowCompletion.setLayout((Layout)rcgl);
        this.countryCombo = new Combo(countryRowCompletion, 2052);
        this.countryCombo.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"CountryCombo");
        Enumeration.addCountryEnums(this.countryCombo);
        Utility.setLength(this.countryCombo, 13);
        this.countryCombo.addModifyListener((ModifyListener)this.inputChangedListener);
        this.countryCombo.setToolTipText(Messages.getString("GUIText.CountryToolTip"));
        Label annexLabel = new Label(countryRowCompletion, 8);
        annexLabel.setText(Messages.getString("GUIText.AnnexText"));
        this.annexCombo = new Combo(countryRowCompletion, 2052);
        this.annexCombo.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"AnnexCombo");
        Enumeration.addAnnexEnums(this.annexCombo);
        Utility.setLength(this.annexCombo, 13);
        this.annexCombo.setToolTipText(Messages.getString("GUIText.AnnexToolTip"));
        this.annexCombo.addModifyListener((ModifyListener)this.inputChangedListener);
        Composite additionalComponents = new Composite(rightColumn, 0);
        additionalComponents.setLayout((Layout)new GridLayout(2, false));
        Group seminarTypeGroup = new Group(additionalComponents, 0);
        GridData seminarTypeGroupGridData = new GridData(768);
        seminarTypeGroupGridData.grabExcessHorizontalSpace = true;
        seminarTypeGroupGridData.horizontalSpan = 2;
        seminarTypeGroup.setLayoutData((Object)seminarTypeGroupGridData);
        seminarTypeGroup.setLayout((Layout)new GridLayout(2, false));
        seminarTypeGroup.setText(Messages.getString("GUIText.PresentationSeminarTypeText"));
        Label seminarTypeLabel = new Label((Composite)seminarTypeGroup, 8);
        GridData seminarTypeLabelGridData = new GridData();
        seminarTypeLabelGridData.widthHint = 100;
        seminarTypeLabel.setLayoutData((Object)seminarTypeLabelGridData);
        seminarTypeLabel.setText(Messages.getString("GUIText.PresentationSeminarTypeText"));
        seminarTypeLabel.setAlignment(131072);
        this.semTypeSelector = new ForeignKeyConstraintSelector((Composite)seminarTypeGroup, 3);
        this.semTypeSelector.setData("ATOSJ_COMPONENT_NAME_KEY", "SemTypeSelector");
        this.semTypeSelector.addModifyListener(this.inputChangedListener);
        this.semTypeSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                try {
                    SeminarType semType = SeminarType.getSeminarTypeFromDB(PublicPresentationWindow.this.semTypeSelector.getSelectedId());
                    if (semType != null && semType.getMinEntrants() != null) {
                        PublicPresentationWindow.this.minSemTypeEntrantsText.setText(semType.getMinEntrants().toString());
                    } else {
                        PublicPresentationWindow.this.minSemTypeEntrantsText.setText("");
                    }
                    if (semType != null && semType.getMaxEntrants() != null) {
                        PublicPresentationWindow.this.maxSemTypeEntrantsText.setText(semType.getMaxEntrants().toString());
                    } else {
                        PublicPresentationWindow.this.maxSemTypeEntrantsText.setText("");
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        });
        Label minSemTypeEntrantsLabel = new Label((Composite)seminarTypeGroup, 8);
        minSemTypeEntrantsLabel.setText(Messages.getString("GUIText.MinEntrantsText"));
        Utility.alignRight((Control)minSemTypeEntrantsLabel);
        this.minSemTypeEntrantsText = new Text((Composite)seminarTypeGroup, 2048);
        Utility.setLength(this.minSemTypeEntrantsText, 5);
        this.minSemTypeEntrantsText.setEnabled(false);
        this.minSemTypeEntrantsText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"MinSemTypeEntrantsText");
        Label maxSemTypeEntrantsLabel = new Label((Composite)seminarTypeGroup, 8);
        maxSemTypeEntrantsLabel.setText(Messages.getString("GUIText.MaxEntrantsText"));
        Utility.alignRight((Control)maxSemTypeEntrantsLabel);
        this.maxSemTypeEntrantsText = new Text((Composite)seminarTypeGroup, 2048);
        Utility.setLength(this.maxSemTypeEntrantsText, 5);
        this.maxSemTypeEntrantsText.setEnabled(false);
        this.maxSemTypeEntrantsText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"MaxSemTypeEntrantsText");
        Label cancelLabel = new Label(additionalComponents, 8);
        cancelLabel.setText(Messages.getString("GUIText.CancelText"));
        this.cancelChecker = new Button(additionalComponents, 32);
        this.cancelChecker.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"CancelChecker");
        this.cancelChecker.addSelectionListener((SelectionListener)this.inputChangedListener);
        this.cancelChecker.setToolTipText(Messages.getString("GUIText.CancelToolTip"));
        Label coopPartnerLabel = new Label(additionalComponents, 8);
        coopPartnerLabel.setText(Messages.getString("GUIText.CoopPartnerText"));
        GridData coopLGrid = new GridData();
        coopLGrid.horizontalSpan = 2;
        coopPartnerLabel.setLayoutData((Object)coopLGrid);
        this.coopPartnerText = new Text(additionalComponents, 2626);
        this.coopPartnerText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"CoopPartnerText");
        this.coopPartnerText.addModifyListener((ModifyListener)this.inputChangedListener);
        GridData coopTGrid = new GridData();
        coopTGrid.horizontalSpan = 2;
        coopTGrid.widthHint = 330;
        coopTGrid.heightHint = 40;
        this.coopPartnerText.setLayoutData((Object)coopTGrid);
        this.coopPartnerText.setToolTipText(Messages.getString("GUIText.CoopPartnerToolTip"));
        Label cancelFeeLabel = new Label(additionalComponents, 8);
        cancelFeeLabel.setText(Messages.getString("GUIText.CancelFeeText"));
        this.cancelFeeText = new Text(additionalComponents, 2052);
        this.cancelFeeText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"CancelFeeText");
        Utility.setLength(this.cancelFeeText, 10);
        this.cancelFeeText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.cancelFeeText.addFocusListener(Utility.checkCorrectFloatListener);
        this.cancelFeeText.setToolTipText(Messages.getString("GUIText.CancelFeeToolTip"));
        Label currentEntrantsLabel = new Label(additionalComponents, 8);
        currentEntrantsLabel.setText(Messages.getString("GUIText.CurrentEntrantsText"));
        Utility.alignRight((Control)currentEntrantsLabel);
        this.currentEntrantsText = new Text(additionalComponents, 2056);
        Utility.setLength(this.currentEntrantsText, 10);
        this.currentEntrantsText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"CurrentEntrantsText");
        this.currentEntrantsText.setToolTipText(Messages.getString("GUIText.CurrentEntrantsToolTip"));
        TabItem supervisorItem = new TabItem(tabs, 0);
        supervisorItem.setText(Messages.getString("GUIText.SupervisorText"));
        this.supervisorControl = new AssociationTabControl((Composite)tabs, 9, this.shell);
        this.supervisorControl.addItemListener(this.inputChangedListener);
        this.supervisorControl.setData("ATOSJ_COMPONENT_NAME_KEY", "SupervisorControl");
        supervisorItem.setControl((Control)this.supervisorControl);
        TabItem instructorItem = new TabItem(tabs, 0);
        instructorItem.setText(Messages.getString("GUIText.InstructorText"));
        this.instructorControl = new AssociationTabControl((Composite)tabs, 8, this.shell);
        this.instructorControl.addItemListener(this.inputChangedListener);
        this.instructorControl.setData("ATOSJ_COMPONENT_NAME_KEY", "InstructorControl");
        instructorItem.setControl((Control)this.instructorControl);
        TabItem bookingItem = new TabItem(tabs, 0);
        bookingItem.setText(Messages.getString("GUIText.ClientBookingsText"));
        this.bookingControl = new AssociationTabControl((Composite)tabs, 12, this.shell);
        this.bookingControl.addItemListener(this.inputChangedListener);
        this.bookingControl.setData("ATOSJ_COMPONENT_NAME_KEY", "BookingControl");
        bookingItem.setControl((Control)this.bookingControl);
        Composite buttons = new Composite((Composite)this.shell, this.shell.getStyle());
        buttons.setLayout((Layout)new GridLayout(11, false));
        this.okButton = new Button(buttons, 8);
        this.okButton.setText(Messages.getString("GUIText.OkButtonText"));
        this.okButton.setLayoutData((Object)new GridData(1040));
        this.applyButton = new Button(buttons, 8);
        this.applyButton.setText(Messages.getString("GUIText.ApplyButtonText"));
        this.applyButton.setLayoutData((Object)new GridData(1040));
        this.newButton = new Button(buttons, 8);
        this.newButton.setText(Messages.getString("GUIText.NewButtonText"));
        this.newButton.setLayoutData((Object)new GridData(1040));
        this.abortButton = new Button(buttons, 8);
        this.abortButton.setText(Messages.getString("GUIText.AbortButtonText"));
        this.abortButton.setLayoutData((Object)new GridData(1040));
        GridData arrowButtonGridData = new GridData();
        arrowButtonGridData.verticalAlignment = 4;
        arrowButtonGridData.grabExcessVerticalSpace = true;
        arrowButtonGridData.widthHint = 23;
        this.prevButton = new Button(buttons, 16388);
        this.prevButton.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"Previous");
        this.prevButton.setLayoutData((Object)arrowButtonGridData);
        this.nextButton = new Button(buttons, 131076);
        this.nextButton.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"Next");
        this.nextButton.setLayoutData((Object)arrowButtonGridData);
        Button padding = new Button(buttons, 131076);
        padding.setLayoutData((Object)new GridData(528));
        padding.setVisible(false);
        this.listOfParticipantsButton = new Button(buttons, 8);
        this.listOfParticipantsButton.setText(Messages.getString("GUIText.ListOfParticipantsButtonText"));
        this.listOfParticipantsButton.setLayoutData((Object)new GridData(528));
        this.certificateButton = new Button(buttons, 8);
        this.certificateButton.setText(Messages.getString("GUIText.CertificatesButtonText"));
        this.certificateButton.setLayoutData((Object)new GridData(528));
        this.feeMessageButton = new Button(buttons, 8);
        this.feeMessageButton.setText(Messages.getString("GUIText.FeeMessageButtonText"));
        this.feeMessageButton.setLayoutData((Object)new GridData(528));
        this.cancelationButton = new Button(buttons, 8);
        this.cancelationButton.setText(Messages.getString("GUIText.CancelationButtonText"));
        this.cancelationButton.setLayoutData((Object)new GridData(528));
    }

    public PublicPresentationWindow(Shell parent, PublicPresentation input, AssociationTabControl caller) {
        this(parent);
        this.createButtonListener(caller);
        this.setInput(input);
        this.shell.open();
    }

    public PublicPresentationWindow(Shell parent, PublicPresentation input, ForeignKeyConstraintSelector caller) {
        this(parent);
        this.createButtonListener(caller);
        this.setInput(input);
        this.shell.open();
    }

    private void setInput(PublicPresentation presentation) {
        this.settingInput = true;
        if (this.input != null && this.inputEditingEnabled) {
            PublicPresentation.lockedIds.remove(new Integer(this.input.getId()));
        }
        if (presentation != null) {
            this.numberLabel.setEnabled(true);
            this.numberText.setText(new Integer(presentation.getId()).toString());
            this.durationText.setFocus();
            if (presentation.getDuration() != null) {
                this.durationText.setText(presentation.getDuration().toString());
            } else {
                this.durationText.setText("");
            }
            if (presentation.getBeginningDay() != null) {
                this.beginningDayCalendar.setDate(presentation.getBeginningDay());
            } else {
                this.beginningDayCalendar.setDate(null);
            }
            if (presentation.getEndingDay() != null) {
                this.endingDayCalendar.setDate(presentation.getEndingDay());
            } else {
                this.endingDayCalendar.setDate(null);
            }
            this.startingTimeSpinner.setTime(presentation.getStartingTime());
            this.endingTimeSpinner.setTime(presentation.getEndingTime());
            this.firstStartingTimeSpinner.setTime(presentation.getFirstStartingTime());
            this.lastEndingTimeSpinner.setTime(presentation.getLastEndingTime());
            this.locationText.setText(presentation.getLocation());
            this.streetText.setText(presentation.getStreet());
            this.zipCodeText.setText(presentation.getZipCode());
            this.cityText.setText(presentation.getCity());
            this.countryCombo.setText(presentation.getCountry());
            this.annexCombo.setText(presentation.getAnnex());
            this.cancelChecker.setSelection(presentation.isCancelled());
            this.semTypeSelector.setSelectedId(presentation.getSeminarTypeId());
            this.coopPartnerText.setText(presentation.getCoopPartner());
            if (presentation.getCancelFee() != null) {
                this.cancelFeeText.setText(Utility.createFloatText(presentation.getCancelFee()));
            } else {
                this.cancelFeeText.setText("");
            }
            try {
                SeminarType semType = SeminarType.getSeminarTypeFromDB(presentation.getSeminarTypeId());
                if (semType.getMinEntrants() != null) {
                    this.minSemTypeEntrantsText.setText(semType.getMinEntrants().toString());
                } else {
                    this.minSemTypeEntrantsText.setText("");
                }
                if (semType.getMaxEntrants() != null) {
                    this.maxSemTypeEntrantsText.setText(semType.getMaxEntrants().toString());
                } else {
                    this.maxSemTypeEntrantsText.setText("");
                }
                this.currentEntrantsText.setText("" + presentation.getCurrentEntrantsCount());
            }
            catch (SQLException semType) {
                // empty catch block
            }
            try {
                this.supervisorControl.setInput(presentation.getId());
                this.instructorControl.setInput(presentation.getId());
                this.bookingControl.setInput(presentation.getId());
            }
            catch (SQLException semType) {}
        } else {
            this.numberLabel.setEnabled(false);
            this.numberText.setText("");
            this.durationText.setText("");
            this.durationText.setFocus();
            this.beginningDayCalendar.setDate(null);
            this.endingDayCalendar.setDate(null);
            this.startingTimeSpinner.setTime(null);
            this.endingTimeSpinner.setTime(null);
            this.firstStartingTimeSpinner.setTime(null);
            this.lastEndingTimeSpinner.setTime(null);
            this.locationText.setText("");
            this.streetText.setText("");
            this.zipCodeText.setText("");
            this.cityText.setText("");
            this.countryCombo.setText("");
            this.annexCombo.setText("");
            this.cancelChecker.setSelection(false);
            this.semTypeSelector.setSelectedId(0);
            this.coopPartnerText.setText("");
            try {
                this.supervisorControl.setInput(0);
                this.instructorControl.setInput(0);
                this.bookingControl.setInput(0);
            }
            catch (SQLException semType) {
                // empty catch block
            }
            this.cancelFeeText.setText("");
            this.currentEntrantsText.setText("");
            this.minSemTypeEntrantsText.setText("");
            this.maxSemTypeEntrantsText.setText("");
        }
        if (presentation != null) {
            boolean alreadyEditing = PublicPresentation.lockedIds.contains(new Integer(presentation.getId()));
            this.setInputComponentsEnabled(!alreadyEditing);
            if (!alreadyEditing) {
                PublicPresentation.lockedIds.add(new Integer(presentation.getId()));
            }
        } else {
            this.setInputComponentsEnabled(true);
        }
        this.input = presentation;
        this.inputChanged = presentation == null;
        this.prevButton.setEnabled(this.input != null);
        this.nextButton.setEnabled(this.input != null);
        String shellText = this.input == null ? Messages.getString("GUIText.NewItemWindowTitleText") : new Integer(this.input.getId()).toString();
        shellText = String.valueOf(shellText) + Messages.getString("GUIText.PublicPresentationWindowTitleText");
        if (this.input == null) {
            shellText = String.valueOf(shellText) + "*";
        }
        this.shell.setText(shellText);
        this.settingInput = false;
    }

    private void setInputComponentsEnabled(boolean enabled) {
        this.numberText.setEnabled(enabled);
        this.durationText.setEnabled(enabled);
        this.beginningDayCalendar.setEnabled(enabled);
        this.endingDayCalendar.setEnabled(enabled);
        this.startingTimeSpinner.setEnabled(enabled);
        this.endingTimeSpinner.setEnabled(enabled);
        this.firstStartingTimeSpinner.setEnabled(enabled);
        this.lastEndingTimeSpinner.setEnabled(enabled);
        this.locationText.setEnabled(enabled);
        this.streetText.setEnabled(enabled);
        this.zipCodeText.setEnabled(enabled);
        this.cityText.setEnabled(enabled);
        this.countryCombo.setEnabled(enabled);
        this.annexCombo.setEnabled(enabled);
        this.semTypeSelector.setEnabled(enabled);
        this.coopPartnerText.setEnabled(enabled);
        this.cancelFeeText.setEnabled(enabled);
        this.cancelChecker.setEnabled(enabled);
        this.supervisorControl.setEnabled(enabled);
        this.instructorControl.setEnabled(enabled);
        this.bookingControl.setEnabled(enabled);
        this.okButton.setEnabled(enabled);
        this.applyButton.setEnabled(enabled);
        this.newButton.setEnabled(enabled);
        this.abortButton.setEnabled(enabled);
        this.prevButton.setEnabled(enabled);
        this.nextButton.setEnabled(enabled);
        this.inputEditingEnabled = enabled;
    }

    private void createButtonListener(final AssociationTabControl caller) {
        if (caller == null) {
            this.okButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (PublicPresentationWindow.this.onSave()) {
                        PublicPresentationWindow.this.shell.close();
                    }
                }
            });
            this.applyButton.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    PublicPresentationWindow.this.onSave();
                }
            });
        } else {
            this.okButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (PublicPresentationWindow.this.onSave()) {
                        caller.addSelectedIds(new SimpleIDKey[]{PublicPresentationWindow.this.input}, false);
                        PublicPresentationWindow.this.shell.close();
                    }
                }
            });
            this.applyButton.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    if (PublicPresentationWindow.this.onSave()) {
                        caller.addSelectedIds(new SimpleIDKey[]{PublicPresentationWindow.this.input}, false);
                    }
                }
            });
        }
        this.newButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (PublicPresentationWindow.this.onSave()) {
                    PublicPresentationWindow.this.setInput(null);
                }
            }
        });
        this.abortButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                PublicPresentationWindow.this.shell.close();
            }
        });
        this.prevButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (PublicPresentationWindow.this.inputChanged) {
                    if (PublicPresentationWindow.this.confirmClose()) {
                        PublicPresentationWindow.this.setInput(PublicPresentation.getPrevious(PublicPresentationWindow.this.input.getId()));
                    }
                } else {
                    PublicPresentationWindow.this.setInput(PublicPresentation.getPrevious(PublicPresentationWindow.this.input.getId()));
                }
            }
        });
        this.nextButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (PublicPresentationWindow.this.inputChanged) {
                    if (PublicPresentationWindow.this.confirmClose()) {
                        PublicPresentationWindow.this.setInput(PublicPresentation.getNext(PublicPresentationWindow.this.input.getId()));
                    }
                } else {
                    PublicPresentationWindow.this.setInput(PublicPresentation.getNext(PublicPresentationWindow.this.input.getId()));
                }
            }
        });
        this.listOfParticipantsButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                MessageDialog.openInformation((Shell)PublicPresentationWindow.this.shell, (String)Messages.getString("GUIText.NotImplementedMessageDialogWindowTitle"), (String)Messages.getString("GUIText.NotImplementedMessageDialogHintText"));
            }
        });
        this.certificateButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                MessageDialog.openInformation((Shell)PublicPresentationWindow.this.shell, (String)Messages.getString("GUIText.NotImplementedMessageDialogWindowTitle"), (String)Messages.getString("GUIText.NotImplementedMessageDialogHintText"));
            }
        });
        this.feeMessageButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                MessageDialog.openInformation((Shell)PublicPresentationWindow.this.shell, (String)Messages.getString("GUIText.NotImplementedMessageDialogWindowTitle"), (String)Messages.getString("GUIText.NotImplementedMessageDialogHintText"));
            }
        });
        this.cancelationButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                MessageDialog.openInformation((Shell)PublicPresentationWindow.this.shell, (String)Messages.getString("GUIText.NotImplementedMessageDialogWindowTitle"), (String)Messages.getString("GUIText.NotImplementedMessageDialogHintText"));
            }
        });
    }

    private void createButtonListener(final ForeignKeyConstraintSelector caller) {
        if (caller == null) {
            this.okButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (PublicPresentationWindow.this.onSave()) {
                        PublicPresentationWindow.this.shell.close();
                    }
                }
            });
            this.applyButton.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    PublicPresentationWindow.this.onSave();
                }
            });
        } else {
            this.okButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (PublicPresentationWindow.this.onSave()) {
                        caller.setSelectedId(PublicPresentationWindow.this.input.getId());
                        PublicPresentationWindow.this.shell.close();
                    }
                }
            });
            this.applyButton.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    if (PublicPresentationWindow.this.onSave()) {
                        caller.setSelectedId(PublicPresentationWindow.this.input.getId());
                    }
                }
            });
        }
        this.newButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (PublicPresentationWindow.this.onSave()) {
                    PublicPresentationWindow.this.setInput(null);
                }
            }
        });
        this.abortButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                PublicPresentationWindow.this.shell.close();
            }
        });
        this.prevButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (PublicPresentationWindow.this.inputChanged) {
                    if (PublicPresentationWindow.this.confirmClose()) {
                        PublicPresentationWindow.this.setInput(PublicPresentation.getPrevious(PublicPresentationWindow.this.input.getId()));
                    }
                } else {
                    PublicPresentationWindow.this.setInput(PublicPresentation.getPrevious(PublicPresentationWindow.this.input.getId()));
                }
            }
        });
        this.nextButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (PublicPresentationWindow.this.inputChanged) {
                    if (PublicPresentationWindow.this.confirmClose()) {
                        PublicPresentationWindow.this.setInput(PublicPresentation.getNext(PublicPresentationWindow.this.input.getId()));
                    }
                } else {
                    PublicPresentationWindow.this.setInput(PublicPresentation.getNext(PublicPresentationWindow.this.input.getId()));
                }
            }
        });
        this.listOfParticipantsButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                MessageDialog.openInformation((Shell)PublicPresentationWindow.this.shell, (String)Messages.getString("GUIText.NotImplementedMessageDialogWindowTitle"), (String)Messages.getString("GUIText.NotImplementedMessageDialogHintText"));
            }
        });
        this.certificateButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                MessageDialog.openInformation((Shell)PublicPresentationWindow.this.shell, (String)Messages.getString("GUIText.NotImplementedMessageDialogWindowTitle"), (String)Messages.getString("GUIText.NotImplementedMessageDialogHintText"));
            }
        });
        this.feeMessageButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                MessageDialog.openInformation((Shell)PublicPresentationWindow.this.shell, (String)Messages.getString("GUIText.NotImplementedMessageDialogWindowTitle"), (String)Messages.getString("GUIText.NotImplementedMessageDialogHintText"));
            }
        });
        this.cancelationButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                MessageDialog.openInformation((Shell)PublicPresentationWindow.this.shell, (String)Messages.getString("GUIText.NotImplementedMessageDialogWindowTitle"), (String)Messages.getString("GUIText.NotImplementedMessageDialogHintText"));
            }
        });
    }

    protected boolean checkInput() {
        boolean inputOK = true;
        String errorMessage = "";
        if (this.semTypeSelector.getSelectedId() == 0) {
            errorMessage = String.valueOf(errorMessage) + Messages.getString("GUIText.ErrorMessageDialogMandatoryAssociationSeminarType");
            inputOK = false;
        }
        if (!Utility.isCorrectInteger(this.durationText.getText())) {
            errorMessage = String.valueOf(errorMessage) + Messages.getString("GUIText.ErrorMessageDialogIncorrectNumberDuration");
            inputOK = false;
        }
        if (!Utility.isCorrectFloat(this.cancelFeeText.getText())) {
            errorMessage = String.valueOf(errorMessage) + Messages.getString("GUIText.ErrorMessageDialogIncorrectFloatCancelFee");
            inputOK = false;
        }
        if (!inputOK) {
            MessageDialog.openInformation((Shell)this.shell, (String)Messages.getString("GUIText.ErrorMessageDialogMandatoryFieldWindowTitle"), (String)errorMessage);
        }
        return inputOK;
    }

    protected void commitInputToDB() {
        if (this.input == null) {
            PublicPresentation newInput;
            try {
                newInput = new PublicPresentation(0, this.semTypeSelector.getSelectedId(), Utility.parseInteger(this.durationText.getText()), this.beginningDayCalendar.getDate(), this.endingDayCalendar.getDate(), this.startingTimeSpinner.getTime(), this.endingTimeSpinner.getTime(), this.firstStartingTimeSpinner.getTime(), this.lastEndingTimeSpinner.getTime(), this.locationText.getText(), this.streetText.getText(), this.zipCodeText.getText(), this.cityText.getText(), this.countryCombo.getText(), this.annexCombo.getText(), this.cancelChecker.getSelection(), this.coopPartnerText.getText(), Utility.parseFloat(this.cancelFeeText.getText()), new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()));
            }
            catch (SQLException e1) {
                e1.printStackTrace();
                return;
            }
            this.input = newInput;
            try {
                int id = this.input.insertIntoDB();
                this.numberText.setText(new Integer(id).toString());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            this.input.setDuration(Utility.parseInteger(this.durationText.getText()));
            this.input.setBeginningDay(this.beginningDayCalendar.getDate());
            this.input.setEndingDay(this.endingDayCalendar.getDate());
            this.input.setStartingTime(this.startingTimeSpinner.getTime());
            this.input.setEndingTime(this.endingTimeSpinner.getTime());
            this.input.setFirstStartingTime(this.firstStartingTimeSpinner.getTime());
            this.input.setLastEndingTime(this.lastEndingTimeSpinner.getTime());
            this.input.setLocation(this.locationText.getText());
            this.input.setStreet(this.streetText.getText());
            this.input.setZipCode(this.zipCodeText.getText());
            this.input.setCity(this.cityText.getText());
            this.input.setCountry(this.countryCombo.getText());
            this.input.setAnnex(this.annexCombo.getText());
            this.input.setCancelled(this.cancelChecker.getSelection());
            this.input.setSeminarTypeId(this.semTypeSelector.getSelectedId());
            this.input.setCoopPartner(this.coopPartnerText.getText());
            this.input.setCancelFee(Utility.parseFloat(this.cancelFeeText.getText()));
            try {
                this.input.updateDB();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        try {
            this.bookingControl.commitIntoDB(this.input.getId());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            this.instructorControl.commitIntoDB(this.input.getId());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            this.supervisorControl.commitIntoDB(this.input.getId());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        PublicPresentationListWindow.instance.update();
    }

    private boolean confirmClose() {
        MessageDialog dlg = this.input == null ? new MessageDialog(this.shell, Messages.getString("GUIText.SaveNewItemMessageDialogWindowTitle"), null, Messages.getString("GUIText.SaveNewItemMessageDialogQuestionText"), 3, new String[]{Messages.getString("GUIText.SaveNewItemMessageDialogYesButtonText"), Messages.getString("GUIText.SaveNewItemMessageDialogNoButtonText"), Messages.getString("GUIText.SaveNewItemMessageDialogAbortButtonText")}, 0) : new MessageDialog(this.shell, Messages.getString("GUIText.SaveChangesMessageDialogWindowTitle"), null, Messages.getString("GUIText.SaveChangesMessageDialogQuestionText"), 3, new String[]{Messages.getString("GUIText.SaveChangesMessageDialogYesButtonText"), Messages.getString("GUIText.SaveChangesMessageDialogNoButtonText"), Messages.getString("GUIText.SaveChangesMessageDialogAbortButtonText")}, 0);
        switch (dlg.open()) {
            case 0: {
                return this.onSave();
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return true;
    }

    private boolean onSave() {
        if (!this.inputChanged) {
            return true;
        }
        if (this.checkInput()) {
            this.commitInputToDB();
            this.setInput(this.input);
            return true;
        }
        return false;
    }

    class InputChangedListener
    implements ModifyListener,
    SelectionListener,
    CalendarControl.SWTCalendarListener,
    TimeControl.TimeChangeListener,
    ItemListener {
        InputChangedListener() {
        }

        private void inputChanged() {
            if (!PublicPresentationWindow.this.settingInput && !PublicPresentationWindow.this.inputChanged) {
                PublicPresentationWindow.this.inputChanged = true;
                PublicPresentationWindow.this.shell.setText(String.valueOf(PublicPresentationWindow.this.shell.getText()) + "*");
            }
        }

        public void modifyText(ModifyEvent e) {
            this.inputChanged();
        }

        public void widgetSelected(SelectionEvent e) {
            this.inputChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.inputChanged();
        }

        public void dateChanged(CalendarControl.SWTCalendarEvent event) {
            this.inputChanged();
        }

        public void timeChanged() {
            this.inputChanged();
        }

        public void itemChanged() {
            this.inputChanged();
        }
    }
}

