/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui;

import java.sql.SQLException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import semorg.conf.Configuration;
import semorg.gui.AssociateWindow;
import semorg.gui.ClientBookingWindow;
import semorg.gui.ClientWindow;
import semorg.gui.CompanyBookingWindow;
import semorg.gui.CompanyInternalPresentationWindow;
import semorg.gui.CompanyWindow;
import semorg.gui.EnumerationWindow;
import semorg.gui.LecturerWindow;
import semorg.gui.PublicPresentationWindow;
import semorg.gui.SelectLanguageWindow;
import semorg.gui.SeminarTypeWindow;
import semorg.gui.list.AssociateListWindow;
import semorg.gui.list.ClientBookingListWindow;
import semorg.gui.list.ClientListWindow;
import semorg.gui.list.CompanyBookingListWindow;
import semorg.gui.list.CompanyInternalPresentationListWindow;
import semorg.gui.list.CompanyListWindow;
import semorg.gui.list.LecturerListWindow;
import semorg.gui.list.PublicPresentationListWindow;
import semorg.gui.list.SeminarTypeListWindow;
import semorg.gui.util.Messages;
import semorg.sql.access.DBAccess;
import semorg.sql.util.Utility;

public class MainWindow {
    private static MainWindow instance;
    private Shell shell;
    private Display display;
    private Configuration huSemOrgConf;

    public MainWindow(Display disp) {
        instance = this;
        this.huSemOrgConf = new Configuration();
        this.display = disp;
        this.shell = new Shell(this.display, 224);
        this.centerShell();
        this.shell.setText(Messages.getString("GUIText.MainWindowTitleText"));
        this.shell.setBackground(new Color((Device)this.display, 33, 0, 144));
        this.shell.setBackgroundImage(Utility.getImage(this.huSemOrgConf.getProperty("background")));
        this.createMenu();
        this.createListWindows();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        Utility.disposeImages();
        this.display.dispose();
    }

    private void createListWindows() {
        AssociateListWindow.createWindow(this.shell);
        ClientBookingListWindow.createWindow(this.shell);
        ClientListWindow.createWindow(this.shell);
        CompanyBookingListWindow.createWindow(this.shell);
        CompanyInternalPresentationListWindow.createWindow(this.shell);
        CompanyListWindow.createWindow(this.shell);
        LecturerListWindow.createWindow(this.shell);
        PublicPresentationListWindow.createWindow(this.shell);
        SeminarTypeListWindow.createWindow(this.shell);
    }

    private void centerShell() {
        int Width = 792;
        int Height = 594;
        Rectangle pDisplayBounds = this.shell.getDisplay().getBounds();
        int nLeft = (pDisplayBounds.width - Width) / 2;
        int nTop = (pDisplayBounds.height - Height) / 2;
        this.shell.setBounds(nLeft, nTop, Width, Height);
    }

    private void createStatusBar() {
        ToolBar bar = new ToolBar((Composite)this.shell, 2048);
        bar.setBounds(0, this.shell.getSize().y - 64, this.shell.getSize().x, 20);
    }

    private void createMenu() {
        Menu mainMenu = new Menu((Decorations)this.shell, 2);
        mainMenu.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"MainMenu");
        this.shell.setMenuBar(mainMenu);
        MenuItem mainMenuItem = new MenuItem(mainMenu, 64);
        mainMenuItem.setText(Messages.getString("GUIText.MainWindowMenuApplicationText"));
        Menu subMenu = new Menu((Decorations)this.shell, 4);
        mainMenuItem.setMenu(subMenu);
        MenuItem subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuApplicationImportText"));
        subMenuItem.setEnabled(false);
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuApplicationExportText"));
        subMenuItem.setEnabled(false);
        subMenuItem = new MenuItem(subMenu, 2);
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuApplicationGenerateReportText"));
        subMenuItem.setEnabled(false);
        subMenuItem = new MenuItem(subMenu, 2);
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuApplicationExitText"));
        subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.shell.close();
            }
        });
        mainMenuItem = new MenuItem(mainMenu, 64);
        mainMenuItem.setText(Messages.getString("GUIText.MainWindowMenuMasterDataListsText"));
        subMenu = new Menu((Decorations)this.shell, 4);
        mainMenuItem.setMenu(subMenu);
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemAssociateText"));
        subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AssociateListWindow.openList();
            }
        });
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemLecturerText"));
        subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LecturerListWindow.openList();
            }
        });
        subMenuItem = new MenuItem(subMenu, 64);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemCompanyText"));
        subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompanyListWindow.openList();
            }
        });
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemCompanyBookingText"));
        subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompanyBookingListWindow.openList();
            }
        });
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemCompanyInternalPresentationText"));
        subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompanyInternalPresentationListWindow.openList();
            }
        });
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemClientText"));
        subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClientListWindow.openList();
            }
        });
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemClientBookingText"));
        subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClientBookingListWindow.openList();
            }
        });
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemPublicPresentationText"));
        subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PublicPresentationListWindow.openList();
            }
        });
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemSeminarTypeText"));
        subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SeminarTypeListWindow.openList();
            }
        });
        mainMenuItem = new MenuItem(mainMenu, 64);
        mainMenuItem.setText(Messages.getString("GUIText.MainWindowMenuInitialDataAcquisitionText"));
        subMenu = new Menu((Decorations)this.shell, 4);
        mainMenuItem.setMenu(subMenu);
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemAssociateText"));
        subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Runnable newShellOpener = new Runnable(){

                    public void run() {
                        new AssociateWindow(MainWindow.this.shell, null);
                    }
                };
                MainWindow.this.shell.getDisplay().syncExec(newShellOpener);
            }
        });
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemLecturerText"));
        subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Runnable newShellOpener = new Runnable(){

                    public void run() {
                        new LecturerWindow(MainWindow.this.shell, null, null);
                    }
                };
                MainWindow.this.shell.getDisplay().syncExec(newShellOpener);
            }
        });
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemCompanyText"));
        subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Runnable newShellOpener = new Runnable(){

                    public void run() {
                        new CompanyWindow(MainWindow.this.shell, null, null);
                    }
                };
                MainWindow.this.shell.getDisplay().syncExec(newShellOpener);
            }
        });
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemCompanyBookingText"));
        subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Runnable newShellOpener = new Runnable(){

                    public void run() {
                        new CompanyBookingWindow(MainWindow.this.shell, null, null);
                    }
                };
                MainWindow.this.shell.getDisplay().syncExec(newShellOpener);
            }
        });
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemCompanyInternalPresentationText"));
        subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Runnable newShellOpener = new Runnable(){

                    public void run() {
                        new CompanyInternalPresentationWindow(MainWindow.this.shell, null, null);
                    }
                };
                MainWindow.this.shell.getDisplay().syncExec(newShellOpener);
            }
        });
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemClientText"));
        subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Runnable newShellOpener = new Runnable(){

                    public void run() {
                        new ClientWindow(MainWindow.this.shell, null, null);
                    }
                };
                MainWindow.this.shell.getDisplay().syncExec(newShellOpener);
            }
        });
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemClientBookingText"));
        subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Runnable newShellOpener = new Runnable(){

                    public void run() {
                        new ClientBookingWindow(MainWindow.this.shell, null, null);
                    }
                };
                MainWindow.this.shell.getDisplay().syncExec(newShellOpener);
            }
        });
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemPublicPresentationText"));
        subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Runnable newShellOpener = new Runnable(){

                    public void run() {
                        new PublicPresentationWindow(MainWindow.this.shell, null, null);
                    }
                };
                MainWindow.this.shell.getDisplay().syncExec(newShellOpener);
            }
        });
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemSeminarTypeText"));
        subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Runnable newShellOpener = new Runnable(){

                    public void run() {
                        new SeminarTypeWindow(MainWindow.this.shell, null, null);
                    }
                };
                MainWindow.this.shell.getDisplay().syncExec(newShellOpener);
            }
        });
        mainMenuItem = new MenuItem(mainMenu, 64);
        mainMenuItem.setText(Messages.getString("GUIText.MainWindowMenuUseCaseText"));
        subMenu = new Menu((Decorations)this.shell, 4);
        mainMenuItem.setMenu(subMenu);
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemBookSeminarText"));
        subMenuItem.setEnabled(false);
        mainMenuItem = new MenuItem(mainMenu, 64);
        mainMenuItem.setText(Messages.getString("GUIText.MainWindowMenuAdministrationText"));
        subMenu = new Menu((Decorations)this.shell, 4);
        mainMenuItem.setMenu(subMenu);
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemManageEnumerationsText"));
        subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Runnable newShellOpener = new Runnable(){

                    public void run() {
                        new EnumerationWindow(MainWindow.this.shell);
                    }
                };
                MainWindow.this.shell.getDisplay().syncExec(newShellOpener);
            }
        });
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemSelectLanguageText"));
        subMenuItem.setEnabled(true);
        subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Runnable newShellOpener = new Runnable(){

                    public void run() {
                        new SelectLanguageWindow(MainWindow.this.shell);
                    }
                };
                MainWindow.this.shell.getDisplay().syncExec(newShellOpener);
            }
        });
        if (this.huSemOrgConf.getProperty("selectLanguage") != null && this.huSemOrgConf.getProperty("selectLanguage").equals("disabled")) {
            subMenuItem.setEnabled(false);
        }
        mainMenuItem = new MenuItem(mainMenu, 64);
        mainMenuItem.setText(Messages.getString("GUIText.MainWindowMenuHelpText"));
        subMenu = new Menu((Decorations)this.shell, 4);
        mainMenuItem.setMenu(subMenu);
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemContentsText"));
        subMenuItem.setEnabled(false);
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemContextHelpText"));
        subMenuItem.setEnabled(false);
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemAboutHelpText"));
        subMenuItem.setEnabled(false);
        subMenuItem = new MenuItem(subMenu, 2);
        subMenuItem = new MenuItem(subMenu, 8);
        subMenuItem.setText(Messages.getString("GUIText.MainWindowMenuItemInfoText"));
        subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Runnable newShellOpener = new Runnable(){

                    public void run() {
                        MessageDialog.openInformation(null, (String)Messages.getString("GUIText.MainWindowApplicationInformationTitleText"), (String)Messages.getString("GUIText.MainWindowApplicationInformationText"));
                    }
                };
                MainWindow.this.shell.getDisplay().syncExec(newShellOpener);
            }
        });
    }

    public Shell getShell() {
        return this.shell;
    }

    public static MainWindow getInstance() {
        return instance;
    }

    public Configuration getConfiguration() {
        return this.huSemOrgConf;
    }

    public static void main(String[] args) {
        try {
            DBAccess.init();
            Utility.initUtilities();
        }
        catch (ClassNotFoundException e) {
            System.out.println("The MySQL database driver was not found in the classpath.");
            System.exit(1);
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.exit(2);
        }
        new MainWindow(Display.getDefault());
    }
}

