/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui;

import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import semorg.gui.list.LecturerListWindow;
import semorg.gui.util.AssociationTabControl;
import semorg.gui.util.CalendarControl;
import semorg.gui.util.ItemListener;
import semorg.gui.util.Messages;
import semorg.sql.tables.Enumeration;
import semorg.sql.tables.Lecturer;
import semorg.sql.tables.SimpleIDKey;
import semorg.sql.util.Utility;

public class LecturerWindow {
    private Lecturer input;
    private boolean settingInput = false;
    private boolean inputChanged;
    private boolean inputEditingEnabled;
    private InputChangedListener inputChangedListener = new InputChangedListener();
    private Shell shell;
    private int titleBarHeight;
    private final Label numberLabel;
    private final Text numberText;
    private final Combo salutationCombo;
    private final Combo titleCombo;
    private final Text firstNameText;
    private final Text nameText;
    private final Text streetText;
    private final Text zipCodeText;
    private final Text cityText;
    private final Combo countryCombo;
    private final Combo annexCombo;
    private final Text phoneText;
    private final Text mobileText;
    private final Text faxText;
    private final Text emailText;
    private final CalendarControl birthDayCalendar;
    private final CalendarControl firstContactCalendar;
    private final Text bioText;
    private final Text dailyFeeText;
    private final Text hourlyFeeText;
    private final Text shortMessageText;
    private final Text memoText;
    private AssociationTabControl supervisorControl;
    private AssociationTabControl instructorControl;
    private AssociationTabControl conductControl;
    private final Button okButton;
    private final Button applyButton;
    private final Button newButton;
    private final Button abortButton;
    private final Button prevButton;
    private final Button nextButton;
    private final Button addressLabelButton;

    private LecturerWindow(Shell parent, AssociationTabControl caller) {
        this.shell = new Shell(parent, 64);
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                if (LecturerWindow.this.inputChanged) {
                    if (LecturerWindow.this.confirmClose()) {
                        if (LecturerWindow.this.inputEditingEnabled && LecturerWindow.this.input != null) {
                            Lecturer.lockedIds.remove(new Integer(LecturerWindow.this.input.getId()));
                        }
                    } else {
                        event.doit = false;
                    }
                } else if (LecturerWindow.this.input != null && LecturerWindow.this.inputEditingEnabled) {
                    Lecturer.lockedIds.remove(new Integer(LecturerWindow.this.input.getId()));
                }
            }
        });
        this.shell.setLayout((Layout)new GridLayout(1, false));
        this.shell.setSize(730, 550);
        this.shell.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"LecturerWindow");
        GridData mgd = new GridData();
        mgd.horizontalAlignment = 4;
        mgd.verticalAlignment = 4;
        mgd.grabExcessHorizontalSpace = true;
        mgd.grabExcessVerticalSpace = true;
        Group mainForm = new Group((Composite)this.shell, 0);
        mainForm.setLayoutData((Object)mgd);
        mainForm.setLayout((Layout)new GridLayout(2, false));
        TabFolder tabs = new TabFolder((Composite)this.shell, 0x800000);
        tabs.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"Tabs");
        GridData tgd = new GridData();
        tgd.heightHint = 130;
        tgd.horizontalAlignment = 4;
        tgd.grabExcessHorizontalSpace = true;
        tabs.setLayoutData((Object)tgd);
        Composite leftColumn = new Composite((Composite)mainForm, 0);
        leftColumn.setLayout((Layout)new GridLayout(1, false));
        GridData lcgd = new GridData();
        lcgd.widthHint = 380;
        lcgd.horizontalAlignment = 4;
        lcgd.grabExcessHorizontalSpace = true;
        lcgd.verticalAlignment = 1;
        leftColumn.setLayoutData((Object)lcgd);
        Composite rightColumn = new Composite((Composite)mainForm, 0);
        rightColumn.setLayout((Layout)new GridLayout(1, false));
        GridData rightColumnGridData = new GridData();
        rightColumnGridData.horizontalAlignment = 4;
        rightColumnGridData.grabExcessHorizontalSpace = true;
        rightColumn.setLayoutData((Object)rightColumnGridData);
        Composite numberComp = new Composite(leftColumn, 0);
        GridLayout numGridLayout = new GridLayout(2, false);
        numGridLayout.verticalSpacing = 0;
        numGridLayout.marginTop = 0;
        numGridLayout.marginBottom = 0;
        numberComp.setLayout((Layout)numGridLayout);
        this.numberLabel = new Label(numberComp, 8);
        this.numberLabel.setText(Messages.getString("GUIText.NumberText"));
        this.numberLabel.setAlignment(131072);
        GridData numberLabelGridData = new GridData();
        numberLabelGridData.widthHint = 58;
        this.numberLabel.setLayoutData((Object)numberLabelGridData);
        this.numberText = new Text(numberComp, 2060);
        this.numberText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"NumberText");
        Utility.setLength(this.numberText, 10);
        this.numberText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.numberText.setToolTipText(Messages.getString("GUIText.NumberToolTip"));
        Group nameField = new Group(leftColumn, 0);
        nameField.setText(Messages.getString("GUIText.NameFieldText"));
        GridLayout nameGridLayout = new GridLayout(2, false);
        nameGridLayout.marginTop = 0;
        nameField.setLayout((Layout)nameGridLayout);
        GridData nameFieldGridData = new GridData();
        nameFieldGridData.horizontalAlignment = 4;
        nameFieldGridData.grabExcessHorizontalSpace = true;
        nameField.setLayoutData((Object)nameFieldGridData);
        Group contactField = new Group(rightColumn, 0);
        contactField.setText(Messages.getString("GUIText.ContactFieldText"));
        GridLayout contactGridLayout = new GridLayout(2, false);
        contactGridLayout.marginHeight = 11;
        contactField.setLayout((Layout)contactGridLayout);
        GridData contactFieldGridData = new GridData();
        contactFieldGridData.horizontalAlignment = 4;
        contactFieldGridData.grabExcessHorizontalSpace = true;
        contactField.setLayoutData((Object)contactFieldGridData);
        Label salutationLabel = new Label((Composite)nameField, 8);
        salutationLabel.setText(Messages.getString("GUIText.SalutationText"));
        salutationLabel.setAlignment(131072);
        GridData salutationLabelGridData = new GridData();
        salutationLabelGridData.widthHint = 55;
        salutationLabel.setLayoutData((Object)salutationLabelGridData);
        Composite nameRowCompletion = new Composite((Composite)nameField, 0);
        GridLayout rcgl = new GridLayout(3, false);
        rcgl.marginWidth = 0;
        rcgl.marginHeight = 0;
        nameRowCompletion.setLayout((Layout)rcgl);
        this.salutationCombo = new Combo(nameRowCompletion, 2052);
        Enumeration.addSalutationEnums(this.salutationCombo);
        this.salutationCombo.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"SalutationCombo");
        this.salutationCombo.setBackground(Utility.LIGHT_YELLOW);
        this.salutationCombo.addFocusListener(Utility.checkEmptyListener);
        this.salutationCombo.setTextLimit(13);
        GridData scgd = new GridData();
        scgd.widthHint = 80;
        this.salutationCombo.setLayoutData((Object)scgd);
        this.salutationCombo.setToolTipText(Messages.getString("GUIText.SalutationToolTip"));
        this.salutationCombo.addModifyListener((ModifyListener)this.inputChangedListener);
        Label titleLabel = new Label(nameRowCompletion, 8);
        titleLabel.setText(Messages.getString("GUIText.TitelText"));
        this.titleCombo = new Combo(nameRowCompletion, 2052);
        this.titleCombo.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"TitleCombo");
        Enumeration.addTitleEnums(this.titleCombo);
        Utility.setLength(this.titleCombo, 13);
        this.titleCombo.setToolTipText(Messages.getString("GUIText.TitelToolTip"));
        this.titleCombo.addModifyListener((ModifyListener)this.inputChangedListener);
        Label firstNameLabel = new Label((Composite)nameField, 8);
        firstNameLabel.setText(Messages.getString("GUIText.FirstNameText"));
        Utility.alignRight((Control)firstNameLabel);
        this.firstNameText = new Text((Composite)nameField, 2084);
        this.firstNameText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"FirstNameText");
        Utility.setLength(this.firstNameText, 30);
        this.firstNameText.setToolTipText(Messages.getString("GUIText.FirstNameToolTip"));
        this.firstNameText.addModifyListener((ModifyListener)this.inputChangedListener);
        Label nameLabel = new Label((Composite)nameField, 8);
        nameLabel.setText(Messages.getString("GUIText.LastNameText"));
        Utility.alignRight((Control)nameLabel);
        this.nameText = new Text((Composite)nameField, 2052);
        this.nameText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"NameText");
        Utility.setLength(this.nameText, 30);
        this.nameText.setToolTipText(Messages.getString("GUIText.LastNameToolTip"));
        this.nameText.setBackground(Utility.LIGHT_YELLOW);
        this.nameText.addFocusListener(Utility.checkEmptyListener);
        this.nameText.addModifyListener((ModifyListener)this.inputChangedListener);
        Group addressField = new Group(leftColumn, 0);
        addressField.setText(Messages.getString("GUIText.AdressFieldText"));
        addressField.setLayout((Layout)new GridLayout(2, false));
        GridData addressFieldGridData = new GridData();
        addressFieldGridData.horizontalAlignment = 4;
        addressFieldGridData.grabExcessHorizontalSpace = true;
        addressField.setLayoutData((Object)addressFieldGridData);
        Label streetLabel = new Label((Composite)addressField, 8);
        streetLabel.setText(Messages.getString("GUIText.StreetText"));
        streetLabel.setAlignment(131072);
        GridData streetLabelGridData = new GridData();
        streetLabelGridData.widthHint = 55;
        streetLabel.setLayoutData((Object)streetLabelGridData);
        this.streetText = new Text((Composite)addressField, 2052);
        this.streetText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"StreetText");
        Utility.setLength(this.streetText, 50);
        this.streetText.setToolTipText(Messages.getString("GUIText.StreetToolTip"));
        this.streetText.addModifyListener((ModifyListener)this.inputChangedListener);
        Label cityLabel = new Label((Composite)addressField, 8);
        cityLabel.setText(Messages.getString("GUIText.CityZipCodeText"));
        Utility.alignRight((Control)cityLabel);
        Composite cityRowCompletion = new Composite((Composite)addressField, 0);
        cityRowCompletion.setLayout((Layout)rcgl);
        this.zipCodeText = new Text(cityRowCompletion, 2052);
        this.zipCodeText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"ZipCodeText");
        Utility.setLength(this.zipCodeText, 5);
        this.zipCodeText.setToolTipText(Messages.getString("GUIText.ZipCodeToolTip"));
        this.zipCodeText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.cityText = new Text(cityRowCompletion, 2052);
        this.cityText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"CityText");
        Utility.setLength(this.cityText, 30);
        this.cityText.setToolTipText(Messages.getString("GUIText.CityToolTip"));
        this.cityText.addModifyListener((ModifyListener)this.inputChangedListener);
        Label countryLabel = new Label((Composite)addressField, 8);
        countryLabel.setText(Messages.getString("GUIText.CountryText"));
        Utility.alignRight((Control)countryLabel);
        Composite countryRowCompletion = new Composite((Composite)addressField, 0);
        countryRowCompletion.setLayout((Layout)rcgl);
        this.countryCombo = new Combo(countryRowCompletion, 2052);
        this.countryCombo.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"CountryCombo");
        Enumeration.addCountryEnums(this.countryCombo);
        Utility.setLength(this.countryCombo, 13);
        this.countryCombo.addModifyListener((ModifyListener)this.inputChangedListener);
        this.countryCombo.setToolTipText(Messages.getString("GUIText.CountryToolTip"));
        Label annexLabel = new Label(countryRowCompletion, 8);
        annexLabel.setText(Messages.getString("GUIText.AnnexText"));
        this.annexCombo = new Combo(countryRowCompletion, 2052);
        this.annexCombo.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"AnnexCombo");
        Enumeration.addAnnexEnums(this.annexCombo);
        Utility.setLength(this.annexCombo, 13);
        this.annexCombo.setToolTipText(Messages.getString("GUIText.AnnexToolTip"));
        this.annexCombo.addModifyListener((ModifyListener)this.inputChangedListener);
        Label phoneLabel = new Label((Composite)contactField, 8);
        phoneLabel.setText(Messages.getString("GUIText.PhoneText"));
        phoneLabel.setAlignment(131072);
        GridData phoneLabelGridData = new GridData();
        phoneLabelGridData.widthHint = 100;
        phoneLabel.setLayoutData((Object)phoneLabelGridData);
        this.phoneText = new Text((Composite)contactField, 2052);
        this.phoneText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"PhoneText");
        Utility.setLength(this.phoneText, 20);
        this.phoneText.setToolTipText(Messages.getString("GUIText.PhoneToolTip"));
        this.phoneText.addModifyListener((ModifyListener)this.inputChangedListener);
        Label mobileLabel = new Label((Composite)contactField, 8);
        mobileLabel.setText(Messages.getString("GUIText.MobileText"));
        Utility.alignRight((Control)mobileLabel);
        this.mobileText = new Text((Composite)contactField, 2052);
        this.mobileText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"MobileText");
        Utility.setLength(this.mobileText, 20);
        this.mobileText.setToolTipText(Messages.getString("GUIText.MobileToolTip"));
        this.mobileText.addModifyListener((ModifyListener)this.inputChangedListener);
        Label faxLabel = new Label((Composite)contactField, 8);
        faxLabel.setText(Messages.getString("GUIText.FaxText"));
        Utility.alignRight((Control)faxLabel);
        this.faxText = new Text((Composite)contactField, 2052);
        this.faxText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"FaxText");
        Utility.setLength(this.faxText, 20);
        this.faxText.setToolTipText(Messages.getString("GUIText.FaxToolTip"));
        this.faxText.addModifyListener((ModifyListener)this.inputChangedListener);
        Label emailLabel = new Label((Composite)contactField, 8);
        emailLabel.setText(Messages.getString("GUIText.EmailText"));
        Utility.alignRight((Control)emailLabel);
        this.emailText = new Text((Composite)contactField, 2052);
        this.emailText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"EmailText");
        Utility.setLength(this.emailText, 256, 20);
        this.emailText.setToolTipText(Messages.getString("GUIText.EmailToolTip"));
        this.emailText.addModifyListener((ModifyListener)this.inputChangedListener);
        Composite additionalComponents = new Composite(rightColumn, 0);
        additionalComponents.setLayout((Layout)new GridLayout(2, false));
        Label birthDayLabel = new Label(additionalComponents, 8);
        birthDayLabel.setText(Messages.getString("GUIText.BirthdayText"));
        birthDayLabel.setAlignment(131072);
        GridData birthDayLabelGridData = new GridData();
        birthDayLabelGridData.widthHint = 103;
        birthDayLabel.setLayoutData((Object)birthDayLabelGridData);
        this.birthDayCalendar = new CalendarControl(additionalComponents, this.titleBarHeight);
        this.birthDayCalendar.setData("ATOSJ_COMPONENT_NAME_KEY", "BirthDayCalendar");
        this.birthDayCalendar.addSWTCalendarlistener(this.inputChangedListener);
        this.birthDayCalendar.setToolTipText(Messages.getString("GUIText.BirthdayToolTip"));
        Label firstContactLabel = new Label(additionalComponents, 8);
        firstContactLabel.setText(Messages.getString("GUIText.FirstContactText"));
        Utility.alignRight((Control)firstContactLabel);
        this.firstContactCalendar = new CalendarControl(additionalComponents, this.titleBarHeight);
        this.firstContactCalendar.setData("ATOSJ_COMPONENT_NAME_KEY", "FirstContactCalendar");
        this.firstContactCalendar.addSWTCalendarlistener(this.inputChangedListener);
        this.firstContactCalendar.setToolTipText(Messages.getString("GUIText.FirstContactToolTip"));
        Group feeGroup = new Group(rightColumn, 0);
        feeGroup.setText(Messages.getString("GUIText.LecturerFeeFieldText"));
        feeGroup.setLayout((Layout)new GridLayout(2, false));
        GridData feeGroupGridData = new GridData();
        feeGroupGridData.horizontalAlignment = 4;
        feeGroupGridData.grabExcessHorizontalSpace = true;
        feeGroup.setLayoutData((Object)feeGroupGridData);
        Label dailyFeeLabel = new Label((Composite)feeGroup, 0);
        dailyFeeLabel.setText(Messages.getString("GUIText.LecturerDailyFeeText"));
        Utility.alignRight((Control)dailyFeeLabel);
        this.dailyFeeText = new Text((Composite)feeGroup, 2052);
        this.dailyFeeText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"DailyFeeText");
        Utility.setLength(this.dailyFeeText, 10);
        this.dailyFeeText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.dailyFeeText.addFocusListener(Utility.checkCorrectFloatListener);
        this.dailyFeeText.setToolTipText(Messages.getString("GUIText.LecturerDailyFeeToolTip"));
        Label hourlyFeeLabel = new Label((Composite)feeGroup, 0);
        hourlyFeeLabel.setText(Messages.getString("GUIText.LecturerHourlyFeeText"));
        Utility.alignRight((Control)hourlyFeeLabel);
        this.hourlyFeeText = new Text((Composite)feeGroup, 2052);
        this.hourlyFeeText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"HourlyFeeText");
        Utility.setLength(this.hourlyFeeText, 10);
        this.hourlyFeeText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.hourlyFeeText.addFocusListener(Utility.checkCorrectFloatListener);
        this.hourlyFeeText.setToolTipText(Messages.getString("GUIText.LecturerHourlyFeeToolTip"));
        this.bioText = Utility.createTextTab(tabs, Messages.getString("GUIText.LecturerBiographyText"), null, 400);
        this.bioText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"BioText");
        this.bioText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.shortMessageText = Utility.createTextTab(tabs, Messages.getString("GUIText.ShortMessageText"), null, 200);
        this.shortMessageText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"ShortMessageText");
        this.shortMessageText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.memoText = Utility.createTextTab(tabs, Messages.getString("GUIText.MemoText"), null, 200);
        this.memoText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"MemoText");
        this.memoText.addModifyListener((ModifyListener)this.inputChangedListener);
        TabItem supervisorItem = new TabItem(tabs, 0);
        supervisorItem.setText(Messages.getString("GUIText.SupervisorText"));
        this.supervisorControl = new AssociationTabControl((Composite)tabs, 4, this.shell);
        this.supervisorControl.addItemListener(this.inputChangedListener);
        this.supervisorControl.setData("ATOSJ_COMPONENT_NAME_KEY", "SupervisorControl");
        supervisorItem.setControl((Control)this.supervisorControl);
        TabItem instructorItem = new TabItem(tabs, 0);
        instructorItem.setText(Messages.getString("GUIText.InstructorText"));
        this.instructorControl = new AssociationTabControl((Composite)tabs, 5, this.shell);
        this.instructorControl.addItemListener(this.inputChangedListener);
        this.instructorControl.setData("ATOSJ_COMPONENT_NAME_KEY", "InstructorControl");
        instructorItem.setControl((Control)this.instructorControl);
        TabItem conductItem = new TabItem(tabs, 0);
        conductItem.setText(Messages.getString("GUIText.ConductText"));
        this.conductControl = new AssociationTabControl((Composite)tabs, 6, this.shell);
        this.conductControl.addItemListener(this.inputChangedListener);
        this.conductControl.setData("ATOSJ_COMPONENT_NAME_KEY", "ConductControl");
        conductItem.setControl((Control)this.conductControl);
        Composite buttons = new Composite((Composite)this.shell, this.shell.getStyle());
        buttons.setLayout((Layout)new GridLayout(7, false));
        this.okButton = new Button(buttons, 8);
        this.okButton.setText(Messages.getString("GUIText.OkButtonText"));
        this.okButton.setLayoutData((Object)new GridData(1040));
        this.applyButton = new Button(buttons, 8);
        this.applyButton.setText(Messages.getString("GUIText.ApplyButtonText"));
        this.applyButton.setLayoutData((Object)new GridData(1040));
        this.newButton = new Button(buttons, 8);
        this.newButton.setText(Messages.getString("GUIText.NewButtonText"));
        this.newButton.setLayoutData((Object)new GridData(1040));
        this.abortButton = new Button(buttons, 8);
        this.abortButton.setText(Messages.getString("GUIText.AbortButtonText"));
        this.abortButton.setLayoutData((Object)new GridData(1040));
        GridData arrowButtonGridData = new GridData();
        arrowButtonGridData.verticalAlignment = 4;
        arrowButtonGridData.grabExcessVerticalSpace = true;
        arrowButtonGridData.widthHint = 23;
        this.prevButton = new Button(buttons, 16388);
        this.prevButton.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"Previous");
        this.prevButton.setLayoutData((Object)arrowButtonGridData);
        this.nextButton = new Button(buttons, 131076);
        this.nextButton.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"Next");
        this.nextButton.setLayoutData((Object)arrowButtonGridData);
        this.addressLabelButton = new Button(buttons, 8);
        this.addressLabelButton.setText(Messages.getString("GUIText.AddressButtonText"));
        this.addressLabelButton.setEnabled(true);
        this.addressLabelButton.setLayoutData((Object)new GridData(1040));
        this.createButtonListener(buttons, caller);
    }

    public LecturerWindow(Shell parent, Lecturer input, AssociationTabControl caller) {
        this(parent, caller);
        this.setInput(input);
        this.shell.open();
    }

    private void setInput(Lecturer lecturer) {
        this.settingInput = true;
        if (this.input != null && this.inputEditingEnabled) {
            Lecturer.lockedIds.remove(new Integer(this.input.getId()));
        }
        if (lecturer != null) {
            this.salutationCombo.setFocus();
            this.numberText.setText(new Integer(lecturer.getId()).toString());
            this.numberLabel.setEnabled(true);
            if (lecturer.getSalutation() != null) {
                this.salutationCombo.setText(lecturer.getSalutation());
            } else {
                this.salutationCombo.setText("");
            }
            if (lecturer.getTitle() != null) {
                this.titleCombo.setText(lecturer.getTitle());
            } else {
                this.titleCombo.setText("");
            }
            if (lecturer.getFirstname() != null) {
                this.firstNameText.setText(lecturer.getFirstname());
            } else {
                this.firstNameText.setText("");
            }
            if (lecturer.getName() != null) {
                this.nameText.setText(lecturer.getName());
            } else {
                this.nameText.setText("");
            }
            if (lecturer.getStreet() != null) {
                this.streetText.setText(lecturer.getStreet());
            } else {
                this.streetText.setText("");
            }
            if (lecturer.getZipCode() != null) {
                this.zipCodeText.setText(lecturer.getZipCode());
            } else {
                this.zipCodeText.setText("");
            }
            if (lecturer.getCity() != null) {
                this.cityText.setText(lecturer.getCity());
            } else {
                this.cityText.setText("");
            }
            if (lecturer.getCountry() != null) {
                this.countryCombo.setText(lecturer.getCountry());
            } else {
                this.countryCombo.setText("");
            }
            if (lecturer.getAnnex() != null) {
                this.annexCombo.setText(lecturer.getAnnex());
            } else {
                this.annexCombo.setText("");
            }
            if (lecturer.getPhone() != null) {
                this.phoneText.setText(lecturer.getPhone());
            } else {
                this.phoneText.setText("");
            }
            if (lecturer.getMobile() != null) {
                this.mobileText.setText(lecturer.getMobile());
            } else {
                this.mobileText.setText("");
            }
            if (lecturer.getFax() != null) {
                this.faxText.setText(lecturer.getFax());
            } else {
                this.faxText.setText("");
            }
            if (lecturer.getEmail() != null) {
                this.emailText.setText(lecturer.getEmail());
            } else {
                this.emailText.setText("");
            }
            this.birthDayCalendar.setDate(lecturer.getBirthday());
            this.firstContactCalendar.setDate(lecturer.getFirstContact());
            if (lecturer.getBio() != null) {
                this.bioText.setText(lecturer.getBio());
            } else {
                this.bioText.setText("");
            }
            if (lecturer.getDailyFee() != null) {
                this.dailyFeeText.setText(Utility.createFloatText(lecturer.getDailyFee()));
            } else {
                this.dailyFeeText.setText("");
            }
            if (lecturer.getHourlyFee() != null) {
                this.hourlyFeeText.setText(Utility.createFloatText(lecturer.getHourlyFee()));
            } else {
                this.hourlyFeeText.setText("");
            }
            if (lecturer.getShortinfo() != null) {
                this.shortMessageText.setText(lecturer.getShortinfo());
            } else {
                this.shortMessageText.setText("");
            }
            if (lecturer.getNotices() != null) {
                this.memoText.setText(lecturer.getNotices());
            } else {
                this.memoText.setText("");
            }
            try {
                this.supervisorControl.setInput(lecturer.getId());
                this.instructorControl.setInput(lecturer.getId());
                this.conductControl.setInput(lecturer.getId());
            }
            catch (SQLException sQLException) {}
        } else {
            this.numberLabel.setEnabled(false);
            this.numberText.setEnabled(false);
            this.numberText.setText("");
            this.salutationCombo.setText("");
            this.salutationCombo.setFocus();
            this.titleCombo.setText("");
            this.firstNameText.setText("");
            this.nameText.setText("");
            this.streetText.setText("");
            this.zipCodeText.setText("");
            this.cityText.setText("");
            this.countryCombo.setText("");
            this.annexCombo.setText("");
            this.phoneText.setText("");
            this.mobileText.setText("");
            this.faxText.setText("");
            this.emailText.setText("");
            this.birthDayCalendar.setDate(null);
            this.firstContactCalendar.setDate(null);
            this.bioText.setText("");
            this.dailyFeeText.setText("");
            this.hourlyFeeText.setText("");
            this.shortMessageText.setText("");
            this.memoText.setText("");
            try {
                this.supervisorControl.setInput(0);
                this.instructorControl.setInput(0);
                this.conductControl.setInput(0);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (lecturer != null) {
            boolean alreadyEditing = Lecturer.lockedIds.contains(new Integer(lecturer.getId()));
            this.setInputComponentsEnabled(!alreadyEditing);
            if (!alreadyEditing) {
                Lecturer.lockedIds.add(new Integer(lecturer.getId()));
            }
        } else {
            this.setInputComponentsEnabled(true);
        }
        this.input = lecturer;
        this.inputChanged = lecturer == null;
        this.prevButton.setEnabled(this.input != null);
        this.nextButton.setEnabled(this.input != null);
        String shellText = this.input == null ? Messages.getString("GUIText.NewItemWindowTitleText") : String.valueOf(this.input.getId()) + ", " + this.input.getSalutation() + ", " + this.input.getName() + ", ";
        shellText = String.valueOf(shellText) + Messages.getString("GUIText.LecturerWindowTitleText");
        if (this.input == null) {
            shellText = String.valueOf(shellText) + "*";
        }
        this.shell.setText(shellText);
        this.settingInput = false;
    }

    private void setInputComponentsEnabled(boolean enabled) {
        this.numberText.setEnabled(enabled);
        this.salutationCombo.setEnabled(enabled);
        this.titleCombo.setEnabled(enabled);
        this.firstNameText.setEnabled(enabled);
        this.nameText.setEnabled(enabled);
        this.streetText.setEnabled(enabled);
        this.zipCodeText.setEnabled(enabled);
        this.cityText.setEnabled(enabled);
        this.countryCombo.setEnabled(enabled);
        this.annexCombo.setEnabled(enabled);
        this.phoneText.setEnabled(enabled);
        this.mobileText.setEnabled(enabled);
        this.faxText.setEnabled(enabled);
        this.emailText.setEnabled(enabled);
        this.birthDayCalendar.setEnabled(enabled);
        this.firstContactCalendar.setEnabled(enabled);
        this.bioText.setEnabled(enabled);
        this.dailyFeeText.setEnabled(enabled);
        this.hourlyFeeText.setEnabled(enabled);
        this.shortMessageText.setEnabled(enabled);
        this.memoText.setEnabled(enabled);
        this.supervisorControl.setEnabled(enabled);
        this.instructorControl.setEnabled(enabled);
        this.conductControl.setEnabled(enabled);
        this.okButton.setEnabled(enabled);
        this.applyButton.setEnabled(enabled);
        this.newButton.setEnabled(enabled);
        this.abortButton.setEnabled(enabled);
        this.prevButton.setEnabled(enabled);
        this.nextButton.setEnabled(enabled);
        this.inputEditingEnabled = enabled;
    }

    private void createButtonListener(Composite buttons, final AssociationTabControl caller) {
        if (caller == null) {
            this.okButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (LecturerWindow.this.onSave()) {
                        LecturerWindow.this.shell.close();
                    }
                }
            });
            this.applyButton.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    LecturerWindow.this.onSave();
                }
            });
        } else {
            this.okButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (LecturerWindow.this.onSave()) {
                        caller.addSelectedIds(new SimpleIDKey[]{LecturerWindow.this.input}, false);
                        LecturerWindow.this.shell.close();
                    }
                }
            });
            this.applyButton.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    if (LecturerWindow.this.onSave()) {
                        caller.addSelectedIds(new SimpleIDKey[]{LecturerWindow.this.input}, false);
                    }
                }
            });
        }
        this.newButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (LecturerWindow.this.onSave()) {
                    LecturerWindow.this.setInput(null);
                }
            }
        });
        this.abortButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                LecturerWindow.this.shell.close();
            }
        });
        this.prevButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (LecturerWindow.this.inputChanged) {
                    if (LecturerWindow.this.confirmClose()) {
                        LecturerWindow.this.setInput(Lecturer.getPrevious(LecturerWindow.this.input.getId()));
                    }
                } else {
                    LecturerWindow.this.setInput(Lecturer.getPrevious(LecturerWindow.this.input.getId()));
                }
            }
        });
        this.nextButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (LecturerWindow.this.inputChanged) {
                    if (LecturerWindow.this.confirmClose()) {
                        LecturerWindow.this.setInput(Lecturer.getNext(LecturerWindow.this.input.getId()));
                    }
                } else {
                    LecturerWindow.this.setInput(Lecturer.getNext(LecturerWindow.this.input.getId()));
                }
            }
        });
        this.addressLabelButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                MessageDialog.openInformation((Shell)LecturerWindow.this.shell, (String)Messages.getString("GUIText.NotImplementedMessageDialogWindowTitle"), (String)Messages.getString("GUIText.NotImplementedMessageDialogHintText"));
            }
        });
    }

    protected boolean checkInput() {
        boolean inputOK = true;
        String errorMessage = "";
        if (this.salutationCombo.getText().equals("")) {
            errorMessage = String.valueOf(errorMessage) + Messages.getString("GUIText.ErrorMessageDialogMandatoryFieldSalutationText");
            inputOK = false;
        }
        if (this.nameText.getText().equals("")) {
            errorMessage = String.valueOf(errorMessage) + Messages.getString("GUIText.ErrorMessageDialogMandatoryFieldLastNameText");
            inputOK = false;
        }
        if (!Utility.isCorrectFloat(this.dailyFeeText.getText())) {
            errorMessage = String.valueOf(errorMessage) + Messages.getString("GUIText.ErrorMessageDialogIncorrectFloatDailyFee");
            inputOK = false;
        }
        if (!Utility.isCorrectFloat(this.hourlyFeeText.getText())) {
            errorMessage = String.valueOf(errorMessage) + Messages.getString("GUIText.ErrorMessageDialogIncorrectFloatDailyFee");
            inputOK = false;
        }
        if (!inputOK) {
            MessageDialog.openInformation((Shell)this.shell, (String)Messages.getString("GUIText.ErrorMessageDialogMandatoryFieldWindowTitle"), (String)errorMessage);
        }
        return inputOK;
    }

    protected void commitInputToDB() {
        if (this.input == null) {
            Lecturer newInput;
            this.input = newInput = new Lecturer(0, this.salutationCombo.getText(), this.titleCombo.getText(), this.firstNameText.getText(), this.nameText.getText(), this.streetText.getText(), this.zipCodeText.getText(), this.cityText.getText(), this.countryCombo.getText(), this.annexCombo.getText(), this.phoneText.getText(), this.mobileText.getText(), this.faxText.getText(), this.emailText.getText(), this.birthDayCalendar.getDate(), this.firstContactCalendar.getDate(), this.bioText.getText(), Utility.parseFloat(this.dailyFeeText.getText()), Utility.parseFloat(this.hourlyFeeText.getText()), this.shortMessageText.getText(), this.memoText.getText(), new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()));
            try {
                int id = this.input.insertIntoDB();
                this.numberText.setText(new Integer(id).toString());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            this.input.setSalutation(this.salutationCombo.getText());
            this.input.setTitle(this.titleCombo.getText());
            this.input.setFirstname(this.firstNameText.getText());
            this.input.setName(this.nameText.getText());
            this.input.setStreet(this.streetText.getText());
            this.input.setZipCode(this.zipCodeText.getText());
            this.input.setCity(this.cityText.getText());
            this.input.setCountry(this.countryCombo.getText());
            this.input.setAnnex(this.annexCombo.getText());
            this.input.setPhone(this.phoneText.getText());
            this.input.setMobile(this.mobileText.getText());
            this.input.setFax(this.faxText.getText());
            this.input.setEmail(this.emailText.getText());
            this.input.setBirthday(this.birthDayCalendar.getDate());
            this.input.setFirstContact(this.firstContactCalendar.getDate());
            this.input.setBio(this.bioText.getText());
            this.input.setDailyFee(Utility.parseFloat(this.dailyFeeText.getText()));
            this.input.setHourlyFee(Utility.parseFloat(this.hourlyFeeText.getText()));
            this.input.setShortinfo(this.shortMessageText.getText());
            this.input.setNotices(this.memoText.getText());
            try {
                this.input.updateDB();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        try {
            this.conductControl.commitIntoDB(this.input.getId());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            this.instructorControl.commitIntoDB(this.input.getId());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            this.supervisorControl.commitIntoDB(this.input.getId());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        LecturerListWindow.instance.update();
    }

    private boolean confirmClose() {
        MessageDialog dlg = this.input == null ? new MessageDialog(this.shell, Messages.getString("GUIText.SaveNewItemMessageDialogWindowTitle"), null, Messages.getString("GUIText.SaveNewItemMessageDialogQuestionText"), 3, new String[]{Messages.getString("GUIText.SaveNewItemMessageDialogYesButtonText"), Messages.getString("GUIText.SaveNewItemMessageDialogNoButtonText"), Messages.getString("GUIText.SaveNewItemMessageDialogAbortButtonText")}, 0) : new MessageDialog(this.shell, Messages.getString("GUIText.SaveChangesMessageDialogWindowTitle"), null, Messages.getString("GUIText.SaveChangesMessageDialogQuestionText"), 3, new String[]{Messages.getString("GUIText.SaveChangesMessageDialogYesButtonText"), Messages.getString("GUIText.SaveChangesMessageDialogNoButtonText"), Messages.getString("GUIText.SaveChangesMessageDialogAbortButtonText")}, 0);
        switch (dlg.open()) {
            case 0: {
                return this.onSave();
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return true;
    }

    private boolean onSave() {
        if (!this.inputChanged) {
            return true;
        }
        if (this.checkInput()) {
            this.commitInputToDB();
            this.setInput(this.input);
            return true;
        }
        return false;
    }

    class InputChangedListener
    implements ModifyListener,
    SelectionListener,
    CalendarControl.SWTCalendarListener,
    ItemListener {
        InputChangedListener() {
        }

        private void inputChanged() {
            if (!LecturerWindow.this.settingInput && !LecturerWindow.this.inputChanged) {
                LecturerWindow.this.inputChanged = true;
                LecturerWindow.this.shell.setText(String.valueOf(LecturerWindow.this.shell.getText()) + "*");
            }
        }

        public void modifyText(ModifyEvent e) {
            this.inputChanged();
        }

        public void widgetSelected(SelectionEvent e) {
            this.inputChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.inputChanged();
        }

        public void dateChanged(CalendarControl.SWTCalendarEvent event) {
            this.inputChanged();
        }

        public void itemChanged() {
            this.inputChanged();
        }
    }
}

