/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui;

import java.sql.SQLException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import semorg.gui.provider.EnumDlg;
import semorg.gui.util.Messages;
import semorg.sql.tables.Enumeration;
import semorg.sql.util.DistinctVector;
import semorg.sql.util.Utility;

public class EnumerationWindow {
    private Shell shell;
    private List typeList;
    private ListViewer valueListViewer;

    public EnumerationWindow(Shell parent) {
        this.shell = new Shell(parent, 32864);
        this.shell.setSize(400, 320);
        this.shell.setText(Messages.getString("GUIText.EnumerationWindowTitleText"));
        this.shell.setLayout((Layout)new GridLayout(1, false));
        Composite mainComposite = new Composite((Composite)this.shell, 0);
        mainComposite.setLayoutData((Object)new GridData(768));
        mainComposite.setLayout((Layout)new GridLayout(2, true));
        Group controlGroup = new Group(mainComposite, 0);
        controlGroup.setText(Messages.getString("GUIText.ControlGroupEnumerationText"));
        controlGroup.setLayoutData((Object)new GridData(1808));
        Group enumGroup = new Group(mainComposite, 0);
        enumGroup.setText(Messages.getString("GUIText.EnumerationGroupConstantsText"));
        enumGroup.setLayoutData((Object)new GridData(1808));
        FillLayout controlLayout = new FillLayout();
        controlLayout.marginHeight = 5;
        controlLayout.marginWidth = 5;
        controlGroup.setLayout((Layout)controlLayout);
        this.typeList = new List((Composite)controlGroup, 2560);
        this.typeList.add(Messages.getString("GUIText.TypeListEntrySalutationText"));
        this.typeList.add(Messages.getString("GUIText.TypeListEntryTitleText"));
        this.typeList.add(Messages.getString("GUIText.TypeListEntryCountryText"));
        this.typeList.add(Messages.getString("GUIText.TypeListEntryAnnexText"));
        this.typeList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EnumerationWindow.this.typeList.getSelectionIndex() >= 0) {
                    // empty if block
                }
                try {
                    EnumerationWindow.this.valueListViewer.setInput(Enumeration.getVectorFromDB(EnumerationWindow.this.typeList.getSelectionIndex()));
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        });
        enumGroup.setLayout((Layout)new GridLayout(1, false));
        this.valueListViewer = new ListViewer((Composite)enumGroup, 2560);
        this.valueListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.valueListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Enumeration)element).getValue();
            }
        });
        GridData valueListGridData = new GridData(768);
        valueListGridData.heightHint = 180;
        this.valueListViewer.getList().setLayoutData((Object)valueListGridData);
        this.valueListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent evt) {
                Enumeration value = (Enumeration)((StructuredSelection)EnumerationWindow.this.valueListViewer.getSelection()).getFirstElement();
                EnumerationWindow.this.onEdit(value);
            }
        });
        ToolBar buttonToolBar = new ToolBar((Composite)enumGroup, 0x800000);
        GridData toolBarGridData = new GridData(768);
        toolBarGridData.horizontalAlignment = 2;
        buttonToolBar.setLayoutData((Object)toolBarGridData);
        ToolItem newItem = new ToolItem(buttonToolBar, 8);
        newItem.setImage(Utility.getImage("new.png"));
        newItem.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"NewItem");
        newItem.setToolTipText(Messages.getString("GUIText.AddNewItemButtonToolTip"));
        newItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnumerationWindow.this.onNew();
            }
        });
        ToolItem editItem = new ToolItem(buttonToolBar, 8);
        editItem.setImage(Utility.getImage("edit.png"));
        editItem.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"EditItem");
        editItem.setToolTipText(Messages.getString("GUIText.EditItemButtonToolTip"));
        editItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!EnumerationWindow.this.valueListViewer.getSelection().isEmpty()) {
                    Enumeration value = (Enumeration)((StructuredSelection)EnumerationWindow.this.valueListViewer.getSelection()).getFirstElement();
                    EnumerationWindow.this.onEdit(value);
                }
            }
        });
        ToolItem deleteItem = new ToolItem(buttonToolBar, 8);
        deleteItem.setImage(Utility.getImage("delete.png"));
        deleteItem.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"DeleteItem");
        deleteItem.setToolTipText(Messages.getString("GUIText.EditItemButtonToolTip"));
        deleteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!EnumerationWindow.this.valueListViewer.getSelection().isEmpty()) {
                    Enumeration value = (Enumeration)((StructuredSelection)EnumerationWindow.this.valueListViewer.getSelection()).getFirstElement();
                    EnumerationWindow.this.onDelete(value);
                }
            }
        });
        Button doneButton = new Button((Composite)this.shell, 8);
        GridData doneButtonlayoutData = new GridData();
        doneButtonlayoutData.horizontalIndent = 170;
        doneButton.setLayoutData((Object)doneButtonlayoutData);
        doneButton.setText(Messages.getString("GUIText.DoneButtonText"));
        doneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnumerationWindow.this.shell.close();
            }
        });
        this.shell.open();
    }

    protected void onDelete(Enumeration value) {
        try {
            if (value.removeFromDB()) {
                DistinctVector input = (DistinctVector)this.valueListViewer.getInput();
                input.remove(value);
                this.valueListViewer.refresh();
            } else {
                MessageDialog.openInformation(null, (String)Messages.getString("GUIText.ErrorMessageDialogWindowTitle"), (String)Messages.getString("GUIText.ErrorMessageDialogUndeletableObjectText"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected void onNew() {
        EnumDlg dlg;
        if (this.typeList.getSelectionIndex() >= 0 && (dlg = new EnumDlg(this.shell, null)).open() == 0) {
            String newValue = dlg.getNewValue();
            try {
                Enumeration newEnum = Enumeration.createNewEnumInDB(this.typeList.getSelectionIndex(), newValue);
                DistinctVector input = (DistinctVector)this.valueListViewer.getInput();
                input.add(newEnum);
                this.valueListViewer.refresh();
            }
            catch (SQLException e) {
                MessageDialog.openInformation(null, (String)Messages.getString("GUIText.ErrorMessageDialogWindowTitle"), (String)Messages.getString("GUIText.ErrorMessageDialogUncreatableObjectText"));
            }
        }
    }

    protected void onEdit(Enumeration value) {
        String oldValue = value.getValue();
        EnumDlg dlg = new EnumDlg(this.shell, oldValue);
        if (dlg.open() == 0) {
            String newValue = dlg.getNewValue();
            try {
                value.setValueInDB(newValue);
                this.valueListViewer.refresh();
            }
            catch (SQLException e) {
                MessageDialog.openInformation(null, (String)Messages.getString("GUIText.ErrorMessageDialogWindowTitle"), (String)Messages.getString("GUIText.ErrorMessageDialogUneditableObjectText"));
            }
        }
    }
}

