/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui;

import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import semorg.gui.list.CompanyListWindow;
import semorg.gui.util.AssociationTabControl;
import semorg.gui.util.CalendarControl;
import semorg.gui.util.ForeignKeyConstraintSelector;
import semorg.gui.util.ItemListener;
import semorg.gui.util.Messages;
import semorg.sql.tables.Company;
import semorg.sql.tables.Enumeration;
import semorg.sql.util.Utility;

public class CompanyWindow {
    private Company input;
    private boolean settingInput = false;
    private boolean inputChanged;
    private boolean inputEditingEnabled;
    private InputChangedListener inputChangedListener = new InputChangedListener();
    private Shell shell;
    private int titleBarHeight;
    private final Label numberLabel;
    private final Text numberText;
    private final Text shortNameText;
    private final Combo salutationCombo;
    private final Combo titleCombo;
    private final Text firstNameText;
    private final Text nameText;
    private final Text streetText;
    private final Text zipCodeText;
    private final Text cityText;
    private final Combo countryCombo;
    private final Combo annexCombo;
    private final Text phoneText;
    private final Text mobileText;
    private final Text faxText;
    private final Text emailText;
    private final Combo cpSalutationCombo;
    private final Combo cpTitleCombo;
    private final Text cpFirstNameText;
    private final Text cpNameText;
    private final Text cpPhoneText;
    private final Text cpMobileText;
    private final Text cpFaxText;
    private final Text cpEmailText;
    private final Text cpDepartmentText;
    private final Text cpTaskText;
    private final CalendarControl customerSinceCalendar;
    private final CalendarControl cpBirthDayCalendar;
    private final Text turnoverText;
    private final Text shortMessageText;
    private final Text memoText;
    private AssociationTabControl employeeControl;
    private AssociationTabControl bookingsControl;
    private final Button okButton;
    private final Button applyButton;
    private final Button newButton;
    private final Button abortButton;
    private final Button prevButton;
    private final Button nextButton;

    private CompanyWindow(Shell parent) {
        this.shell = new Shell(parent, 64);
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                if (CompanyWindow.this.inputChanged) {
                    if (CompanyWindow.this.confirmClose()) {
                        if (CompanyWindow.this.inputEditingEnabled && CompanyWindow.this.input != null) {
                            Company.lockedIds.remove(new Integer(CompanyWindow.this.input.getId()));
                        }
                    } else {
                        event.doit = false;
                    }
                } else if (CompanyWindow.this.input != null && CompanyWindow.this.inputEditingEnabled) {
                    Company.lockedIds.remove(new Integer(CompanyWindow.this.input.getId()));
                }
            }
        });
        this.shell.setLayout((Layout)new GridLayout(1, false));
        this.shell.setLayoutData((Object)new GridData(2));
        this.shell.setSize(700, 630);
        this.shell.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"CompanyWindow");
        GridData mgd = new GridData();
        mgd.horizontalAlignment = 4;
        mgd.verticalAlignment = 1;
        mgd.grabExcessHorizontalSpace = true;
        Group mainForm = new Group((Composite)this.shell, 0);
        mainForm.setLayoutData((Object)mgd);
        mainForm.setLayout((Layout)new GridLayout(2, false));
        TabFolder tabs = new TabFolder((Composite)this.shell, 0x800000);
        tabs.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"Tabs");
        GridData tgd = new GridData();
        tgd.horizontalAlignment = 4;
        tgd.verticalAlignment = 1;
        tgd.grabExcessHorizontalSpace = true;
        tabs.setLayoutData((Object)tgd);
        Composite leftColumn = new Composite((Composite)mainForm, 0);
        leftColumn.setLayout((Layout)new GridLayout(1, false));
        GridData lcgd = new GridData();
        lcgd.widthHint = 370;
        lcgd.horizontalAlignment = 4;
        lcgd.grabExcessHorizontalSpace = true;
        lcgd.verticalAlignment = 1;
        leftColumn.setLayoutData((Object)lcgd);
        Composite rightColumn = new Composite((Composite)mainForm, 0);
        rightColumn.setLayout((Layout)new GridLayout(1, false));
        GridData rightColumnGridData = new GridData();
        rightColumnGridData.horizontalAlignment = 4;
        rightColumnGridData.verticalAlignment = 1;
        rightColumnGridData.grabExcessHorizontalSpace = true;
        rightColumn.setLayoutData((Object)rightColumnGridData);
        Composite idComp = new Composite(leftColumn, 0);
        idComp.setLayout((Layout)new GridLayout(2, false));
        this.numberLabel = new Label(idComp, 8);
        this.numberLabel.setText(Messages.getString("GUIText.NumberText"));
        this.numberText = new Text(idComp, 2060);
        this.numberText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"NumberText");
        Utility.setLength(this.numberText, 10);
        this.numberText.addModifyListener((ModifyListener)this.inputChangedListener);
        Label shortNameLabel = new Label(idComp, 8);
        shortNameLabel.setText(Messages.getString("GUIText.CompanyShortName"));
        this.shortNameText = new Text(idComp, 2052);
        this.shortNameText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"ShortNameText");
        this.shortNameText.setBackground(Utility.LIGHT_YELLOW);
        this.shortNameText.addFocusListener(Utility.checkEmptyListener);
        Utility.setLength(this.shortNameText, 10);
        this.shortNameText.addModifyListener((ModifyListener)this.inputChangedListener);
        Group companyNameField = new Group(leftColumn, 0);
        companyNameField.setText(Messages.getString("GUIText.NameFieldText"));
        companyNameField.setLayout((Layout)new GridLayout(2, false));
        GridData nameFieldGridData = new GridData();
        nameFieldGridData.horizontalAlignment = 4;
        nameFieldGridData.grabExcessHorizontalSpace = true;
        companyNameField.setLayoutData((Object)nameFieldGridData);
        Group contactField = new Group(rightColumn, 0);
        contactField.setText(Messages.getString("GUIText.ContactFieldText"));
        contactField.setLayout((Layout)new GridLayout(2, false));
        GridData contactFieldGridData = new GridData();
        contactFieldGridData.horizontalAlignment = 4;
        contactFieldGridData.grabExcessHorizontalSpace = true;
        contactField.setLayoutData((Object)contactFieldGridData);
        TabItem contactPersonTab = new TabItem(tabs, 0);
        contactPersonTab.setText(Messages.getString("GUIText.ContactPersonText"));
        Composite contactPersonTabComposite = new Composite((Composite)tabs, 0);
        contactPersonTab.setControl((Control)contactPersonTabComposite);
        contactPersonTabComposite.setLayout((Layout)new GridLayout(2, false));
        GridData contactPersonTabGridData = new GridData();
        contactPersonTabGridData.verticalAlignment = 1;
        contactPersonTabGridData.horizontalAlignment = 4;
        contactPersonTabGridData.grabExcessHorizontalSpace = true;
        contactPersonTabComposite.setLayoutData((Object)contactPersonTabGridData);
        Composite cpLeftColumn = new Composite(contactPersonTabComposite, 0);
        cpLeftColumn.setLayout((Layout)new GridLayout(1, false));
        GridData cpLeftColumnGridData = new GridData();
        cpLeftColumnGridData.widthHint = 360;
        cpLeftColumnGridData.verticalAlignment = 1;
        cpLeftColumn.setLayoutData((Object)cpLeftColumnGridData);
        Composite cpRightColumn = new Composite(contactPersonTabComposite, 0);
        cpRightColumn.setLayout((Layout)new GridLayout(1, false));
        GridData cpRightColumnGridData = new GridData();
        cpRightColumnGridData.horizontalAlignment = 4;
        cpRightColumnGridData.grabExcessHorizontalSpace = true;
        cpRightColumn.setLayoutData((Object)cpRightColumnGridData);
        Group cpNameField = new Group(cpLeftColumn, 0);
        cpNameField.setText(Messages.getString("GUIText.NameFieldText"));
        cpNameField.setLayout((Layout)new GridLayout(2, false));
        GridData contactNameFieldGridData = new GridData();
        contactNameFieldGridData.horizontalAlignment = 4;
        contactNameFieldGridData.grabExcessHorizontalSpace = true;
        cpNameField.setLayoutData((Object)contactNameFieldGridData);
        Group cpContactField = new Group(cpRightColumn, 0);
        cpContactField.setText(Messages.getString("GUIText.ContactPersonContactText"));
        cpContactField.setLayout((Layout)new GridLayout(2, false));
        GridData cpContactFieldGridData = new GridData();
        cpContactFieldGridData.horizontalAlignment = 4;
        cpContactFieldGridData.grabExcessHorizontalSpace = true;
        cpContactField.setLayoutData((Object)cpContactFieldGridData);
        Composite additionalComponents = new Composite(rightColumn, 0);
        additionalComponents.setLayout((Layout)new GridLayout(2, false));
        Composite cpAdditionalComponents = new Composite(cpRightColumn, 0);
        cpAdditionalComponents.setLayout((Layout)new GridLayout(2, false));
        Label salutationLabel = new Label((Composite)companyNameField, 8);
        Utility.alignRight((Control)salutationLabel);
        salutationLabel.setText(Messages.getString("GUIText.SalutationText"));
        Composite nameRowCompletion = new Composite((Composite)companyNameField, 0);
        GridLayout rcgl = new GridLayout(3, false);
        rcgl.marginWidth = 0;
        rcgl.marginHeight = 0;
        nameRowCompletion.setLayout((Layout)rcgl);
        this.salutationCombo = new Combo(nameRowCompletion, 2052);
        this.salutationCombo.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"SalutationCombo");
        Enumeration.addSalutationEnums(this.salutationCombo);
        this.salutationCombo.setBackground(Utility.LIGHT_YELLOW);
        this.salutationCombo.addFocusListener(Utility.checkEmptyListener);
        this.salutationCombo.setTextLimit(13);
        GridData scgd = new GridData();
        scgd.widthHint = 80;
        this.salutationCombo.setLayoutData((Object)scgd);
        this.salutationCombo.setToolTipText(Messages.getString("GUIText.SalutationToolTip"));
        this.salutationCombo.addModifyListener((ModifyListener)this.inputChangedListener);
        Label titleLabel = new Label(nameRowCompletion, 8);
        titleLabel.setText(Messages.getString("GUIText.TitelText"));
        this.titleCombo = new Combo(nameRowCompletion, 2052);
        this.titleCombo.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"TitleCombo");
        Enumeration.addTitleEnums(this.titleCombo);
        Utility.setLength(this.titleCombo, 13);
        this.titleCombo.setToolTipText(Messages.getString("GUIText.TitelToolTip"));
        this.titleCombo.addModifyListener((ModifyListener)this.inputChangedListener);
        Label firstNameLabel = new Label((Composite)companyNameField, 8);
        firstNameLabel.setText(Messages.getString("GUIText.FirstNameText"));
        Utility.alignRight((Control)firstNameLabel);
        this.firstNameText = new Text((Composite)companyNameField, 2084);
        this.firstNameText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"FirstNameText");
        Utility.setLength(this.firstNameText, 30);
        this.firstNameText.setToolTipText(Messages.getString("GUIText.FirstNameToolTip"));
        this.firstNameText.addModifyListener((ModifyListener)this.inputChangedListener);
        Label nameLabel = new Label((Composite)companyNameField, 8);
        nameLabel.setText(Messages.getString("GUIText.LastNameText"));
        Utility.alignRight((Control)nameLabel);
        this.nameText = new Text((Composite)companyNameField, 2052);
        this.nameText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"NameText");
        Utility.setLength(this.nameText, 30);
        this.nameText.setToolTipText(Messages.getString("GUIText.LastNameToolTip"));
        this.nameText.setBackground(Utility.LIGHT_YELLOW);
        this.nameText.addFocusListener(Utility.checkEmptyListener);
        this.nameText.addModifyListener((ModifyListener)this.inputChangedListener);
        Group addressField = new Group(leftColumn, 0);
        addressField.setText(Messages.getString("GUIText.AdressFieldText"));
        addressField.setLayout((Layout)new GridLayout(2, false));
        GridData addressFieldGridData = new GridData();
        addressFieldGridData.horizontalAlignment = 4;
        addressFieldGridData.grabExcessHorizontalSpace = true;
        addressField.setLayoutData((Object)addressFieldGridData);
        Label streetLabel = new Label((Composite)addressField, 8);
        streetLabel.setText(Messages.getString("GUIText.StreetText"));
        Utility.alignRight((Control)streetLabel);
        this.streetText = new Text((Composite)addressField, 2052);
        this.streetText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"StreetText");
        Utility.setLength(this.streetText, 50);
        this.streetText.setToolTipText(Messages.getString("GUIText.StreetToolTip"));
        this.streetText.addModifyListener((ModifyListener)this.inputChangedListener);
        Label cityLabel = new Label((Composite)addressField, 8);
        cityLabel.setText(Messages.getString("GUIText.CityZipCodeText"));
        Utility.alignRight((Control)cityLabel);
        Composite cityRowCompletion = new Composite((Composite)addressField, 0);
        cityRowCompletion.setLayout((Layout)rcgl);
        this.zipCodeText = new Text(cityRowCompletion, 2052);
        this.zipCodeText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"ZipCodeText");
        Utility.setLength(this.zipCodeText, 5);
        this.zipCodeText.setToolTipText(Messages.getString("GUIText.ZipCodeToolTip"));
        this.zipCodeText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.cityText = new Text(cityRowCompletion, 2052);
        this.cityText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"CityText");
        Utility.setLength(this.cityText, 30);
        this.cityText.setToolTipText(Messages.getString("GUIText.CityToolTip"));
        this.cityText.addModifyListener((ModifyListener)this.inputChangedListener);
        Label countryLabel = new Label((Composite)addressField, 8);
        countryLabel.setText(Messages.getString("GUIText.CountryText"));
        Utility.alignRight((Control)countryLabel);
        Composite countryRowCompletion = new Composite((Composite)addressField, 0);
        countryRowCompletion.setLayout((Layout)rcgl);
        this.countryCombo = new Combo(countryRowCompletion, 2052);
        this.countryCombo.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"CountryCombo");
        Enumeration.addCountryEnums(this.countryCombo);
        Utility.setLength(this.countryCombo, 13);
        this.countryCombo.addModifyListener((ModifyListener)this.inputChangedListener);
        this.countryCombo.setToolTipText(Messages.getString("GUIText.CountryToolTip"));
        Label annexLabel = new Label(countryRowCompletion, 8);
        annexLabel.setText(Messages.getString("GUIText.AnnexText"));
        this.annexCombo = new Combo(countryRowCompletion, 2052);
        this.annexCombo.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"AnnexCombo");
        Enumeration.addAnnexEnums(this.annexCombo);
        Utility.setLength(this.annexCombo, 13);
        this.annexCombo.setToolTipText(Messages.getString("GUIText.AnnexToolTip"));
        this.annexCombo.addModifyListener((ModifyListener)this.inputChangedListener);
        Label phoneLabel = new Label((Composite)contactField, 8);
        phoneLabel.setText(Messages.getString("GUIText.PhoneText"));
        Utility.alignRight((Control)phoneLabel);
        this.phoneText = new Text((Composite)contactField, 2052);
        this.phoneText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"PhoneText");
        Utility.setLength(this.phoneText, 20);
        this.phoneText.setToolTipText(Messages.getString("GUIText.PhoneToolTip"));
        this.phoneText.addModifyListener((ModifyListener)this.inputChangedListener);
        Label mobileLabel = new Label((Composite)contactField, 8);
        mobileLabel.setText(Messages.getString("GUIText.MobileText"));
        Utility.alignRight((Control)mobileLabel);
        this.mobileText = new Text((Composite)contactField, 2052);
        this.mobileText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"MobileText");
        Utility.setLength(this.mobileText, 20);
        this.mobileText.setToolTipText(Messages.getString("GUIText.MobileToolTip"));
        this.mobileText.addModifyListener((ModifyListener)this.inputChangedListener);
        Label faxLabel = new Label((Composite)contactField, 8);
        faxLabel.setText(Messages.getString("GUIText.FaxText"));
        Utility.alignRight((Control)faxLabel);
        this.faxText = new Text((Composite)contactField, 2052);
        this.faxText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"FaxText");
        Utility.setLength(this.faxText, 20);
        this.faxText.setToolTipText(Messages.getString("GUIText.FaxToolTip"));
        this.faxText.addModifyListener((ModifyListener)this.inputChangedListener);
        Label emailLabel = new Label((Composite)contactField, 8);
        emailLabel.setText(Messages.getString("GUIText.EmailText"));
        Utility.alignRight((Control)emailLabel);
        this.emailText = new Text((Composite)contactField, 2052);
        this.emailText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"EmailText");
        Utility.setLength(this.emailText, 256, 25);
        this.emailText.setToolTipText(Messages.getString("GUIText.EmailToolTip"));
        this.emailText.addModifyListener((ModifyListener)this.inputChangedListener);
        Label turnoverLabel = new Label(additionalComponents, 0);
        turnoverLabel.setText(Messages.getString("GUIText.TurnOverText"));
        Utility.alignRight((Control)turnoverLabel);
        this.turnoverText = new Text(additionalComponents, 2052);
        this.turnoverText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"TurnoverText");
        Utility.setLength(this.turnoverText, 10);
        this.turnoverText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.turnoverText.addFocusListener(Utility.checkCorrectFloatListener);
        this.turnoverText.setToolTipText(Messages.getString("GUIText.TurnOverToolTip"));
        Label customerSinceLabel = new Label(additionalComponents, 8);
        customerSinceLabel.setText(Messages.getString("GUIText.CustomerSinceText"));
        Utility.alignRight((Control)customerSinceLabel);
        this.customerSinceCalendar = new CalendarControl(additionalComponents, this.titleBarHeight);
        this.customerSinceCalendar.setData("ATOSJ_COMPONENT_NAME_KEY", "CustomerSinceCalendar");
        this.customerSinceCalendar.addSWTCalendarlistener(this.inputChangedListener);
        this.customerSinceCalendar.setToolTipText(Messages.getString("GUIText.CustomerSinceToolTip"));
        Label cpSalutationLabel = new Label((Composite)cpNameField, 8);
        Utility.alignRight((Control)cpSalutationLabel);
        cpSalutationLabel.setText(Messages.getString("GUIText.SalutationText"));
        Composite contactNameRowCompletion = new Composite((Composite)cpNameField, 0);
        GridLayout cnrcgl = new GridLayout(3, false);
        cnrcgl.marginWidth = 0;
        cnrcgl.marginHeight = 0;
        contactNameRowCompletion.setLayout((Layout)cnrcgl);
        this.cpSalutationCombo = new Combo(contactNameRowCompletion, 2052);
        this.cpSalutationCombo.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"CpSalutationCombo");
        Enumeration.addSalutationEnums(this.cpSalutationCombo);
        this.cpSalutationCombo.setBackground(Utility.LIGHT_YELLOW);
        this.cpSalutationCombo.addFocusListener(Utility.checkEmptyListener);
        this.cpSalutationCombo.setTextLimit(13);
        GridData cscgd = new GridData();
        cscgd.widthHint = 80;
        this.cpSalutationCombo.setLayoutData((Object)scgd);
        this.cpSalutationCombo.setToolTipText(Messages.getString("GUIText.SalutationToolTip"));
        this.cpSalutationCombo.addModifyListener((ModifyListener)this.inputChangedListener);
        Label cpTitleLabel = new Label(contactNameRowCompletion, 8);
        cpTitleLabel.setText(Messages.getString("GUIText.TitelText"));
        this.cpTitleCombo = new Combo(contactNameRowCompletion, 2052);
        this.cpTitleCombo.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"CpTitleCombo");
        Enumeration.addTitleEnums(this.cpTitleCombo);
        Utility.setLength(this.cpTitleCombo, 13);
        this.cpTitleCombo.setToolTipText(Messages.getString("GUIText.TitelToolTip"));
        this.cpTitleCombo.addModifyListener((ModifyListener)this.inputChangedListener);
        Label cpFirstNameLabel = new Label((Composite)cpNameField, 8);
        cpFirstNameLabel.setText(Messages.getString("GUIText.FirstNameText"));
        Utility.alignRight((Control)cpFirstNameLabel);
        this.cpFirstNameText = new Text((Composite)cpNameField, 2084);
        this.cpFirstNameText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"CpFirstNameText");
        Utility.setLength(this.cpFirstNameText, 30);
        this.cpFirstNameText.setToolTipText(Messages.getString("GUIText.FirstNameToolTip"));
        this.cpFirstNameText.addModifyListener((ModifyListener)this.inputChangedListener);
        Label cpNameLabel = new Label((Composite)cpNameField, 8);
        cpNameLabel.setText(Messages.getString("GUIText.LastNameText"));
        Utility.alignRight((Control)cpNameLabel);
        this.cpNameText = new Text((Composite)cpNameField, 2052);
        this.cpNameText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"CpNameText");
        Utility.setLength(this.cpNameText, 30);
        this.cpNameText.setToolTipText(Messages.getString("GUIText.LastNameToolTip"));
        this.cpNameText.setBackground(Utility.LIGHT_YELLOW);
        this.cpNameText.addFocusListener(Utility.checkEmptyListener);
        this.cpNameText.addModifyListener((ModifyListener)this.inputChangedListener);
        Label cpPhoneLabel = new Label((Composite)cpContactField, 8);
        cpPhoneLabel.setText(Messages.getString("GUIText.PhoneText"));
        Utility.alignRight((Control)cpPhoneLabel);
        this.cpPhoneText = new Text((Composite)cpContactField, 2052);
        this.cpPhoneText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"CpPhoneText");
        Utility.setLength(this.cpPhoneText, 20);
        this.cpPhoneText.setToolTipText(Messages.getString("GUIText.PhoneToolTip"));
        this.cpPhoneText.addModifyListener((ModifyListener)this.inputChangedListener);
        Label cpMobileLabel = new Label((Composite)cpContactField, 8);
        cpMobileLabel.setText(Messages.getString("GUIText.MobileText"));
        Utility.alignRight((Control)cpMobileLabel);
        this.cpMobileText = new Text((Composite)cpContactField, 2052);
        this.cpMobileText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"CpMobileText");
        Utility.setLength(this.cpMobileText, 20);
        this.cpMobileText.setToolTipText(Messages.getString("GUIText.MobileToolTip"));
        this.cpMobileText.addModifyListener((ModifyListener)this.inputChangedListener);
        Label cpFaxLabel = new Label((Composite)cpContactField, 8);
        cpFaxLabel.setText(Messages.getString("GUIText.FaxText"));
        Utility.alignRight((Control)cpFaxLabel);
        this.cpFaxText = new Text((Composite)cpContactField, 2052);
        this.cpFaxText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"CpFaxText");
        Utility.setLength(this.cpFaxText, 20);
        this.cpFaxText.setToolTipText(Messages.getString("GUIText.FaxToolTip"));
        this.cpFaxText.addModifyListener((ModifyListener)this.inputChangedListener);
        Label cpEmailLabel = new Label((Composite)cpContactField, 8);
        cpEmailLabel.setText(Messages.getString("GUIText.EmailText"));
        Utility.alignRight((Control)cpEmailLabel);
        this.cpEmailText = new Text((Composite)cpContactField, 2052);
        this.cpEmailText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"CpEmailText");
        Utility.setLength(this.cpEmailText, 256, 25);
        this.cpEmailText.setToolTipText(Messages.getString("GUIText.EmailToolTip"));
        this.cpEmailText.addModifyListener((ModifyListener)this.inputChangedListener);
        Label cpDepartmentLabel = new Label(cpAdditionalComponents, 8);
        cpDepartmentLabel.setText(Messages.getString("GUIText.DepartmentText"));
        Utility.alignRight((Control)cpDepartmentLabel);
        this.cpDepartmentText = new Text(cpAdditionalComponents, 2052);
        this.cpDepartmentText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"CpDepartmentText");
        Utility.setLength(this.cpDepartmentText, 30);
        this.cpDepartmentText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.cpDepartmentText.setToolTipText(Messages.getString("GUIText.DepartmentToolTip"));
        Label cpBirthDayLabel = new Label(cpAdditionalComponents, 8);
        cpBirthDayLabel.setText(Messages.getString("GUIText.BirthdayText"));
        Utility.alignRight((Control)cpBirthDayLabel);
        this.cpBirthDayCalendar = new CalendarControl(cpAdditionalComponents, this.titleBarHeight);
        this.cpBirthDayCalendar.setData("ATOSJ_COMPONENT_NAME_KEY", "CpBirthDayCalendar");
        this.cpBirthDayCalendar.addSWTCalendarlistener(this.inputChangedListener);
        this.cpBirthDayCalendar.setToolTipText(Messages.getString("GUIText.BirthdayToolTip"));
        Label cpTaskLabel = new Label(cpAdditionalComponents, 8);
        cpTaskLabel.setText(Messages.getString("GUIText.TaskText"));
        Utility.alignRight((Control)cpTaskLabel);
        this.cpTaskText = new Text(cpAdditionalComponents, 2052);
        this.cpTaskText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"CpTaskText");
        Utility.setLength(this.cpTaskText, 30);
        this.cpTaskText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.cpTaskText.setToolTipText(Messages.getString("GUIText.TaskToolTip"));
        this.shortMessageText = Utility.createTextTab(tabs, Messages.getString("GUIText.ShortMessageText"), null, 200);
        this.shortMessageText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"ShortMessageText");
        this.shortMessageText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.memoText = Utility.createTextTab(tabs, Messages.getString("GUIText.MemoText"), null, 200);
        this.memoText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"MemoText");
        this.memoText.addModifyListener((ModifyListener)this.inputChangedListener);
        TabItem employeeItem = new TabItem(tabs, 0);
        employeeItem.setText(Messages.getString("GUIText.EmployeeText"));
        this.employeeControl = new AssociationTabControl((Composite)tabs, 1, this.shell);
        this.employeeControl.addItemListener(this.inputChangedListener);
        this.employeeControl.setData("ATOSJ_COMPONENT_NAME_KEY", "EmployeeControl");
        employeeItem.setControl((Control)this.employeeControl);
        TabItem bokingsItem = new TabItem(tabs, 0);
        bokingsItem.setText(Messages.getString("GUIText.CompanyBookingText"));
        this.bookingsControl = new AssociationTabControl((Composite)tabs, 3, this.shell);
        this.bookingsControl.addItemListener(this.inputChangedListener);
        this.bookingsControl.setData("ATOSJ_COMPONENT_NAME_KEY", "BookingsControl");
        bokingsItem.setControl((Control)this.bookingsControl);
        Composite buttons = new Composite((Composite)this.shell, this.shell.getStyle());
        buttons.setLayout((Layout)new GridLayout(7, false));
        this.okButton = new Button(buttons, 8);
        this.okButton.setText(Messages.getString("GUIText.OkButtonText"));
        this.okButton.setLayoutData((Object)new GridData(1040));
        this.applyButton = new Button(buttons, 8);
        this.applyButton.setText(Messages.getString("GUIText.ApplyButtonText"));
        this.applyButton.setLayoutData((Object)new GridData(1040));
        this.newButton = new Button(buttons, 8);
        this.newButton.setText(Messages.getString("GUIText.NewButtonText"));
        this.newButton.setLayoutData((Object)new GridData(1040));
        this.abortButton = new Button(buttons, 8);
        this.abortButton.setText(Messages.getString("GUIText.AbortButtonText"));
        this.abortButton.setLayoutData((Object)new GridData(1040));
        GridData arrowButtonGridData = new GridData();
        arrowButtonGridData.verticalAlignment = 4;
        arrowButtonGridData.grabExcessVerticalSpace = true;
        arrowButtonGridData.widthHint = 23;
        this.prevButton = new Button(buttons, 16388);
        this.prevButton.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"Previous");
        this.prevButton.setLayoutData((Object)arrowButtonGridData);
        this.nextButton = new Button(buttons, 131076);
        this.nextButton.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"Next");
        this.nextButton.setLayoutData((Object)arrowButtonGridData);
    }

    public CompanyWindow(Shell parent, Company input, ForeignKeyConstraintSelector caller) {
        this(parent);
        this.createButtonListener(caller);
        this.setInput(input);
        this.shell.open();
    }

    private void setInput(Company company) {
        this.settingInput = true;
        if (this.input != null && this.inputEditingEnabled) {
            Company.lockedIds.remove(new Integer(this.input.getId()));
        }
        if (company != null) {
            this.numberLabel.setEnabled(true);
            this.numberText.setText(new Integer(company.getId()).toString());
            this.shortNameText.setFocus();
            if (company.getShortName() != null) {
                this.shortNameText.setText(company.getShortName());
            } else {
                this.shortNameText.setText("");
            }
            if (company.getSalutation() != null) {
                this.salutationCombo.setText(company.getSalutation());
            } else {
                this.salutationCombo.setText("");
            }
            if (company.getTitle() != null) {
                this.titleCombo.setText(company.getTitle());
            } else {
                this.titleCombo.setText("");
            }
            if (company.getFirstname() != null) {
                this.firstNameText.setText(company.getFirstname());
            } else {
                this.firstNameText.setText("");
            }
            if (company.getName() != null) {
                this.nameText.setText(company.getName());
            } else {
                this.nameText.setText("");
            }
            if (company.getStreet() != null) {
                this.streetText.setText(company.getStreet());
            } else {
                this.streetText.setText("");
            }
            if (company.getZipCode() != null) {
                this.zipCodeText.setText(company.getZipCode());
            } else {
                this.zipCodeText.setText("");
            }
            if (company.getCity() != null) {
                this.cityText.setText(company.getCity());
            } else {
                this.cityText.setText("");
            }
            if (company.getCountry() != null) {
                this.countryCombo.setText(company.getCountry());
            } else {
                this.countryCombo.setText("");
            }
            if (company.getAnnex() != null) {
                this.annexCombo.setText(company.getAnnex());
            } else {
                this.annexCombo.setText("");
            }
            if (company.getPhone() != null) {
                this.phoneText.setText(company.getPhone());
            } else {
                this.phoneText.setText("");
            }
            if (company.getMobile() != null) {
                this.mobileText.setText(company.getMobile());
            } else {
                this.mobileText.setText("");
            }
            if (company.getFax() != null) {
                this.faxText.setText(company.getFax());
            } else {
                this.faxText.setText("");
            }
            if (company.getEmail() != null) {
                this.emailText.setText(company.getEmail());
            } else {
                this.emailText.setText("");
            }
            if (company.getCpSalutation() != null) {
                this.cpSalutationCombo.setText(company.getCpSalutation());
            } else {
                this.cpSalutationCombo.setText("");
            }
            if (company.getCpTitle() != null) {
                this.cpTitleCombo.setText(company.getCpTitle());
            } else {
                this.cpTitleCombo.setText("");
            }
            if (company.getCpFirstname() != null) {
                this.cpFirstNameText.setText(company.getCpFirstname());
            } else {
                this.cpFirstNameText.setText("");
            }
            if (company.getCpName() != null) {
                this.cpNameText.setText(company.getCpName());
            } else {
                this.cpNameText.setText("");
            }
            if (company.getCpPhone() != null) {
                this.cpPhoneText.setText(company.getCpPhone());
            } else {
                this.cpPhoneText.setText("");
            }
            if (company.getCpMobile() != null) {
                this.cpMobileText.setText(company.getCpMobile());
            } else {
                this.cpMobileText.setText("");
            }
            if (company.getCpFax() != null) {
                this.cpFaxText.setText(company.getCpFax());
            } else {
                this.cpFaxText.setText("");
            }
            if (company.getCpEmail() != null) {
                this.cpEmailText.setText(company.getCpEmail());
            } else {
                this.cpEmailText.setText("");
            }
            if (company.getCpSalutation() != null) {
                this.cpSalutationCombo.setText(company.getCpSalutation());
            } else {
                this.cpSalutationCombo.setText("");
            }
            if (company.getCpDepartment() != null) {
                this.cpDepartmentText.setText(company.getCpDepartment());
            } else {
                this.cpDepartmentText.setText("");
            }
            if (company.getCpTask() != null) {
                this.cpTaskText.setText(company.getCpTask());
            } else {
                this.cpTaskText.setText("");
            }
            this.customerSinceCalendar.setDate(company.getCustomerSince());
            this.cpBirthDayCalendar.setDate(company.getCpBirthDay());
            if (company.getTurnover() != null) {
                this.turnoverText.setText(Utility.createFloatText(company.getTurnover()));
            } else {
                this.turnoverText.setText("");
            }
            if (company.getShortInfo() != null) {
                this.shortMessageText.setText(company.getShortInfo());
            } else {
                this.shortMessageText.setText("");
            }
            if (company.getNotices() != null) {
                this.memoText.setText(company.getNotices());
            } else {
                this.memoText.setText("");
            }
            try {
                this.employeeControl.setInput(company.getId());
                this.bookingsControl.setInput(company.getId());
            }
            catch (SQLException sQLException) {}
        } else {
            this.numberLabel.setEnabled(false);
            this.shortNameText.setFocus();
            this.shortNameText.setText("");
            this.numberText.setText("");
            this.salutationCombo.setText("");
            this.titleCombo.setText("");
            this.firstNameText.setText("");
            this.nameText.setText("");
            this.streetText.setText("");
            this.zipCodeText.setText("");
            this.cityText.setText("");
            this.countryCombo.setText("");
            this.annexCombo.setText("");
            this.phoneText.setText("");
            this.mobileText.setText("");
            this.faxText.setText("");
            this.emailText.setText("");
            this.cpSalutationCombo.setText("");
            this.cpTitleCombo.setText("");
            this.cpFirstNameText.setText("");
            this.cpNameText.setText("");
            this.cpPhoneText.setText("");
            this.cpMobileText.setText("");
            this.cpFaxText.setText("");
            this.cpEmailText.setText("");
            this.cpDepartmentText.setText("");
            this.cpTaskText.setText("");
            this.customerSinceCalendar.setDate(null);
            this.cpBirthDayCalendar.setDate(null);
            this.turnoverText.setText("");
            this.shortMessageText.setText("");
            this.memoText.setText("");
            try {
                this.employeeControl.setInput(0);
                this.bookingsControl.setInput(0);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (company != null) {
            boolean alreadyEditing = Company.lockedIds.contains(new Integer(company.getId()));
            this.setInputComponentsEnabled(!alreadyEditing);
            if (!alreadyEditing) {
                Company.lockedIds.add(new Integer(company.getId()));
            }
        } else {
            this.setInputComponentsEnabled(true);
        }
        this.input = company;
        this.inputChanged = company == null;
        this.prevButton.setEnabled(this.input != null);
        this.nextButton.setEnabled(this.input != null);
        String shellText = this.input == null ? Messages.getString("GUIText.NewItemWindowTitleText") : String.valueOf(this.input.getId()) + ", " + this.input.getSalutation() + ", " + this.input.getName() + ", ";
        shellText = String.valueOf(shellText) + Messages.getString("GUIText.CompanyWindowTitleText");
        if (this.input == null) {
            shellText = String.valueOf(shellText) + "*";
        }
        this.shell.setText(shellText);
        this.settingInput = false;
    }

    private void setInputComponentsEnabled(boolean enabled) {
        this.numberText.setEnabled(enabled);
        this.shortNameText.setEnabled(enabled);
        this.salutationCombo.setEnabled(enabled);
        this.titleCombo.setEnabled(enabled);
        this.firstNameText.setEnabled(enabled);
        this.nameText.setEnabled(enabled);
        this.streetText.setEnabled(enabled);
        this.zipCodeText.setEnabled(enabled);
        this.cityText.setEnabled(enabled);
        this.countryCombo.setEnabled(enabled);
        this.annexCombo.setEnabled(enabled);
        this.phoneText.setEnabled(enabled);
        this.mobileText.setEnabled(enabled);
        this.faxText.setEnabled(enabled);
        this.emailText.setEnabled(enabled);
        this.cpSalutationCombo.setEnabled(enabled);
        this.cpTitleCombo.setEnabled(enabled);
        this.cpFirstNameText.setEnabled(enabled);
        this.cpNameText.setEnabled(enabled);
        this.cpPhoneText.setEnabled(enabled);
        this.cpMobileText.setEnabled(enabled);
        this.cpFaxText.setEnabled(enabled);
        this.cpEmailText.setEnabled(enabled);
        this.cpDepartmentText.setEnabled(enabled);
        this.cpBirthDayCalendar.setEnabled(enabled);
        this.cpTaskText.setEnabled(enabled);
        this.turnoverText.setEnabled(enabled);
        this.customerSinceCalendar.setEnabled(enabled);
        this.shortMessageText.setEnabled(enabled);
        this.memoText.setEnabled(enabled);
        this.employeeControl.setEnabled(enabled);
        this.bookingsControl.setEnabled(enabled);
        this.okButton.setEnabled(enabled);
        this.applyButton.setEnabled(enabled);
        this.newButton.setEnabled(enabled);
        this.abortButton.setEnabled(enabled);
        this.prevButton.setEnabled(enabled);
        this.nextButton.setEnabled(enabled);
        this.inputEditingEnabled = enabled;
    }

    private void createButtonListener(final ForeignKeyConstraintSelector caller) {
        if (caller == null) {
            this.okButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (CompanyWindow.this.onSave()) {
                        CompanyWindow.this.shell.close();
                    }
                }
            });
            this.applyButton.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    CompanyWindow.this.onSave();
                }
            });
        } else {
            this.okButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (CompanyWindow.this.onSave()) {
                        caller.setSelectedId(CompanyWindow.this.input.getId());
                        CompanyWindow.this.shell.close();
                    }
                }
            });
            this.applyButton.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    if (CompanyWindow.this.onSave()) {
                        caller.setSelectedId(CompanyWindow.this.input.getId());
                    }
                }
            });
        }
        this.newButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (CompanyWindow.this.onSave()) {
                    CompanyWindow.this.setInput(null);
                }
            }
        });
        this.abortButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                CompanyWindow.this.shell.close();
            }
        });
        this.prevButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (CompanyWindow.this.inputChanged) {
                    if (CompanyWindow.this.confirmClose()) {
                        CompanyWindow.this.setInput(Company.getPrevious(CompanyWindow.this.input.getId()));
                    }
                } else {
                    CompanyWindow.this.setInput(Company.getPrevious(CompanyWindow.this.input.getId()));
                }
            }
        });
        this.nextButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (CompanyWindow.this.inputChanged) {
                    if (CompanyWindow.this.confirmClose()) {
                        CompanyWindow.this.setInput(Company.getNext(CompanyWindow.this.input.getId()));
                    }
                } else {
                    CompanyWindow.this.setInput(Company.getNext(CompanyWindow.this.input.getId()));
                }
            }
        });
    }

    protected boolean checkInput() {
        boolean inputOK = true;
        String errorMessage = "";
        if (this.shortNameText.getText().trim().length() == 0) {
            errorMessage = String.valueOf(errorMessage);
            inputOK = false;
        }
        if (this.salutationCombo.getText().trim().length() == 0) {
            errorMessage = String.valueOf(errorMessage) + Messages.getString("GUIText.ErrorMessageDialogMandatoryFieldSalutationText");
            inputOK = false;
        }
        if (this.nameText.getText().trim().length() == 0) {
            errorMessage = String.valueOf(errorMessage) + Messages.getString("GUIText.ErrorMessageDialogMandatoryFieldLastNameText");
            inputOK = false;
        }
        if (this.cpSalutationCombo.getText().trim().length() == 0) {
            errorMessage = String.valueOf(errorMessage) + Messages.getString("GUIText.ErrorMessageDialogMandatoryFieldCpSalutationText");
            inputOK = false;
        }
        if (this.cpNameText.getText().trim().length() == 0) {
            errorMessage = String.valueOf(errorMessage) + Messages.getString("GUIText.ErrorMessageDialogMandatoryFieldLastNameText");
            inputOK = false;
        }
        if (!Utility.isCorrectFloat(this.turnoverText.getText())) {
            errorMessage = String.valueOf(errorMessage) + Messages.getString("GUIText.ErrorMessageDialogIncorrectFloatTurnOverText");
            inputOK = false;
        }
        if (!inputOK) {
            MessageDialog.openInformation((Shell)this.shell, (String)Messages.getString("GUIText.ErrorMessageDialogMandatoryFieldWindowTitle"), (String)errorMessage);
        }
        return inputOK;
    }

    protected void commitInputToDB() {
        if (this.input == null) {
            Company newInput;
            this.input = newInput = new Company(0, this.shortNameText.getText(), this.salutationCombo.getText(), this.titleCombo.getText(), this.firstNameText.getText(), this.nameText.getText(), this.streetText.getText(), this.zipCodeText.getText(), this.cityText.getText(), this.countryCombo.getText(), this.annexCombo.getText(), this.phoneText.getText(), this.mobileText.getText(), this.faxText.getText(), this.emailText.getText(), this.cpSalutationCombo.getText(), this.cpTitleCombo.getText(), this.cpFirstNameText.getText(), this.cpNameText.getText(), this.cpPhoneText.getText(), this.cpMobileText.getText(), this.cpFaxText.getText(), this.cpEmailText.getText(), this.cpDepartmentText.getText(), this.cpBirthDayCalendar.getDate(), this.cpTaskText.getText(), this.shortMessageText.getText(), this.memoText.getText(), Utility.parseFloat(this.turnoverText.getText()), this.customerSinceCalendar.getDate(), new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()));
            try {
                int id = this.input.insertIntoDB();
                this.numberText.setText(new Integer(id).toString());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            this.input.setShortName(this.shortNameText.getText());
            this.input.setSalutation(this.salutationCombo.getText());
            this.input.setTitle(this.titleCombo.getText());
            this.input.setFirstname(this.firstNameText.getText());
            this.input.setName(this.nameText.getText());
            this.input.setStreet(this.streetText.getText());
            this.input.setZipCode(this.zipCodeText.getText());
            this.input.setCity(this.cityText.getText());
            this.input.setCountry(this.countryCombo.getText());
            this.input.setAnnex(this.annexCombo.getText());
            this.input.setPhone(this.phoneText.getText());
            this.input.setMobile(this.mobileText.getText());
            this.input.setFax(this.faxText.getText());
            this.input.setEmail(this.emailText.getText());
            this.input.setCpSalutation(this.cpSalutationCombo.getText());
            this.input.setCpTitle(this.cpTitleCombo.getText());
            this.input.setCpFirstname(this.cpFirstNameText.getText());
            this.input.setCpName(this.cpNameText.getText());
            this.input.setCpPhone(this.cpPhoneText.getText());
            this.input.setCpMobile(this.cpMobileText.getText());
            this.input.setCpFax(this.cpFaxText.getText());
            this.input.setCpEmail(this.cpEmailText.getText());
            this.input.setCpDepartment(this.cpDepartmentText.getText());
            this.input.setCpBirthDay(this.cpBirthDayCalendar.getDate());
            this.input.setCpTask(this.cpTaskText.getText());
            this.input.setShortInfo(this.shortMessageText.getText());
            this.input.setNotices(this.memoText.getText());
            this.input.setTurnover(Utility.parseFloat(this.turnoverText.getText()));
            this.input.setCustomerSince(this.customerSinceCalendar.getDate());
            try {
                this.input.updateDB();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        try {
            this.employeeControl.commitIntoDB(this.input.getId());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            this.bookingsControl.commitIntoDB(this.input.getId());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        CompanyListWindow.instance.update();
    }

    private boolean confirmClose() {
        MessageDialog dlg = this.input == null ? new MessageDialog(this.shell, Messages.getString("GUIText.SaveNewItemMessageDialogWindowTitle"), null, Messages.getString("GUIText.SaveNewItemMessageDialogQuestionText"), 3, new String[]{Messages.getString("GUIText.SaveNewItemMessageDialogYesButtonText"), Messages.getString("GUIText.SaveNewItemMessageDialogNoButtonText"), Messages.getString("GUIText.SaveNewItemMessageDialogAbortButtonText")}, 0) : new MessageDialog(this.shell, Messages.getString("GUIText.SaveChangesMessageDialogWindowTitle"), null, Messages.getString("GUIText.SaveChangesMessageDialogQuestionText"), 3, new String[]{Messages.getString("GUIText.SaveChangesMessageDialogYesButtonText"), Messages.getString("GUIText.SaveChangesMessageDialogNoButtonText"), Messages.getString("GUIText.SaveChangesMessageDialogAbortButtonText")}, 0);
        switch (dlg.open()) {
            case 0: {
                return this.onSave();
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return true;
    }

    private boolean onSave() {
        if (!this.inputChanged) {
            return true;
        }
        if (this.checkInput()) {
            this.commitInputToDB();
            this.setInput(this.input);
            return true;
        }
        return false;
    }

    class InputChangedListener
    implements ModifyListener,
    SelectionListener,
    CalendarControl.SWTCalendarListener,
    ItemListener {
        InputChangedListener() {
        }

        private void inputChanged() {
            if (!CompanyWindow.this.settingInput && !CompanyWindow.this.inputChanged) {
                CompanyWindow.this.inputChanged = true;
                CompanyWindow.this.shell.setText(String.valueOf(CompanyWindow.this.shell.getText()) + "*");
            }
        }

        public void modifyText(ModifyEvent e) {
            this.inputChanged();
        }

        public void widgetSelected(SelectionEvent e) {
            this.inputChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.inputChanged();
        }

        public void dateChanged(CalendarControl.SWTCalendarEvent event) {
            this.inputChanged();
        }

        public void itemChanged() {
            this.inputChanged();
        }
    }
}

