/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui;

import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import semorg.gui.list.CompanyBookingListWindow;
import semorg.gui.util.AssociationTabControl;
import semorg.gui.util.CalendarControl;
import semorg.gui.util.ForeignKeyConstraintSelector;
import semorg.gui.util.Messages;
import semorg.sql.tables.CompanyBooking;
import semorg.sql.tables.SimpleIDKey;
import semorg.sql.util.Utility;

public class CompanyBookingWindow {
    private CompanyBooking input;
    private boolean settingInput = false;
    private boolean inputChanged;
    private boolean inputEditingEnabled;
    private InputChangedListener inputChangedListener = new InputChangedListener();
    private Shell shell;
    private int titleBarHeight;
    private final Label numberLabel;
    private final Text numberText;
    private final CalendarControl enrolledCalendar;
    private final CalendarControl confirmedCalendar;
    private final CalendarControl billedCalendar;
    private final CalendarControl signedOffCalendar;
    private final CalendarControl messagedCalendar;
    private final ForeignKeyConstraintSelector companySelector;
    private final ForeignKeyConstraintSelector presentationSelector;
    private final Button okButton;
    private final Button applyButton;
    private final Button newButton;
    private final Button abortButton;
    private final Button prevButton;
    private final Button nextButton;
    private final Button messageButton;
    private final Button billButton;
    private final Button repaymentButton;
    private final Button paymentBehaviorButton;

    private CompanyBookingWindow(Shell parent, AssociationTabControl caller) {
        this.shell = new Shell(parent, 64);
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                if (CompanyBookingWindow.this.inputChanged) {
                    if (CompanyBookingWindow.this.confirmClose()) {
                        if (CompanyBookingWindow.this.inputEditingEnabled && CompanyBookingWindow.this.input != null) {
                            CompanyBooking.lockedIds.remove(new Integer(CompanyBookingWindow.this.input.getId()));
                        }
                    } else {
                        event.doit = false;
                    }
                } else if (CompanyBookingWindow.this.input != null && CompanyBookingWindow.this.inputEditingEnabled) {
                    CompanyBooking.lockedIds.remove(new Integer(CompanyBookingWindow.this.input.getId()));
                }
            }
        });
        this.shell.setLayout((Layout)new GridLayout(1, false));
        this.shell.setSize(425, 415);
        this.shell.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"CompanyBookingWindow");
        GridData mgd = new GridData();
        mgd.horizontalAlignment = 4;
        mgd.verticalAlignment = 4;
        mgd.grabExcessHorizontalSpace = true;
        mgd.grabExcessVerticalSpace = true;
        Group numberField = new Group((Composite)this.shell, 0);
        numberField.setLayout((Layout)new GridLayout(1, false));
        GridData numberFieldGridData = new GridData();
        numberFieldGridData.horizontalAlignment = 2;
        numberFieldGridData.grabExcessHorizontalSpace = true;
        numberFieldGridData.grabExcessVerticalSpace = true;
        numberField.setLayoutData((Object)numberFieldGridData);
        Group dateField = new Group((Composite)this.shell, 0);
        dateField.setLayout((Layout)new GridLayout(2, false));
        GridData dateFieldGridData = new GridData();
        dateFieldGridData.horizontalAlignment = 2;
        dateFieldGridData.grabExcessHorizontalSpace = true;
        dateField.setLayoutData((Object)dateFieldGridData);
        Group connectionField = new Group((Composite)this.shell, 0);
        connectionField.setLayout((Layout)new GridLayout(2, false));
        GridData connectionFieldGridData = new GridData();
        connectionFieldGridData.horizontalAlignment = 4;
        connectionFieldGridData.grabExcessHorizontalSpace = true;
        connectionField.setLayoutData((Object)connectionFieldGridData);
        this.numberLabel = new Label((Composite)numberField, 8);
        this.numberLabel.setText(Messages.getString("GUIText.NumberText"));
        this.numberText = new Text((Composite)numberField, 2060);
        this.numberText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"NumberText");
        Utility.setLength(this.numberText, 10);
        this.numberText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.numberText.setToolTipText(Messages.getString("GUIText.NumberToolTip"));
        Label enrolledLabel = new Label((Composite)dateField, 8);
        enrolledLabel.setText(Messages.getString("GUIText.EnrolledText"));
        Utility.alignRight((Control)enrolledLabel);
        this.enrolledCalendar = new CalendarControl((Composite)dateField, this.titleBarHeight);
        this.enrolledCalendar.setData("ATOSJ_COMPONENT_NAME_KEY", "EnrolledCalendar");
        this.enrolledCalendar.addSWTCalendarlistener(this.inputChangedListener);
        Label confirmedLabel = new Label((Composite)dateField, 8);
        confirmedLabel.setText(Messages.getString("GUIText.ConfirmedText"));
        Utility.alignRight((Control)confirmedLabel);
        this.confirmedCalendar = new CalendarControl((Composite)dateField, this.titleBarHeight);
        this.confirmedCalendar.setData("ATOSJ_COMPONENT_NAME_KEY", "ConfirmedCalendar");
        this.confirmedCalendar.addSWTCalendarlistener(this.inputChangedListener);
        Label billedLabel = new Label((Composite)dateField, 8);
        billedLabel.setText(Messages.getString("GUIText.BilledText"));
        Utility.alignRight((Control)billedLabel);
        this.billedCalendar = new CalendarControl((Composite)dateField, this.titleBarHeight);
        this.billedCalendar.setData("ATOSJ_COMPONENT_NAME_KEY", "BilledCalendar");
        this.billedCalendar.addSWTCalendarlistener(this.inputChangedListener);
        Label signedOffLabel = new Label((Composite)dateField, 8);
        signedOffLabel.setText(Messages.getString("GUIText.SignedOffText"));
        Utility.alignRight((Control)signedOffLabel);
        this.signedOffCalendar = new CalendarControl((Composite)dateField, this.titleBarHeight);
        this.signedOffCalendar.setData("ATOSJ_COMPONENT_NAME_KEY", "SignedOffCalendar");
        this.signedOffCalendar.addSWTCalendarlistener(this.inputChangedListener);
        Label messagedLabel = new Label((Composite)dateField, 8);
        messagedLabel.setText(Messages.getString("GUIText.MessagedText"));
        Utility.alignRight((Control)messagedLabel);
        this.messagedCalendar = new CalendarControl((Composite)dateField, this.titleBarHeight);
        this.messagedCalendar.setData("ATOSJ_COMPONENT_NAME_KEY", "MessagedCalendar");
        this.messagedCalendar.addSWTCalendarlistener(this.inputChangedListener);
        Label companyLabel = new Label((Composite)connectionField, 0);
        companyLabel.setText(Messages.getString("GUIText.CustomerText"));
        Utility.alignRight((Control)companyLabel);
        this.companySelector = new ForeignKeyConstraintSelector((Composite)connectionField, 1);
        this.companySelector.setData("ATOSJ_COMPONENT_NAME_KEY", "CompanySelector");
        this.companySelector.addModifyListener(this.inputChangedListener);
        Label presentationLabel = new Label((Composite)connectionField, 0);
        presentationLabel.setText(Messages.getString("GUIText.CompanyInternalPresentationText"));
        Utility.alignRight((Control)presentationLabel);
        this.presentationSelector = new ForeignKeyConstraintSelector((Composite)connectionField, 4);
        this.presentationSelector.setData("ATOSJ_COMPONENT_NAME_KEY", "PresentationSelector");
        this.presentationSelector.addModifyListener(this.inputChangedListener);
        Composite newButtons = new Composite((Composite)this.shell, this.shell.getStyle());
        GridLayout newButtonsLayout = new GridLayout(7, false);
        newButtonsLayout.marginBottom = 5;
        newButtons.setLayout((Layout)newButtonsLayout);
        GridData newButtonsLayoutData = new GridData();
        newButtonsLayoutData.horizontalAlignment = 2;
        newButtons.setLayoutData((Object)newButtonsLayoutData);
        this.messageButton = new Button(newButtons, 8);
        this.messageButton.setText(Messages.getString("GUIText.MessageButtonText"));
        this.messageButton.setLayoutData((Object)new GridData(528));
        this.billButton = new Button(newButtons, 8);
        this.billButton.setText(Messages.getString("GUIText.BillButtonText"));
        this.billButton.setLayoutData((Object)new GridData(528));
        this.repaymentButton = new Button(newButtons, 8);
        this.repaymentButton.setText(Messages.getString("GUIText.RepaymentButtonText"));
        this.repaymentButton.setLayoutData((Object)new GridData(528));
        this.paymentBehaviorButton = new Button(newButtons, 8);
        this.paymentBehaviorButton.setText(Messages.getString("GUIText.PaymentBehaviorButtonText"));
        this.paymentBehaviorButton.setLayoutData((Object)new GridData(528));
        Composite buttons = new Composite((Composite)this.shell, this.shell.getStyle());
        GridLayout buttonsLayout = new GridLayout(7, false);
        buttons.setLayout((Layout)buttonsLayout);
        GridData buttonsLayoutData = new GridData();
        buttonsLayoutData.horizontalAlignment = 2;
        buttons.setLayoutData((Object)buttonsLayoutData);
        this.okButton = new Button(buttons, 8);
        this.okButton.setText(Messages.getString("GUIText.OkButtonText"));
        this.okButton.setLayoutData((Object)new GridData(1040));
        this.applyButton = new Button(buttons, 8);
        this.applyButton.setText(Messages.getString("GUIText.ApplyButtonText"));
        this.applyButton.setLayoutData((Object)new GridData(1040));
        this.newButton = new Button(buttons, 8);
        this.newButton.setText(Messages.getString("GUIText.NewButtonText"));
        this.newButton.setLayoutData((Object)new GridData(1040));
        this.abortButton = new Button(buttons, 8);
        this.abortButton.setText(Messages.getString("GUIText.AbortButtonText"));
        this.abortButton.setLayoutData((Object)new GridData(1040));
        GridData arrowButtonGridData = new GridData();
        arrowButtonGridData.verticalAlignment = 4;
        arrowButtonGridData.grabExcessVerticalSpace = true;
        arrowButtonGridData.widthHint = 23;
        this.prevButton = new Button(buttons, 16388);
        this.prevButton.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"Previous");
        this.prevButton.setLayoutData((Object)arrowButtonGridData);
        this.nextButton = new Button(buttons, 131076);
        this.nextButton.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"Next");
        this.nextButton.setLayoutData((Object)arrowButtonGridData);
        this.createButtonListener(buttons, caller);
    }

    public CompanyBookingWindow(Shell parent, CompanyBooking input, AssociationTabControl caller) {
        this(parent, caller);
        this.setInput(input);
        this.shell.open();
    }

    private void setInput(CompanyBooking booking) {
        this.settingInput = true;
        this.enrolledCalendar.setFocus();
        if (this.input != null && this.inputEditingEnabled) {
            CompanyBooking.lockedIds.remove(new Integer(this.input.getId()));
        }
        if (booking != null) {
            this.numberLabel.setEnabled(true);
            this.numberText.setText(Integer.toString(booking.getId()));
            this.enrolledCalendar.setDate(booking.getEnrolled());
            this.confirmedCalendar.setDate(booking.getConfirmed());
            this.billedCalendar.setDate(booking.getBilled());
            this.signedOffCalendar.setDate(booking.getSignedOff());
            this.messagedCalendar.setDate(booking.getMessaged());
            this.companySelector.setSelectedId(booking.getCompanyId());
            this.presentationSelector.setSelectedId(booking.getPresentationId());
        } else {
            this.numberLabel.setEnabled(false);
            this.numberText.setText("");
            this.enrolledCalendar.setDate(null);
            this.confirmedCalendar.setDate(null);
            this.billedCalendar.setDate(null);
            this.signedOffCalendar.setDate(null);
            this.messagedCalendar.setDate(null);
            this.companySelector.setSelectedId(0);
            this.presentationSelector.setSelectedId(0);
        }
        if (booking != null) {
            boolean alreadyEditing = CompanyBooking.lockedIds.contains(new Integer(booking.getId()));
            this.setInputComponentsEnabled(!alreadyEditing);
            if (!alreadyEditing) {
                CompanyBooking.lockedIds.add(new Integer(booking.getId()));
            }
        } else {
            this.setInputComponentsEnabled(true);
        }
        this.input = booking;
        this.inputChanged = booking == null;
        this.prevButton.setEnabled(this.input != null);
        this.nextButton.setEnabled(this.input != null);
        String shellText = this.input == null ? Messages.getString("GUIText.NewItemWindowTitleText") : this.input.getId() + " - " + this.input.getCompanyId() + ", " + this.input.getPresentationId();
        shellText = String.valueOf(shellText) + Messages.getString("GUIText.CompanyBookingWindowTitleText");
        if (this.input == null) {
            shellText = String.valueOf(shellText) + "*";
        }
        this.shell.setText(shellText);
        this.settingInput = false;
    }

    private void setInputComponentsEnabled(boolean enabled) {
        this.enrolledCalendar.setEnabled(enabled);
        this.confirmedCalendar.setEnabled(enabled);
        this.billedCalendar.setEnabled(enabled);
        this.signedOffCalendar.setEnabled(enabled);
        this.messagedCalendar.setEnabled(enabled);
        this.companySelector.setEnabled(enabled);
        this.presentationSelector.setEnabled(enabled);
        this.okButton.setEnabled(enabled);
        this.applyButton.setEnabled(enabled);
        this.newButton.setEnabled(enabled);
        this.abortButton.setEnabled(enabled);
        this.prevButton.setEnabled(enabled);
        this.nextButton.setEnabled(enabled);
        this.inputEditingEnabled = enabled;
    }

    private void createButtonListener(Composite buttons, final AssociationTabControl caller) {
        if (caller == null) {
            this.okButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (CompanyBookingWindow.this.onSave()) {
                        CompanyBookingWindow.this.shell.close();
                    }
                }
            });
            this.applyButton.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    CompanyBookingWindow.this.onSave();
                }
            });
        } else {
            this.okButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (CompanyBookingWindow.this.onSave()) {
                        caller.addSelectedIds(new SimpleIDKey[]{CompanyBookingWindow.this.input}, false);
                        CompanyBookingWindow.this.shell.close();
                    }
                }
            });
            this.applyButton.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    if (CompanyBookingWindow.this.onSave()) {
                        caller.addSelectedIds(new SimpleIDKey[]{CompanyBookingWindow.this.input}, false);
                    }
                }
            });
        }
        this.newButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (CompanyBookingWindow.this.onSave()) {
                    CompanyBookingWindow.this.setInput(null);
                }
            }
        });
        this.abortButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                CompanyBookingWindow.this.shell.close();
            }
        });
        this.prevButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (CompanyBookingWindow.this.inputChanged) {
                    if (CompanyBookingWindow.this.confirmClose()) {
                        CompanyBookingWindow.this.setInput(CompanyBooking.getPrevious(CompanyBookingWindow.this.input.getId()));
                    }
                } else {
                    CompanyBookingWindow.this.setInput(CompanyBooking.getPrevious(CompanyBookingWindow.this.input.getId()));
                }
            }
        });
        this.nextButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (CompanyBookingWindow.this.inputChanged) {
                    if (CompanyBookingWindow.this.confirmClose()) {
                        CompanyBookingWindow.this.setInput(CompanyBooking.getNext(CompanyBookingWindow.this.input.getId()));
                    }
                } else {
                    CompanyBookingWindow.this.setInput(CompanyBooking.getNext(CompanyBookingWindow.this.input.getId()));
                }
            }
        });
        this.messageButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                MessageDialog.openInformation((Shell)CompanyBookingWindow.this.shell, (String)Messages.getString("GUIText.NotImplementedMessageDialogWindowTitle"), (String)Messages.getString("GUIText.NotImplementedMessageDialogHintText"));
            }
        });
        this.billButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                MessageDialog.openInformation((Shell)CompanyBookingWindow.this.shell, (String)Messages.getString("GUIText.NotImplementedMessageDialogWindowTitle"), (String)Messages.getString("GUIText.NotImplementedMessageDialogHintText"));
            }
        });
        this.repaymentButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                MessageDialog.openInformation((Shell)CompanyBookingWindow.this.shell, (String)Messages.getString("GUIText.NotImplementedMessageDialogWindowTitle"), (String)Messages.getString("GUIText.NotImplementedMessageDialogHintText"));
            }
        });
        this.paymentBehaviorButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                MessageDialog.openInformation((Shell)CompanyBookingWindow.this.shell, (String)Messages.getString("GUIText.NotImplementedMessageDialogWindowTitle"), (String)Messages.getString("GUIText.NotImplementedMessageDialogHintText"));
            }
        });
    }

    protected boolean checkInput() {
        boolean inputOK = true;
        String errorMessage = "";
        if (this.companySelector.getSelectedId() == 0) {
            errorMessage = String.valueOf(errorMessage) + Messages.getString("GUIText.ErrorMessageDialogMandatoryAssociationCustomerText");
            inputOK = false;
        }
        if (this.presentationSelector.getSelectedId() == 0) {
            errorMessage = String.valueOf(errorMessage) + Messages.getString("GUIText.ErrorMessageDialogMandatoryAssociationCompanyInternalPresentationText");
            inputOK = false;
        }
        if (!inputOK) {
            MessageDialog.openInformation((Shell)this.shell, (String)Messages.getString("GUIText.ErrorMessageDialogMandatoryFieldWindowTitle"), (String)errorMessage);
        }
        return inputOK;
    }

    protected void commitInputToDB() {
        if (this.input == null) {
            try {
                CompanyBooking newInput;
                this.input = newInput = new CompanyBooking(0, this.enrolledCalendar.getDate(), this.confirmedCalendar.getDate(), this.billedCalendar.getDate(), this.signedOffCalendar.getDate(), this.messagedCalendar.getDate(), this.presentationSelector.getSelectedId(), this.companySelector.getSelectedId(), new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()));
                this.input.insertIntoDB();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            this.input.setEnrolled(this.enrolledCalendar.getDate());
            this.input.setConfirmed(this.confirmedCalendar.getDate());
            this.input.setBilled(this.billedCalendar.getDate());
            this.input.setSignedOff(this.signedOffCalendar.getDate());
            this.input.setMessaged(this.messagedCalendar.getDate());
            this.input.setPresentationId(this.presentationSelector.getSelectedId());
            this.input.setCompanyId(this.companySelector.getSelectedId());
            try {
                this.input.updateDB();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        CompanyBookingListWindow.instance.update();
    }

    private boolean confirmClose() {
        MessageDialog dlg = this.input == null ? new MessageDialog(this.shell, Messages.getString("GUIText.SaveNewItemMessageDialogWindowTitle"), null, Messages.getString("GUIText.SaveNewItemMessageDialogQuestionText"), 3, new String[]{Messages.getString("GUIText.SaveNewItemMessageDialogYesButtonText"), Messages.getString("GUIText.SaveNewItemMessageDialogNoButtonText"), Messages.getString("GUIText.SaveNewItemMessageDialogAbortButtonText")}, 0) : new MessageDialog(this.shell, Messages.getString("GUIText.SaveChangesMessageDialogWindowTitle"), null, Messages.getString("GUIText.SaveChangesMessageDialogQuestionText"), 3, new String[]{Messages.getString("GUIText.SaveChangesMessageDialogYesButtonText"), Messages.getString("GUIText.SaveChangesMessageDialogNoButtonText"), Messages.getString("GUIText.SaveChangesMessageDialogAbortButtonText")}, 0);
        switch (dlg.open()) {
            case 0: {
                return this.onSave();
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return true;
    }

    private boolean onSave() {
        if (!this.inputChanged) {
            return true;
        }
        if (this.checkInput()) {
            this.commitInputToDB();
            this.setInput(this.input);
            return true;
        }
        return false;
    }

    class InputChangedListener
    implements ModifyListener,
    SelectionListener,
    CalendarControl.SWTCalendarListener {
        InputChangedListener() {
        }

        private void inputChanged() {
            if (!CompanyBookingWindow.this.settingInput && !CompanyBookingWindow.this.inputChanged) {
                CompanyBookingWindow.this.inputChanged = true;
                CompanyBookingWindow.this.shell.setText(String.valueOf(CompanyBookingWindow.this.shell.getText()) + "*");
            }
        }

        public void modifyText(ModifyEvent e) {
            this.inputChanged();
        }

        public void widgetSelected(SelectionEvent e) {
            this.inputChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.inputChanged();
        }

        public void dateChanged(CalendarControl.SWTCalendarEvent event) {
            this.inputChanged();
        }
    }
}

