/*
 * Decompiled with CFR 0.152.
 */
package semorg.gui;

import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import semorg.gui.list.ClientBookingListWindow;
import semorg.gui.util.AssociationTabControl;
import semorg.gui.util.CalendarControl;
import semorg.gui.util.ForeignKeyConstraintSelector;
import semorg.gui.util.Messages;
import semorg.sql.tables.ClientBooking;
import semorg.sql.tables.SimpleIDKey;
import semorg.sql.util.Utility;

public class ClientBookingWindow {
    private ClientBooking input;
    private boolean settingInput = false;
    private boolean inputChanged;
    private boolean inputEditingEnabled;
    private InputChangedListener inputChangedListener = new InputChangedListener();
    private Shell shell;
    private int titleBarHeight;
    private final Label numberLabel;
    private final Text numberText;
    private final CalendarControl enrolledCalendar;
    private final CalendarControl confirmedCalendar;
    private final CalendarControl billedCalendar;
    private final CalendarControl signedOffCalendar;
    private final CalendarControl messagedCalendar;
    private final ForeignKeyConstraintSelector clientSelector;
    private final ForeignKeyConstraintSelector debitorSelector;
    private final ForeignKeyConstraintSelector presentationSelector;
    private final ForeignKeyConstraintSelector substituteSelector;
    private final Button okButton;
    private final Button applyButton;
    private final Button newButton;
    private final Button abortButton;
    private final Button prevButton;
    private final Button nextButton;
    private final Button messageButton;
    private final Button billButton;
    private final Button repaymentButton;
    private final Button paymentBehaviorButton;

    private ClientBookingWindow(Shell parent, AssociationTabControl caller) {
        this.shell = new Shell(parent, 64);
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                if (ClientBookingWindow.this.inputChanged) {
                    if (ClientBookingWindow.this.confirmClose()) {
                        if (ClientBookingWindow.this.inputEditingEnabled && ClientBookingWindow.this.input != null) {
                            ClientBooking.lockedIds.remove(new Integer(ClientBookingWindow.this.input.getId()));
                        }
                    } else {
                        event.doit = false;
                    }
                } else if (ClientBookingWindow.this.input != null && ClientBookingWindow.this.inputEditingEnabled) {
                    ClientBooking.lockedIds.remove(new Integer(ClientBookingWindow.this.input.getId()));
                }
            }
        });
        this.shell.setLayout((Layout)new GridLayout(1, false));
        this.shell.setSize(410, 470);
        this.shell.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"ClientBookingWindow");
        GridData mgd = new GridData();
        mgd.horizontalAlignment = 4;
        mgd.verticalAlignment = 4;
        mgd.grabExcessHorizontalSpace = true;
        mgd.grabExcessVerticalSpace = true;
        Group numberField = new Group((Composite)this.shell, 0);
        numberField.setLayout((Layout)new GridLayout(1, false));
        GridData numberFieldGridData = new GridData();
        numberFieldGridData.horizontalAlignment = 2;
        numberFieldGridData.grabExcessHorizontalSpace = true;
        numberFieldGridData.grabExcessVerticalSpace = true;
        numberField.setLayoutData((Object)numberFieldGridData);
        Group dateField = new Group((Composite)this.shell, 0);
        dateField.setLayout((Layout)new GridLayout(2, false));
        GridData dateFieldGridData = new GridData();
        dateFieldGridData.horizontalAlignment = 2;
        dateFieldGridData.grabExcessHorizontalSpace = true;
        dateField.setLayoutData((Object)dateFieldGridData);
        Group connectionField = new Group((Composite)this.shell, 0);
        connectionField.setLayout((Layout)new GridLayout(2, false));
        GridData connectionFieldGridData = new GridData();
        connectionFieldGridData.horizontalAlignment = 4;
        connectionFieldGridData.grabExcessHorizontalSpace = true;
        connectionField.setLayoutData((Object)connectionFieldGridData);
        this.numberLabel = new Label((Composite)numberField, 8);
        this.numberLabel.setText(Messages.getString("GUIText.NumberText"));
        this.numberText = new Text((Composite)numberField, 2060);
        this.numberText.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"NumberText");
        Utility.setLength(this.numberText, 10);
        this.numberText.addModifyListener((ModifyListener)this.inputChangedListener);
        this.numberText.setToolTipText(Messages.getString("GUIText.NumberToolTip"));
        Label enrolledLabel = new Label((Composite)dateField, 8);
        enrolledLabel.setText(Messages.getString("GUIText.EnrolledText"));
        Utility.alignRight((Control)enrolledLabel);
        this.enrolledCalendar = new CalendarControl((Composite)dateField, this.titleBarHeight);
        this.enrolledCalendar.setData("ATOSJ_COMPONENT_NAME_KEY", "EnrolledCalendar");
        this.enrolledCalendar.addSWTCalendarlistener(this.inputChangedListener);
        Label confirmedLabel = new Label((Composite)dateField, 8);
        confirmedLabel.setText(Messages.getString("GUIText.ConfirmedText"));
        Utility.alignRight((Control)confirmedLabel);
        this.confirmedCalendar = new CalendarControl((Composite)dateField, this.titleBarHeight);
        this.confirmedCalendar.setData("ATOSJ_COMPONENT_NAME_KEY", "ConfirmedCalendar");
        this.confirmedCalendar.addSWTCalendarlistener(this.inputChangedListener);
        Label billedLabel = new Label((Composite)dateField, 8);
        billedLabel.setText(Messages.getString("GUIText.BilledText"));
        Utility.alignRight((Control)billedLabel);
        this.billedCalendar = new CalendarControl((Composite)dateField, this.titleBarHeight);
        this.billedCalendar.setData("ATOSJ_COMPONENT_NAME_KEY", "BilledCalendar");
        this.billedCalendar.addSWTCalendarlistener(this.inputChangedListener);
        Label signedOffLabel = new Label((Composite)dateField, 8);
        signedOffLabel.setText(Messages.getString("GUIText.SignedOffText"));
        Utility.alignRight((Control)signedOffLabel);
        this.signedOffCalendar = new CalendarControl((Composite)dateField, this.titleBarHeight);
        this.signedOffCalendar.setData("ATOSJ_COMPONENT_NAME_KEY", "SignedOffCalendar");
        this.signedOffCalendar.addSWTCalendarlistener(this.inputChangedListener);
        Label messagedLabel = new Label((Composite)dateField, 8);
        messagedLabel.setText(Messages.getString("GUIText.MessagedText"));
        Utility.alignRight((Control)messagedLabel);
        this.messagedCalendar = new CalendarControl((Composite)dateField, this.titleBarHeight);
        this.messagedCalendar.setData("ATOSJ_COMPONENT_NAME_KEY", "MessagedCalendar");
        this.messagedCalendar.addSWTCalendarlistener(this.inputChangedListener);
        Label clientLabel = new Label((Composite)connectionField, 0);
        clientLabel.setText(Messages.getString("GUIText.ParticipantText"));
        Utility.alignRight((Control)clientLabel);
        this.clientSelector = new ForeignKeyConstraintSelector((Composite)connectionField, 2);
        this.clientSelector.setData("ATOSJ_COMPONENT_NAME_KEY", "ClientSelector");
        this.clientSelector.addModifyListener(this.inputChangedListener);
        Label debitorLabel = new Label((Composite)connectionField, 0);
        debitorLabel.setText(Messages.getString("GUIText.DebitorText"));
        Utility.alignRight((Control)debitorLabel);
        this.debitorSelector = new ForeignKeyConstraintSelector((Composite)connectionField, 2);
        this.debitorSelector.setData("ATOSJ_COMPONENT_NAME_KEY", "DebitorSelector");
        this.debitorSelector.addModifyListener(this.inputChangedListener);
        Label presentationLabel = new Label((Composite)connectionField, 0);
        presentationLabel.setText(Messages.getString("GUIText.PublicPresentationText"));
        Utility.alignRight((Control)presentationLabel);
        this.presentationSelector = new ForeignKeyConstraintSelector((Composite)connectionField, 5);
        this.presentationSelector.setData("ATOSJ_COMPONENT_NAME_KEY", "PresentationSelector");
        this.presentationSelector.addModifyListener(this.inputChangedListener);
        Label substituteLabel = new Label((Composite)connectionField, 0);
        substituteLabel.setText(Messages.getString("GUIText.SubstituteText"));
        Utility.alignRight((Control)substituteLabel);
        this.substituteSelector = new ForeignKeyConstraintSelector((Composite)connectionField, 2);
        this.substituteSelector.setData("ATOSJ_COMPONENT_NAME_KEY", "SubstituteSelector");
        this.substituteSelector.addModifyListener(this.inputChangedListener);
        Composite newButtons = new Composite((Composite)this.shell, this.shell.getStyle());
        GridLayout newButtonsLayout = new GridLayout(7, false);
        newButtonsLayout.marginBottom = 5;
        newButtons.setLayout((Layout)newButtonsLayout);
        GridData newButtonsLayoutData = new GridData();
        newButtonsLayoutData.horizontalAlignment = 2;
        newButtons.setLayoutData((Object)newButtonsLayoutData);
        this.messageButton = new Button(newButtons, 8);
        this.messageButton.setText(Messages.getString("GUIText.MessageButtonText"));
        this.messageButton.setLayoutData((Object)new GridData(528));
        this.billButton = new Button(newButtons, 8);
        this.billButton.setText(Messages.getString("GUIText.BillButtonText"));
        this.billButton.setLayoutData((Object)new GridData(528));
        this.repaymentButton = new Button(newButtons, 8);
        this.repaymentButton.setText(Messages.getString("GUIText.RepaymentButtonText"));
        this.repaymentButton.setLayoutData((Object)new GridData(528));
        this.paymentBehaviorButton = new Button(newButtons, 8);
        this.paymentBehaviorButton.setText(Messages.getString("GUIText.PaymentBehaviorButtonText"));
        this.paymentBehaviorButton.setLayoutData((Object)new GridData(528));
        Composite buttons = new Composite((Composite)this.shell, this.shell.getStyle());
        GridLayout buttonsLayout = new GridLayout(7, false);
        buttons.setLayout((Layout)buttonsLayout);
        GridData buttonsLayoutData = new GridData();
        buttonsLayoutData.horizontalAlignment = 2;
        buttons.setLayoutData((Object)buttonsLayoutData);
        this.okButton = new Button(buttons, 8);
        this.okButton.setText(Messages.getString("GUIText.OkButtonText"));
        this.okButton.setLayoutData((Object)new GridData(1040));
        this.applyButton = new Button(buttons, 8);
        this.applyButton.setText(Messages.getString("GUIText.ApplyButtonText"));
        this.applyButton.setLayoutData((Object)new GridData(1040));
        this.newButton = new Button(buttons, 8);
        this.newButton.setText(Messages.getString("GUIText.NewButtonText"));
        this.newButton.setLayoutData((Object)new GridData(1040));
        this.abortButton = new Button(buttons, 8);
        this.abortButton.setText(Messages.getString("GUIText.AbortButtonText"));
        this.abortButton.setLayoutData((Object)new GridData(1040));
        GridData arrowButtonGridData = new GridData();
        arrowButtonGridData.verticalAlignment = 4;
        arrowButtonGridData.grabExcessVerticalSpace = true;
        arrowButtonGridData.widthHint = 23;
        this.prevButton = new Button(buttons, 16388);
        this.prevButton.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"Previous");
        this.prevButton.setLayoutData((Object)arrowButtonGridData);
        this.nextButton = new Button(buttons, 131076);
        this.nextButton.setData("ATOSJ_COMPONENT_NAME_KEY", (Object)"Next");
        this.nextButton.setLayoutData((Object)arrowButtonGridData);
        this.createButtonListener(buttons, caller);
    }

    public ClientBookingWindow(Shell parent, ClientBooking input, AssociationTabControl caller) {
        this(parent, caller);
        this.setInput(input);
        this.shell.open();
    }

    private void setInput(ClientBooking booking) {
        this.settingInput = true;
        this.enrolledCalendar.setFocus();
        if (this.input != null && this.inputEditingEnabled) {
            ClientBooking.lockedIds.remove(new Integer(this.input.getId()));
        }
        if (booking != null) {
            this.numberLabel.setEnabled(true);
            this.numberText.setText(Integer.toString(booking.getId()));
            this.enrolledCalendar.setDate(booking.getEnrolled());
            this.confirmedCalendar.setDate(booking.getConfirmed());
            this.billedCalendar.setDate(booking.getBilled());
            this.signedOffCalendar.setDate(booking.getSignedOff());
            this.messagedCalendar.setDate(booking.getMessaged());
            this.clientSelector.setSelectedId(booking.getClientId());
            this.debitorSelector.setSelectedId(booking.getDebitorId());
            this.presentationSelector.setSelectedId(booking.getPresentationId());
            this.substituteSelector.setSelectedId(booking.getSubstituteId());
        } else {
            this.numberLabel.setEnabled(false);
            this.numberText.setText("");
            this.enrolledCalendar.setDate(null);
            this.confirmedCalendar.setDate(null);
            this.billedCalendar.setDate(null);
            this.signedOffCalendar.setDate(null);
            this.messagedCalendar.setDate(null);
            this.clientSelector.setSelectedId(0);
            this.debitorSelector.setSelectedId(0);
            this.presentationSelector.setSelectedId(0);
            this.substituteSelector.setSelectedId(0);
        }
        if (booking != null) {
            boolean alreadyEditing = ClientBooking.lockedIds.contains(new Integer(booking.getId()));
            this.setInputComponentsEnabled(!alreadyEditing);
            if (!alreadyEditing) {
                ClientBooking.lockedIds.add(new Integer(booking.getId()));
            }
        } else {
            this.setInputComponentsEnabled(true);
        }
        this.input = booking;
        this.inputChanged = booking == null;
        this.prevButton.setEnabled(this.input != null);
        this.nextButton.setEnabled(this.input != null);
        String shellText = this.input == null ? Messages.getString("GUIText.NewItemWindowTitleText") : this.input.getId() + " - " + this.input.getClientId() + ", " + this.input.getPresentationId();
        shellText = String.valueOf(shellText) + Messages.getString("GUIText.ClientBookingWindowTitleText");
        if (this.input == null) {
            shellText = String.valueOf(shellText) + "*";
        }
        this.shell.setText(shellText);
        this.settingInput = false;
    }

    private void setInputComponentsEnabled(boolean enabled) {
        this.enrolledCalendar.setEnabled(enabled);
        this.confirmedCalendar.setEnabled(enabled);
        this.billedCalendar.setEnabled(enabled);
        this.signedOffCalendar.setEnabled(enabled);
        this.messagedCalendar.setEnabled(enabled);
        this.clientSelector.setEnabled(enabled);
        this.debitorSelector.setEnabled(enabled);
        this.presentationSelector.setEnabled(enabled);
        this.okButton.setEnabled(enabled);
        this.applyButton.setEnabled(enabled);
        this.newButton.setEnabled(enabled);
        this.abortButton.setEnabled(enabled);
        this.prevButton.setEnabled(enabled);
        this.nextButton.setEnabled(enabled);
        this.inputEditingEnabled = enabled;
    }

    private void createButtonListener(Composite buttons, final AssociationTabControl caller) {
        if (caller == null) {
            this.okButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (ClientBookingWindow.this.onSave()) {
                        ClientBookingWindow.this.shell.close();
                    }
                }
            });
            this.applyButton.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    ClientBookingWindow.this.onSave();
                }
            });
        } else {
            this.okButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (ClientBookingWindow.this.onSave()) {
                        caller.addSelectedIds(new SimpleIDKey[]{ClientBookingWindow.this.input}, false);
                        ClientBookingWindow.this.shell.close();
                    }
                }
            });
            this.applyButton.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    if (ClientBookingWindow.this.onSave()) {
                        caller.addSelectedIds(new SimpleIDKey[]{ClientBookingWindow.this.input}, false);
                    }
                }
            });
        }
        this.newButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (ClientBookingWindow.this.onSave()) {
                    ClientBookingWindow.this.setInput(null);
                }
            }
        });
        this.abortButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ClientBookingWindow.this.shell.close();
            }
        });
        this.prevButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (ClientBookingWindow.this.inputChanged) {
                    if (ClientBookingWindow.this.confirmClose()) {
                        ClientBookingWindow.this.setInput(ClientBooking.getPrevious(ClientBookingWindow.this.input.getId()));
                    }
                } else {
                    ClientBookingWindow.this.setInput(ClientBooking.getPrevious(ClientBookingWindow.this.input.getId()));
                }
            }
        });
        this.nextButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (ClientBookingWindow.this.inputChanged) {
                    if (ClientBookingWindow.this.confirmClose()) {
                        ClientBookingWindow.this.setInput(ClientBooking.getNext(ClientBookingWindow.this.input.getId()));
                    }
                } else {
                    ClientBookingWindow.this.setInput(ClientBooking.getNext(ClientBookingWindow.this.input.getId()));
                }
            }
        });
        this.messageButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                MessageDialog.openInformation((Shell)ClientBookingWindow.this.shell, (String)Messages.getString("GUIText.NotImplementedMessageDialogWindowTitle"), (String)Messages.getString("GUIText.NotImplementedMessageDialogHintText"));
            }
        });
        this.billButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                MessageDialog.openInformation((Shell)ClientBookingWindow.this.shell, (String)Messages.getString("GUIText.NotImplementedMessageDialogWindowTitle"), (String)Messages.getString("GUIText.NotImplementedMessageDialogHintText"));
            }
        });
        this.repaymentButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                MessageDialog.openInformation((Shell)ClientBookingWindow.this.shell, (String)Messages.getString("GUIText.NotImplementedMessageDialogWindowTitle"), (String)Messages.getString("GUIText.NotImplementedMessageDialogHintText"));
            }
        });
        this.paymentBehaviorButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                MessageDialog.openInformation((Shell)ClientBookingWindow.this.shell, (String)Messages.getString("GUIText.NotImplementedMessageDialogWindowTitle"), (String)Messages.getString("GUIText.NotImplementedMessageDialogHintText"));
            }
        });
    }

    protected boolean checkInput() {
        boolean inputOK = true;
        String errorMessage = "";
        if (this.clientSelector.getSelectedId() == 0) {
            errorMessage = String.valueOf(errorMessage);
            inputOK = false;
        }
        if (this.presentationSelector.getSelectedId() == 0) {
            errorMessage = String.valueOf(errorMessage) + Messages.getString("GUIText.ErrorMessageDialogMandatoryAssociationPublicPresentationText");
            inputOK = false;
        }
        if (!inputOK) {
            MessageDialog.openInformation((Shell)this.shell, (String)Messages.getString("GUIText.ErrorMessageDialogMandatoryFieldWindowTitle"), (String)errorMessage);
        }
        return inputOK;
    }

    protected void commitInputToDB() {
        if (this.input == null) {
            try {
                ClientBooking newInput;
                this.input = newInput = new ClientBooking(0, this.enrolledCalendar.getDate(), this.confirmedCalendar.getDate(), this.billedCalendar.getDate(), this.signedOffCalendar.getDate(), this.messagedCalendar.getDate(), this.presentationSelector.getSelectedId(), this.clientSelector.getSelectedId(), this.debitorSelector.getSelectedId(), this.substituteSelector.getSelectedId(), new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()));
                this.input.insertIntoDB();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            this.input.setEnrolled(this.enrolledCalendar.getDate());
            this.input.setConfirmed(this.confirmedCalendar.getDate());
            this.input.setBilled(this.billedCalendar.getDate());
            this.input.setSignedOff(this.signedOffCalendar.getDate());
            this.input.setMessaged(this.messagedCalendar.getDate());
            this.input.setPresentationId(this.presentationSelector.getSelectedId());
            this.input.setClientId(this.clientSelector.getSelectedId());
            this.input.setDebitorId(this.debitorSelector.getSelectedId());
            this.input.setSubstituteId(this.substituteSelector.getSelectedId());
            try {
                this.input.updateDB();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        ClientBookingListWindow.instance.update();
    }

    private boolean confirmClose() {
        MessageDialog dlg = this.input == null ? new MessageDialog(this.shell, Messages.getString("GUIText.SaveNewItemMessageDialogWindowTitle"), null, Messages.getString("GUIText.SaveNewItemMessageDialogQuestionText"), 3, new String[]{Messages.getString("GUIText.SaveNewItemMessageDialogYesButtonText"), Messages.getString("GUIText.SaveNewItemMessageDialogNoButtonText"), Messages.getString("GUIText.SaveNewItemMessageDialogAbortButtonText")}, 0) : new MessageDialog(this.shell, Messages.getString("GUIText.SaveChangesMessageDialogWindowTitle"), null, Messages.getString("GUIText.SaveChangesMessageDialogQuestionText"), 3, new String[]{Messages.getString("GUIText.SaveChangesMessageDialogYesButtonText"), Messages.getString("GUIText.SaveChangesMessageDialogNoButtonText"), Messages.getString("GUIText.SaveChangesMessageDialogAbortButtonText")}, 0);
        switch (dlg.open()) {
            case 0: {
                return this.onSave();
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return true;
    }

    private boolean onSave() {
        if (!this.inputChanged) {
            return true;
        }
        if (this.checkInput()) {
            this.commitInputToDB();
            this.setInput(this.input);
            return true;
        }
        return false;
    }

    class InputChangedListener
    implements ModifyListener,
    SelectionListener,
    CalendarControl.SWTCalendarListener {
        InputChangedListener() {
        }

        private void inputChanged() {
            if (!ClientBookingWindow.this.settingInput && !ClientBookingWindow.this.inputChanged) {
                ClientBookingWindow.this.inputChanged = true;
                ClientBookingWindow.this.shell.setText(String.valueOf(ClientBookingWindow.this.shell.getText()) + "*");
            }
        }

        public void modifyText(ModifyEvent e) {
            this.inputChanged();
        }

        public void widgetSelected(SelectionEvent e) {
            this.inputChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.inputChanged();
        }

        public void dateChanged(CalendarControl.SWTCalendarEvent event) {
            this.inputChanged();
        }
    }
}

