/*
 * Decompiled with CFR 0.152.
 */
package semorg.conf;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class Configuration {
    private Properties huSemOrgProperties = new Properties();
    private static final String huSemOrgConfFile = "conf/husemorg.properties";

    public Configuration() {
        try {
            FileInputStream confInFile = new FileInputStream(huSemOrgConfFile);
            this.huSemOrgProperties.load(confInFile);
        }
        catch (FileNotFoundException e) {
            System.err.println("Configuration file conf/husemorg.properties was not found and will now be created.");
            this.makeStdConfiguration();
        }
        catch (IOException e) {
            System.err.println("Loading of the configuration failed. An IO error occured.");
            e.printStackTrace();
        }
    }

    private void saveConfiguration() {
        try {
            FileOutputStream confInFile = new FileOutputStream(huSemOrgConfFile);
            this.huSemOrgProperties.store(confInFile, "Note the language is set with ISO 639 standard.\nLast Change: ");
        }
        catch (IOException e) {
            System.err.println("Saving of the configuration failed. An IO error occured.");
            e.printStackTrace();
        }
    }

    private void makeStdConfiguration() {
        this.huSemOrgProperties.setProperty("language", "en");
        this.huSemOrgProperties.setProperty("background", "back_en.png");
        this.huSemOrgProperties.setProperty("selectLanguage", "disabled");
        this.saveConfiguration();
    }

    public void setProperty(String key, String value) {
        this.huSemOrgProperties.setProperty(key, value);
        this.saveConfiguration();
    }

    public String getProperty(String key) {
        return this.huSemOrgProperties.getProperty(key);
    }
}

