% Extract 10 OFDM frames to be transmitted
sig = transpose( tx_sig(1:10*3840) );

filename = 'TX.bin';
repetitions = 1;
guard = length(sig);

max_int_val = round(32768*0.5);

fid = fopen(filename, 'w');

in = real(sig);
qu = imag(sig);

sig_vec_c = [in ; qu];
max_abs = max(abs([in qu]));

sig_vec = (max_int_val/max_abs)*reshape(sig_vec_c, 1, []);

sig_vec_2 = [];

for i = 1:repetitions
    sig_vec_2 = [sig_vec_2 sig_vec zeros(1, 2*guard)];
end

fwrite(fid, sig_vec_2, 'short');
fclose(fid);




