function [ rx_sig ] = rx_read( filename )
%UNTITLED Summary of this function goes here
%   Detailed explanation goes here

fid = fopen(filename, 'r');
sig_vec = fread(fid, [2 inf], 'short');

clear rx_sig
rx_sig = sig_vec(1, :) + j*sig_vec(2, :);

fclose(fid);

load('OFDM_preamble.mat');

% Detect start of burst of 10 OFDM frames
xc = xcorr( rx_sig, OFDM_preamble);
xc = xc( end-length( rx_sig )+1:end );
%figure; plot( abs( xc ) );
xc = xc ./ max( abs( xc ) );
[~, ids] = findpeaks(abs(xc), 'MinPeakHeight', 0.8*max(abs(xc)) );
for i = 1 : 1 : length( ids ) - 9
    maxval = max( ids( i+1:i+9 ) - ids( i:i+8 ) );
    minval = min( ids( i+1:i+9 ) - ids( i:i+8 ) );
    if(  abs( minval ) > 0.8 * 3840 && abs( maxval ) < 1.2 * 3840 )
        loc = ids( i );
        break;
    end;
end;

% Extract length of 10 OFDM frames
rx_sig = rx_sig( loc - 320 : loc - 320 + 38400 );
% Normalize rx_sig
rx_sig = rx_sig ./ max( abs( rx_sig ) ); 

% High-pass filtering to remove low frequency RF impairment component
HF = dsp.HighpassFilter('SampleRate',20e6,'PassbandFrequency',50e3);
rx_sig = step( HF, transpose( rx_sig ) );

% Plot check
figure; plot( real( rx_sig) ); hold; plot( imag( rx_sig ) );

% % Check rx_sig spectrum after HP filtering
% sig = rx_sig;%(1,1:2^8); % for debugging only
% N = length( sig );
% fs = 20e6;
% x_axis = [0:N-1].*fs/N - 0;
% % Plot magnitude of RX1 spectrum normalized to carrier level
% figure; plot(x_axis, fftshift(20*log10(abs(fft(sig))./max(abs(fft(sig))))));
% %xlim([-2e7 2e7]);
% % ylim([-100 10]);
% grid on;
% title('RX1 freq.spectrum');
% ylabel('Magnitude in dB');
% xlabel('Frequency in Hz');
% ylim([-120 0]);

end